/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFRange;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreFoundation")
public class CFBitVector
extends CFType {
    private static final int EFFECTIVE_DIRECT_ADDRESS_OFFSET;

    static long getEffectiveAddress(ByteBuffer bytes) {
        if (!bytes.isDirect()) {
            throw new IllegalArgumentException("Direct ByteBuffer expected");
        }
        return VM.getLong((long)(VM.getObjectAddress((Object)bytes) + (long)EFFECTIVE_DIRECT_ADDRESS_OFFSET));
    }

    protected CFBitVector() {
    }

    public static CFBitVector create(byte[] bytes) {
        return CFBitVector.create(null, bytes);
    }

    public static CFBitVector create(CFAllocator allocator, byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        return CFBitVector.create(allocator, VM.getArrayValuesAddress((Object)bytes), bytes.length);
    }

    public static CFBitVector create(ByteBuffer bytes) {
        return CFBitVector.create(null, bytes);
    }

    public static CFBitVector create(CFAllocator allocator, ByteBuffer bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        long handle = CFBitVector.getEffectiveAddress(bytes) + (long)bytes.position();
        CFBitVector result = CFBitVector.create(allocator, handle, bytes.remaining());
        return result;
    }

    public static CFBitVector createCopy(CFBitVector bv) {
        return CFBitVector.createCopy(null, bv);
    }

    public byte[] getBytes() {
        int length = (int)this.getCount();
        byte[] bytes = new byte[length];
        this.getBits(new CFRange(0L, length), VM.getArrayValuesAddress((Object)bytes));
        return bytes;
    }

    @Bridge(symbol="CFBitVectorGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFBitVectorCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFBitVector create(CFAllocator var0, @Pointer long var1, @MachineSizedSInt long var3);

    @Bridge(symbol="CFBitVectorCreateCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFBitVector createCopy(CFAllocator var0, CFBitVector var1);

    @Bridge(symbol="CFBitVectorGetCount", optional=true)
    @MachineSizedSInt
    public native long getCount();

    @Bridge(symbol="CFBitVectorGetCountOfBit", optional=true)
    @MachineSizedSInt
    public native long getCountOfBit(@ByVal CFRange var1, int var2);

    @Bridge(symbol="CFBitVectorContainsBit", optional=true)
    public native boolean contains(@ByVal CFRange var1, int var2);

    @Bridge(symbol="CFBitVectorGetBitAtIndex", optional=true)
    public native int get(@MachineSizedSInt long var1);

    @Bridge(symbol="CFBitVectorGetBits", optional=true)
    private native void getBits(@ByVal CFRange var1, @Pointer long var2);

    @Bridge(symbol="CFBitVectorGetFirstIndexOfBit", optional=true)
    @MachineSizedSInt
    public native long indexOf(@ByVal CFRange var1, int var2);

    @Bridge(symbol="CFBitVectorGetLastIndexOfBit", optional=true)
    @MachineSizedSInt
    public native long lastIndexOf(@ByVal CFRange var1, int var2);

    static {
        try {
            Field f1 = Buffer.class.getDeclaredField("effectiveDirectAddress");
            if (f1.getType() != Long.TYPE) {
                throw new Error("java.nio.Buffer.effectiveDirectAddress should be a long");
            }
            EFFECTIVE_DIRECT_ADDRESS_OFFSET = VM.getInstanceFieldOffset((long)VM.getFieldAddress((Field)f1));
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        Bro.bind(CFBitVector.class);
    }

    public static class CFBitVectorPtr
    extends Ptr<CFBitVector, CFBitVectorPtr> {
    }
}

