/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFData;
import org.robovm.apple.corefoundation.CFPropertyListFormat;
import org.robovm.apple.corefoundation.CFPropertyListMutabilityOptions;
import org.robovm.apple.corefoundation.CFReadStream;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.corefoundation.CFWriteStream;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.MachineSizedSIntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreFoundation")
public abstract class CFPropertyList
extends CFType {
    public static CFPropertyList createDeepCopy(CFPropertyList propertyList, CFPropertyListMutabilityOptions mutabilityOption) {
        return CFPropertyList.createDeepCopy(null, propertyList, mutabilityOption);
    }

    public static CFPropertyList create(CFData data, @MachineSizedUInt long options) throws NSErrorException {
        return CFPropertyList.create(null, data, options, null);
    }

    public static CFPropertyList create(CFAllocator allocator, CFData data, @MachineSizedUInt long options) throws NSErrorException {
        return CFPropertyList.create(allocator, data, options, null);
    }

    public static CFPropertyList create(CFReadStream stream, @MachineSizedSInt long streamLength, @MachineSizedUInt long options) throws NSErrorException {
        return CFPropertyList.create(null, stream, streamLength, options, null);
    }

    public static CFPropertyList create(CFAllocator allocator, CFReadStream stream, @MachineSizedSInt long streamLength, @MachineSizedUInt long options) throws NSErrorException {
        return CFPropertyList.create(allocator, stream, streamLength, options, null);
    }

    public CFData asData(CFPropertyListFormat format, @MachineSizedUInt long options) throws NSErrorException {
        return CFPropertyList.asData(null, this, format, options);
    }

    public CFData asData(CFAllocator allocator, CFPropertyListFormat format, @MachineSizedUInt long options) throws NSErrorException {
        return CFPropertyList.asData(allocator, this, format, options);
    }

    @Bridge(symbol="CFPropertyListCreateDeepCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFPropertyList createDeepCopy(CFAllocator var0, CFPropertyList var1, CFPropertyListMutabilityOptions var2);

    @Bridge(symbol="CFPropertyListIsValid", optional=true)
    public native boolean isValid(CFPropertyListFormat var1);

    protected static CFPropertyList create(CFAllocator allocator, CFData data, @MachineSizedUInt long options, MachineSizedSIntPtr format) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        CFPropertyList result = CFPropertyList.create(allocator, data, options, format, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFPropertyListCreateWithData", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFPropertyList create(CFAllocator var0, CFData var1, @MachineSizedUInt long var2, MachineSizedSIntPtr var4, NSError.NSErrorPtr var5);

    protected static CFPropertyList create(CFAllocator allocator, CFReadStream stream, @MachineSizedSInt long streamLength, @MachineSizedUInt long options, MachineSizedSIntPtr format) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        CFPropertyList result = CFPropertyList.create(allocator, stream, streamLength, options, format, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFPropertyListCreateWithStream", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFPropertyList create(CFAllocator var0, CFReadStream var1, @MachineSizedSInt long var2, @MachineSizedUInt long var4, MachineSizedSIntPtr var6, NSError.NSErrorPtr var7);

    @MachineSizedSInt
    public long write(CFWriteStream stream, CFPropertyListFormat format, @MachineSizedUInt long options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long result = this.write(stream, format, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFPropertyListWrite", optional=true)
    @MachineSizedSInt
    private native long write(CFWriteStream var1, CFPropertyListFormat var2, @MachineSizedUInt long var3, NSError.NSErrorPtr var5);

    private static CFData asData(CFAllocator allocator, CFPropertyList propertyList, CFPropertyListFormat format, @MachineSizedUInt long options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        CFData result = CFPropertyList.asData(allocator, propertyList, format, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFPropertyListCreateData", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFData asData(CFAllocator var0, CFPropertyList var1, CFPropertyListFormat var2, @MachineSizedUInt long var3, NSError.NSErrorPtr var5);

    static {
        Bro.bind(CFPropertyList.class);
    }

    public static class CFPropertyListPtr
    extends Ptr<CFPropertyList, CFPropertyListPtr> {
    }
}

