/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFReadStream;
import org.robovm.apple.corefoundation.CFSocketSignature;
import org.robovm.apple.corefoundation.CFWriteStream;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;

@Library(value="CoreFoundation")
public class CFStreamPair
extends CocoaUtility {
    private CFReadStream readStream;
    private CFWriteStream writeStream;

    public static CFStreamPair create(@MachineSizedSInt long transferBufferSize) {
        CFReadStream.CFReadStreamPtr readPtr = new CFReadStream.CFReadStreamPtr();
        CFWriteStream.CFWriteStreamPtr writePtr = new CFWriteStream.CFWriteStreamPtr();
        CFStreamPair.create(null, readPtr, writePtr, transferBufferSize);
        CFStreamPair result = new CFStreamPair();
        result.readStream = (CFReadStream)readPtr.get();
        result.writeStream = (CFWriteStream)writePtr.get();
        return result;
    }

    public static CFStreamPair create(int sock) {
        CFReadStream.CFReadStreamPtr readPtr = new CFReadStream.CFReadStreamPtr();
        CFWriteStream.CFWriteStreamPtr writePtr = new CFWriteStream.CFWriteStreamPtr();
        CFStreamPair.create(null, sock, readPtr, writePtr);
        CFStreamPair result = new CFStreamPair();
        result.readStream = (CFReadStream)readPtr.get();
        result.writeStream = (CFWriteStream)writePtr.get();
        return result;
    }

    public static CFStreamPair create(String host, int port) {
        CFReadStream.CFReadStreamPtr readPtr = new CFReadStream.CFReadStreamPtr();
        CFWriteStream.CFWriteStreamPtr writePtr = new CFWriteStream.CFWriteStreamPtr();
        CFStreamPair.create(null, host, port, readPtr, writePtr);
        CFStreamPair result = new CFStreamPair();
        result.readStream = (CFReadStream)readPtr.get();
        result.writeStream = (CFWriteStream)writePtr.get();
        return result;
    }

    public static CFStreamPair create(CFSocketSignature signature) {
        CFReadStream.CFReadStreamPtr readPtr = new CFReadStream.CFReadStreamPtr();
        CFWriteStream.CFWriteStreamPtr writePtr = new CFWriteStream.CFWriteStreamPtr();
        CFStreamPair.create(null, signature, readPtr, writePtr);
        CFStreamPair result = new CFStreamPair();
        result.readStream = (CFReadStream)readPtr.get();
        result.writeStream = (CFWriteStream)writePtr.get();
        return result;
    }

    @Bridge(symbol="CFStreamCreateBoundPair", optional=true)
    protected static native void create(CFAllocator var0, CFReadStream.CFReadStreamPtr var1, CFWriteStream.CFWriteStreamPtr var2, @MachineSizedSInt long var3);

    @Bridge(symbol="CFStreamCreatePairWithSocket", optional=true)
    protected static native void create(CFAllocator var0, int var1, CFReadStream.CFReadStreamPtr var2, CFWriteStream.CFWriteStreamPtr var3);

    @Bridge(symbol="CFStreamCreatePairWithSocketToHost", optional=true)
    protected static native void create(CFAllocator var0, String var1, int var2, CFReadStream.CFReadStreamPtr var3, CFWriteStream.CFWriteStreamPtr var4);

    @Bridge(symbol="CFStreamCreatePairWithPeerSocketSignature", optional=true)
    protected static native void create(CFAllocator var0, CFSocketSignature var1, CFReadStream.CFReadStreamPtr var2, CFWriteStream.CFWriteStreamPtr var3);

    static {
        Bro.bind(CFStreamPair.class);
    }
}

