/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGColorSpaceModel;
import org.robovm.apple.coregraphics.CGDataProvider;
import org.robovm.apple.coregraphics.CoreGraphics;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreGraphics")
public class CGColorSpace
extends CFType {
    protected CGColorSpace() {
    }

    public static CGColorSpace createCalibratedGray(double[] whitePoint, double[] blackPoint, double gamma) {
        if (whitePoint == null) {
            throw new NullPointerException("whitePoint");
        }
        if (blackPoint == null) {
            throw new NullPointerException("blackPoint");
        }
        if (whitePoint.length != 3) {
            throw new IllegalArgumentException("whitePoint.length != 3 (" + whitePoint.length + ")");
        }
        if (blackPoint.length != 3) {
            throw new IllegalArgumentException("blackPoint.length != 3 (" + blackPoint.length + ")");
        }
        return CGColorSpace.createCalibratedGray(VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(whitePoint)), VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(blackPoint)), gamma);
    }

    public static CGColorSpace createCalibratedGray(float[] whitePoint, float[] blackPoint, double gamma) {
        if (whitePoint == null) {
            throw new NullPointerException("whitePoint");
        }
        if (blackPoint == null) {
            throw new NullPointerException("blackPoint");
        }
        if (whitePoint.length != 3) {
            throw new IllegalArgumentException("whitePoint.length != 3 (" + whitePoint.length + ")");
        }
        if (blackPoint.length != 3) {
            throw new IllegalArgumentException("blackPoint.length != 3 (" + blackPoint.length + ")");
        }
        return CGColorSpace.createCalibratedGray(VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(whitePoint)), VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(blackPoint)), gamma);
    }

    public static CGColorSpace createCalibratedRGB(double[] whitePoint, double[] blackPoint, double[] gamma, double[] matrix) {
        if (whitePoint == null) {
            throw new NullPointerException("whitePoint");
        }
        if (blackPoint == null) {
            throw new NullPointerException("blackPoint");
        }
        if (gamma == null) {
            throw new NullPointerException("gamma");
        }
        if (matrix == null) {
            throw new NullPointerException("matrix");
        }
        if (whitePoint.length != 3) {
            throw new IllegalArgumentException("whitePoint.length != 3 (" + whitePoint.length + ")");
        }
        if (blackPoint.length != 3) {
            throw new IllegalArgumentException("blackPoint.length != 3 (" + blackPoint.length + ")");
        }
        if (gamma.length != 3) {
            throw new IllegalArgumentException("gamma.length != 3 (" + gamma.length + ")");
        }
        if (matrix.length != 9) {
            throw new IllegalArgumentException("matrix.length != 9 (" + matrix.length + ")");
        }
        return CGColorSpace.createCalibratedRGB(VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(whitePoint)), VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(blackPoint)), VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(gamma)), VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(matrix)));
    }

    public static CGColorSpace createCalibratedRGB(float[] whitePoint, float[] blackPoint, float[] gamma, float[] matrix) {
        if (whitePoint == null) {
            throw new NullPointerException("whitePoint");
        }
        if (blackPoint == null) {
            throw new NullPointerException("blackPoint");
        }
        if (gamma == null) {
            throw new NullPointerException("gamma");
        }
        if (matrix == null) {
            throw new NullPointerException("matrix");
        }
        if (whitePoint.length != 3) {
            throw new IllegalArgumentException("whitePoint.length != 3 (" + whitePoint.length + ")");
        }
        if (blackPoint.length != 3) {
            throw new IllegalArgumentException("blackPoint.length != 3 (" + blackPoint.length + ")");
        }
        if (gamma.length != 3) {
            throw new IllegalArgumentException("gamma.length != 3 (" + gamma.length + ")");
        }
        if (matrix.length != 9) {
            throw new IllegalArgumentException("matrix.length != 9 (" + matrix.length + ")");
        }
        return CGColorSpace.createCalibratedRGB(VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(whitePoint)), VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(blackPoint)), VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(gamma)), VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(matrix)));
    }

    public static CGColorSpace createICCBased(long nComponents, double[] range, CGDataProvider profile, CGColorSpace alternate) {
        if (range == null) {
            throw new NullPointerException("range");
        }
        if ((long)range.length != nComponents * 2L) {
            throw new IllegalArgumentException("range.length != " + nComponents * 2L + " (" + range.length + ")");
        }
        return CGColorSpace.createICCBased(nComponents, VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(range)), profile, alternate);
    }

    public static CGColorSpace createICCBased(long nComponents, float[] range, CGDataProvider profile, CGColorSpace alternate) {
        if (range == null) {
            throw new NullPointerException("range");
        }
        if ((long)range.length != nComponents * 2L) {
            throw new IllegalArgumentException("range.length != " + nComponents * 2L + " (" + range.length + ")");
        }
        return CGColorSpace.createICCBased(nComponents, VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(range)), profile, alternate);
    }

    public static CGColorSpace createLab(double[] whitePoint, double[] blackPoint, double[] range) {
        if (whitePoint == null) {
            throw new NullPointerException("whitePoint");
        }
        if (blackPoint == null) {
            throw new NullPointerException("blackPoint");
        }
        if (range == null) {
            throw new NullPointerException("range");
        }
        if (whitePoint.length != 3) {
            throw new IllegalArgumentException("whitePoint.length != 3 (" + whitePoint.length + ")");
        }
        if (blackPoint.length != 3) {
            throw new IllegalArgumentException("blackPoint.length != 3 (" + blackPoint.length + ")");
        }
        if (range.length != 4) {
            throw new IllegalArgumentException("range.length != 4 (" + range.length + ")");
        }
        return CGColorSpace.createLab(VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(whitePoint)), VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(blackPoint)), VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(range)));
    }

    public static CGColorSpace createLab(float[] whitePoint, float[] blackPoint, float[] range) {
        if (whitePoint == null) {
            throw new NullPointerException("whitePoint");
        }
        if (blackPoint == null) {
            throw new NullPointerException("blackPoint");
        }
        if (range == null) {
            throw new NullPointerException("range");
        }
        if (whitePoint.length != 3) {
            throw new IllegalArgumentException("whitePoint.length != 3 (" + whitePoint.length + ")");
        }
        if (blackPoint.length != 3) {
            throw new IllegalArgumentException("blackPoint.length != 3 (" + blackPoint.length + ")");
        }
        if (range.length != 4) {
            throw new IllegalArgumentException("range.length != 4 (" + range.length + ")");
        }
        return CGColorSpace.createLab(VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(whitePoint)), VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(blackPoint)), VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(range)));
    }

    public static CGColorSpace createIndexed(CGColorSpace baseSpace, long lastIndex, byte[] colorTable) {
        if (baseSpace == null) {
            throw new NullPointerException("baseSpace");
        }
        if (colorTable == null) {
            throw new NullPointerException("colorTable");
        }
        long m = baseSpace.getNumberOfComponents();
        if ((long)colorTable.length != m * (lastIndex + 1L)) {
            throw new IllegalArgumentException("colorTable.length != " + m * (lastIndex + 1L) + " (" + colorTable.length + ")");
        }
        return CGColorSpace.createIndexed(baseSpace, lastIndex, VM.getArrayValuesAddress((Object)colorTable));
    }

    public byte[] getColorTable() {
        long len = this.getColorTableCount();
        if (len == 0L) {
            throw new IllegalStateException("Not an indexed color space");
        }
        byte[] table = new byte[(int)len];
        this.getColorTable(VM.getArrayValuesAddress((Object)table));
        return table;
    }

    @GlobalValue(symbol="kCGColorSpaceGenericGray", optional=true)
    public static native String GenericGray();

    @GlobalValue(symbol="kCGColorSpaceGenericRGB", optional=true)
    public static native String GenericRGB();

    @GlobalValue(symbol="kCGColorSpaceGenericCMYK", optional=true)
    public static native String GenericCMYK();

    @GlobalValue(symbol="kCGColorSpaceDisplayP3", optional=true)
    public static native String DisplayP3();

    @GlobalValue(symbol="kCGColorSpaceGenericRGBLinear", optional=true)
    public static native String GenericRGBLinear();

    @GlobalValue(symbol="kCGColorSpaceAdobeRGB1998", optional=true)
    public static native String AdobeRGB1998();

    @GlobalValue(symbol="kCGColorSpaceSRGB", optional=true)
    public static native String SRGB();

    @GlobalValue(symbol="kCGColorSpaceGenericGrayGamma2_2", optional=true)
    public static native String GenericGrayGamma2_2();

    @GlobalValue(symbol="kCGColorSpaceGenericXYZ", optional=true)
    public static native String GenericXYZ();

    @GlobalValue(symbol="kCGColorSpaceGenericLab", optional=true)
    public static native String GenericLab();

    @GlobalValue(symbol="kCGColorSpaceACESCGLinear", optional=true)
    public static native String ACESCGLinear();

    @GlobalValue(symbol="kCGColorSpaceITUR_709", optional=true)
    public static native String ITUR_709();

    @GlobalValue(symbol="kCGColorSpaceITUR_2020", optional=true)
    public static native String ITUR_2020();

    @GlobalValue(symbol="kCGColorSpaceROMMRGB", optional=true)
    public static native String ROMMRGB();

    @GlobalValue(symbol="kCGColorSpaceDCIP3", optional=true)
    public static native String DCIP3();

    @GlobalValue(symbol="kCGColorSpaceExtendedITUR_2020", optional=true)
    public static native String ExtendedITUR_2020();

    @GlobalValue(symbol="kCGColorSpaceExtendedLinearITUR_2020", optional=true)
    public static native String ExtendedLinearITUR_2020();

    @GlobalValue(symbol="kCGColorSpaceExtendedDisplayP3", optional=true)
    public static native String ExtendedDisplayP3();

    @GlobalValue(symbol="kCGColorSpaceExtendedLinearDisplayP3", optional=true)
    public static native String ExtendedLinearDisplayP3();

    @GlobalValue(symbol="kCGColorSpaceITUR_2100_PQ", optional=true)
    public static native String ITUR_2100_PQ();

    @GlobalValue(symbol="kCGColorSpaceITUR_2100_HLG", optional=true)
    public static native String ITUR_2100_HLG();

    @GlobalValue(symbol="kCGColorSpaceDisplayP3_PQ", optional=true)
    public static native String DisplayP3_PQ();

    @GlobalValue(symbol="kCGColorSpaceDisplayP3_HLG", optional=true)
    public static native String DisplayP3_HLG();

    @Deprecated
    @GlobalValue(symbol="kCGColorSpaceITUR_2020_PQ", optional=true)
    public static native String ITUR_2020_PQ();

    @Deprecated
    @GlobalValue(symbol="kCGColorSpaceITUR_2020_HLG", optional=true)
    public static native String ITUR_2020_HLG();

    @Deprecated
    @GlobalValue(symbol="kCGColorSpaceDisplayP3_PQ_EOTF", optional=true)
    public static native String DisplayP3_PQ_EOTF();

    @Deprecated
    @GlobalValue(symbol="kCGColorSpaceITUR_2020_PQ_EOTF", optional=true)
    public static native String ITUR_2020_PQ_EOTF();

    @GlobalValue(symbol="kCGColorSpaceExtendedSRGB", optional=true)
    public static native String ExtendedSRGB();

    @GlobalValue(symbol="kCGColorSpaceLinearSRGB", optional=true)
    public static native String LinearSRGB();

    @GlobalValue(symbol="kCGColorSpaceExtendedLinearSRGB", optional=true)
    public static native String ExtendedLinearSRGB();

    @GlobalValue(symbol="kCGColorSpaceExtendedGray", optional=true)
    public static native String ExtendedGray();

    @GlobalValue(symbol="kCGColorSpaceLinearGray", optional=true)
    public static native String LinearGray();

    @GlobalValue(symbol="kCGColorSpaceExtendedLinearGray", optional=true)
    public static native String ExtendedLinearGray();

    @Bridge(symbol="CGColorSpaceCreateDeviceGray", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGColorSpace createDeviceGray();

    @Bridge(symbol="CGColorSpaceCreateDeviceRGB", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGColorSpace createDeviceRGB();

    @Bridge(symbol="CGColorSpaceCreateDeviceCMYK", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGColorSpace createDeviceCMYK();

    @Bridge(symbol="CGColorSpaceCreateCalibratedGray", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CGColorSpace createCalibratedGray(@Pointer long var0, @Pointer long var2, @MachineSizedFloat double var4);

    @Bridge(symbol="CGColorSpaceCreateCalibratedRGB", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CGColorSpace createCalibratedRGB(@Pointer long var0, @Pointer long var2, @Pointer long var4, @Pointer long var6);

    @Bridge(symbol="CGColorSpaceCreateLab", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CGColorSpace createLab(@Pointer long var0, @Pointer long var2, @Pointer long var4);

    @Bridge(symbol="CGColorSpaceCreateWithICCData", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGColorSpace createWithICCData(CFType var0);

    @Bridge(symbol="CGColorSpaceCreateICCBased", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CGColorSpace createICCBased(@MachineSizedUInt long var0, @Pointer long var2, CGDataProvider var4, CGColorSpace var5);

    @Bridge(symbol="CGColorSpaceCreateIndexed", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CGColorSpace createIndexed(CGColorSpace var0, @MachineSizedUInt long var1, @Pointer long var3);

    @Bridge(symbol="CGColorSpaceCreatePattern", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGColorSpace createPattern(CGColorSpace var0);

    @Bridge(symbol="CGColorSpaceCreateWithName", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGColorSpace create(String var0);

    @Bridge(symbol="CGColorSpaceGetName", optional=true)
    public native String getName();

    @Bridge(symbol="CGColorSpaceCopyName", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String copyName();

    @Bridge(symbol="CGColorSpaceGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CGColorSpaceGetNumberOfComponents", optional=true)
    @MachineSizedUInt
    public native long getNumberOfComponents();

    @Bridge(symbol="CGColorSpaceGetModel", optional=true)
    public native CGColorSpaceModel getModel();

    @Bridge(symbol="CGColorSpaceGetBaseColorSpace", optional=true)
    public native CGColorSpace getBaseColorSpace();

    @Bridge(symbol="CGColorSpaceGetColorTableCount", optional=true)
    @MachineSizedUInt
    public native long getColorTableCount();

    @Bridge(symbol="CGColorSpaceGetColorTable", optional=true)
    private native void getColorTable(@Pointer long var1);

    @Bridge(symbol="CGColorSpaceCopyICCData", optional=true)
    public native NSData copyICCData();

    @Bridge(symbol="CGColorSpaceIsWideGamutRGB", optional=true)
    public native boolean isWideGamutRGB();

    @Deprecated
    @Bridge(symbol="CGColorSpaceIsHDR", optional=true)
    public native boolean isHDR();

    @Bridge(symbol="CGColorSpaceUsesITUR_2100TF", optional=true)
    public native boolean usesITUR_2100TF();

    @Bridge(symbol="CGColorSpaceSupportsOutput", optional=true)
    public native boolean supportsOutput();

    @Bridge(symbol="CGColorSpaceCopyPropertyList", optional=true)
    public native CFType copyPropertyList();

    @Bridge(symbol="CGColorSpaceCreateWithPropertyList", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGColorSpace createWithPropertyList(CFType var0);

    @Bridge(symbol="CGColorSpaceUsesExtendedRange", optional=true)
    public native boolean usesExtendedRange();

    @Bridge(symbol="CGColorSpaceCreateLinearized", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGColorSpace createLinearized(CGColorSpace var0);

    @Bridge(symbol="CGColorSpaceCreateExtended", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGColorSpace createExtended(CGColorSpace var0);

    @Bridge(symbol="CGColorSpaceCreateExtendedLinearized", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGColorSpace createExtendedLinearized(CGColorSpace var0);

    @Deprecated
    @Bridge(symbol="CGColorSpaceCreateWithICCProfile", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGColorSpace createWithICCProfile(NSData var0);

    @Deprecated
    @Bridge(symbol="CGColorSpaceCopyICCProfile", optional=true)
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    public native NSData getICCProfile();

    static {
        Bro.bind(CGColorSpace.class);
    }

    public static class CGColorSpacePtr
    extends Ptr<CGColorSpace, CGColorSpacePtr> {
    }
}

