/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.imageio.CGImageProperties;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreImage")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CIImageOptions
extends CFDictionaryWrapper {
    CIImageOptions(CFDictionary data) {
        super(data);
    }

    public CIImageOptions() {
    }

    public boolean has(CFString key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFString key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public CIImageOptions set(CFString key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public CGColorSpace getColorSpace() {
        if (this.has(Keys.ColorSpace())) {
            CGColorSpace val = this.get(Keys.ColorSpace(), CGColorSpace.class);
            return val;
        }
        return null;
    }

    public CIImageOptions setColorSpace(CGColorSpace colorSpace) {
        this.set(Keys.ColorSpace(), colorSpace);
        return this;
    }

    @WeaklyLinked
    public CGImageProperties getProperties() {
        if (this.has(Keys.Properties())) {
            CFDictionary val = this.get(Keys.Properties(), CFDictionary.class);
            return new CGImageProperties(val);
        }
        return null;
    }

    @WeaklyLinked
    public CIImageOptions setProperties(CGImageProperties properties) {
        this.set(Keys.Properties(), properties.getDictionary());
        return this;
    }

    @Library(value="CoreImage")
    public static class Keys {
        @GlobalValue(symbol="kCIImageColorSpace", optional=true)
        public static native CFString ColorSpace();

        @GlobalValue(symbol="kCIImageToneMapHDRtoSDR", optional=true)
        public static native CFString ToneMapHDRtoSDR();

        @GlobalValue(symbol="kCIImageNearestSampling", optional=true)
        public static native CFString NearestSampling();

        @GlobalValue(symbol="kCIImageProperties", optional=true)
        public static native CFString Properties();

        @GlobalValue(symbol="kCIImageApplyOrientationProperty", optional=true)
        public static native CFString ApplyOrientationProperty();

        @GlobalValue(symbol="kCIImageAuxiliaryDepth", optional=true)
        public static native CFString AuxiliaryDepth();

        @GlobalValue(symbol="kCIImageAuxiliaryDisparity", optional=true)
        public static native CFString AuxiliaryDisparity();

        @GlobalValue(symbol="kCIImageAuxiliaryPortraitEffectsMatte", optional=true)
        public static native CFString AuxiliaryPortraitEffectsMatte();

        @GlobalValue(symbol="kCIImageAuxiliarySemanticSegmentationSkinMatte", optional=true)
        public static native CFString AuxiliarySemanticSegmentationSkinMatte();

        @GlobalValue(symbol="kCIImageAuxiliarySemanticSegmentationHairMatte", optional=true)
        public static native CFString AuxiliarySemanticSegmentationHairMatte();

        @GlobalValue(symbol="kCIImageAuxiliarySemanticSegmentationTeethMatte", optional=true)
        public static native CFString AuxiliarySemanticSegmentationTeethMatte();

        @GlobalValue(symbol="kCIImageAuxiliarySemanticSegmentationGlassesMatte", optional=true)
        public static native CFString AuxiliarySemanticSegmentationGlassesMatte();

        @GlobalValue(symbol="kCIImageProviderTileSize", optional=true)
        public static native CFString ProviderTileSize();

        @GlobalValue(symbol="kCIImageProviderUserInfo", optional=true)
        public static native CFString ProviderUserInfo();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CIImageOptions> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CIImageOptions> list = new ArrayList<CIImageOptions>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CIImageOptions(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CIImageOptions> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CIImageOptions i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CIImageOptions toObject(Class<CIImageOptions> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CIImageOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CIImageOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

