/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.Collection;
import java.util.Map;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSPredicateKeyPath;
import org.robovm.apple.foundation.NSSecureCoding;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.Block2;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSPredicate
extends NSObject
implements NSSecureCoding {
    public NSPredicate() {
    }

    protected NSPredicate(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSPredicate(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSPredicate(String predicateFormat, NSArray<?> arguments) {
        super(null, NSPredicate.create(predicateFormat, arguments));
        NSPredicate.retain(this.getHandle());
    }

    public NSPredicate(boolean value) {
        super(null, NSPredicate.create(value));
        NSPredicate.retain(this.getHandle());
    }

    public NSPredicate(@Block Block2<NSObject, NSDictionary<NSString, ?>, Boolean> block) {
        super(null, NSPredicate.create(block));
        NSPredicate.retain(this.getHandle());
    }

    @Method(selector="initWithCoder:")
    public NSPredicate(NSCoder coder) {
        super(null);
        this.initObject(this.init(coder));
    }

    public NSPredicate(String predicateFormat, Object ... arguments) {
        super(NSPredicate.create(predicateFormat, arguments));
    }

    public NSPredicate(String predicateFormat, NSObject ... arguments) {
        super(NSPredicate.create(predicateFormat, new NSArray(arguments)));
    }

    private static long create(String predicateFormat, Object ... arguments) {
        NSMutableArray<NSObject> args = new NSMutableArray<NSObject>();
        int i = 0;
        for (Object o : arguments) {
            if (o instanceof Number) {
                args.add(NSNumber.valueOf((Number)o));
            } else if (o instanceof String) {
                args.add(new NSString((String)o));
            } else if (o instanceof NSPredicateKeyPath) {
                args.add((NSObject)((NSPredicateKeyPath)o).value());
            } else if (o instanceof Collection) {
                Collection c = (Collection)o;
                NSMutableArray<NSString> a = new NSMutableArray<NSString>();
                for (Object e : c) {
                    a.add(new NSString(e.toString()));
                }
                args.add(a);
            } else if (o instanceof Map) {
                Map m = (Map)o;
                NSMutableDictionary<NSString, NSString> d = new NSMutableDictionary<NSString, NSString>();
                for (Map.Entry entry : m.entrySet()) {
                    ((NSDictionary)d).put(new NSString(entry.getKey().toString()), new NSString(entry.getValue().toString()));
                }
                args.add(d);
            } else if (o instanceof NSObject) {
                args.add((NSObject)o);
            } else {
                if (o == null) {
                    throw new IllegalArgumentException("argument " + i + " cannot be null!");
                }
                throw new IllegalArgumentException("type of argument " + i + " not supported: " + o.getClass());
            }
            ++i;
        }
        return NSPredicate.create(predicateFormat, args);
    }

    @Property(selector="predicateFormat")
    public native String getPredicateFormat();

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    @Method(selector="predicateWithSubstitutionVariables:")
    public native NSPredicate newPredicate(NSDictionary<NSString, ?> var1);

    @Method(selector="evaluateWithObject:")
    public native boolean evaluate(NSObject var1);

    @Method(selector="evaluateWithObject:substitutionVariables:")
    public native boolean evaluate(NSObject var1, NSDictionary<NSString, ?> var2);

    @Method(selector="allowEvaluation")
    public native void allowEvaluation();

    @Method(selector="predicateWithFormat:argumentArray:")
    @Pointer
    protected static native long create(String var0, NSArray<?> var1);

    @Method(selector="predicateWithValue:")
    @Pointer
    protected static native long create(boolean var0);

    @Method(selector="predicateWithBlock:")
    @Pointer
    protected static native long create(@Block Block2<NSObject, NSDictionary<NSString, ?>, Boolean> var0);

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    static {
        ObjCRuntime.bind(NSPredicate.class);
    }

    public static class NSPredicatePtr
    extends Ptr<NSPredicate, NSPredicatePtr> {
    }
}

