/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.mlcompute;

import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.mlcompute.MLCDevice;
import org.robovm.apple.mlcompute.MLCExecutionOptions;
import org.robovm.apple.mlcompute.MLCGraph;
import org.robovm.apple.mlcompute.MLCGraphCompilationOptions;
import org.robovm.apple.mlcompute.MLCLayer;
import org.robovm.apple.mlcompute.MLCOptimizer;
import org.robovm.apple.mlcompute.MLCTensor;
import org.robovm.apple.mlcompute.MLCTensorData;
import org.robovm.apple.mlcompute.MLCTensorOptimizerDeviceData;
import org.robovm.apple.mlcompute.MLCTensorParameter;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock3;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="MLCompute")
@NativeClass
public class MLCTrainingGraph
extends MLCGraph {
    public MLCTrainingGraph() {
    }

    protected MLCTrainingGraph(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected MLCTrainingGraph(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public MLCTrainingGraph(NSArray<MLCGraph> graphObjects, MLCLayer lossLayer, MLCOptimizer optimizer) {
        super(null, MLCTrainingGraph.create(graphObjects, lossLayer, optimizer));
        MLCTrainingGraph.retain(this.getHandle());
    }

    @Property(selector="optimizer")
    public native MLCOptimizer getOptimizer();

    @Property(selector="deviceMemorySize")
    @MachineSizedUInt
    public native long getDeviceMemorySize();

    @Method(selector="addInputs:lossLabels:")
    public native boolean addInputs(NSDictionary<NSString, MLCTensor> var1, NSDictionary<NSString, MLCTensor> var2);

    @Method(selector="addInputs:lossLabels:lossLabelWeights:")
    public native boolean addInputs(NSDictionary<NSString, MLCTensor> var1, NSDictionary<NSString, MLCTensor> var2, NSDictionary<NSString, MLCTensor> var3);

    @Method(selector="addOutputs:")
    public native boolean addOutputs(NSDictionary<NSString, MLCTensor> var1);

    @Method(selector="stopGradientForTensors:")
    public native boolean stopGradientForTensors(NSArray<MLCTensor> var1);

    @Method(selector="compileWithOptions:device:")
    public native boolean compile(MLCGraphCompilationOptions var1, MLCDevice var2);

    @Method(selector="compileOptimizer:")
    public native boolean compileOptimizer(MLCOptimizer var1);

    @Method(selector="linkWithGraphs:")
    public native boolean link(NSArray<MLCTrainingGraph> var1);

    @Method(selector="gradientTensorForInput:")
    public native MLCTensor gradientTensorForInput(MLCTensor var1);

    @Method(selector="sourceGradientTensorsForLayer:")
    public native NSArray<MLCTensor> sourceGradientTensorsForLayer(MLCLayer var1);

    @Method(selector="resultGradientTensorsForLayer:")
    public native NSArray<MLCTensor> resultGradientTensorsForLayer(MLCLayer var1);

    @Method(selector="gradientDataForParameter:layer:")
    public native NSData gradientData(MLCTensor var1, MLCLayer var2);

    @Method(selector="allocateUserGradientForTensor:")
    public native MLCTensor allocateUserGradientForTensor(MLCTensor var1);

    @Method(selector="executeWithInputsData:lossLabelsData:lossLabelWeightsData:batchSize:options:completionHandler:")
    public native boolean execute(NSDictionary<NSString, MLCTensorData> var1, NSDictionary<NSString, MLCTensorData> var2, NSDictionary<NSString, MLCTensorData> var3, @MachineSizedUInt long var4, MLCExecutionOptions var6, @Block VoidBlock3<MLCTensor, NSError, Double> var7);

    @Method(selector="executeWithInputsData:lossLabelsData:lossLabelWeightsData:outputsData:batchSize:options:completionHandler:")
    public native boolean execute(NSDictionary<NSString, MLCTensorData> var1, NSDictionary<NSString, MLCTensorData> var2, NSDictionary<NSString, MLCTensorData> var3, NSDictionary<NSString, MLCTensorData> var4, @MachineSizedUInt long var5, MLCExecutionOptions var7, @Block VoidBlock3<MLCTensor, NSError, Double> var8);

    @Method(selector="executeForwardWithBatchSize:options:completionHandler:")
    public native boolean executeForward(@MachineSizedUInt long var1, MLCExecutionOptions var3, @Block VoidBlock3<MLCTensor, NSError, Double> var4);

    @Method(selector="executeForwardWithBatchSize:options:outputsData:completionHandler:")
    public native boolean executeForward(@MachineSizedUInt long var1, MLCExecutionOptions var3, NSDictionary<NSString, MLCTensorData> var4, @Block VoidBlock3<MLCTensor, NSError, Double> var5);

    @Method(selector="executeGradientWithBatchSize:options:completionHandler:")
    public native boolean executeGradient(@MachineSizedUInt long var1, MLCExecutionOptions var3, @Block VoidBlock3<MLCTensor, NSError, Double> var4);

    @Method(selector="executeGradientWithBatchSize:options:outputsData:completionHandler:")
    public native boolean executeGradient(@MachineSizedUInt long var1, MLCExecutionOptions var3, NSDictionary<NSString, MLCTensorData> var4, @Block VoidBlock3<MLCTensor, NSError, Double> var5);

    @Method(selector="executeOptimizerUpdateWithOptions:completionHandler:")
    public native boolean executeOptimizerUpdate(MLCExecutionOptions var1, @Block VoidBlock3<MLCTensor, NSError, Double> var2);

    @Method(selector="synchronizeUpdates")
    public native void synchronizeUpdates();

    @Method(selector="setTrainingTensorParameters:")
    public native boolean setTrainingTensorParameters(NSArray<MLCTensorParameter> var1);

    @Method(selector="bindOptimizerData:deviceData:withTensor:")
    public native boolean bindOptimizerData(NSArray<MLCTensorData> var1, NSArray<MLCTensorOptimizerDeviceData> var2, MLCTensor var3);

    @Method(selector="graphWithGraphObjects:lossLayer:optimizer:")
    @Pointer
    protected static native long create(NSArray<MLCGraph> var0, MLCLayer var1, MLCOptimizer var2);

    static {
        ObjCRuntime.bind(MLCTrainingGraph.class);
    }

    public static class MLCTrainingGraphPtr
    extends Ptr<MLCTrainingGraph, MLCTrainingGraphPtr> {
    }
}

