/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import org.robovm.apple.audiotoolbox.AudioFileMarker;
import org.robovm.apple.audiotoolbox.AudioFileRegionFlags;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

public class AudioFileRegion
extends Struct<AudioFileRegion> {
    public AudioFileRegion() {
    }

    public AudioFileRegion(int regionID, String name, AudioFileRegionFlags flags) {
        this.setRegionID(regionID);
        this.setName(name);
        this.setFlags(flags);
    }

    public int getMarkerCount() {
        return this.getNumberMarkers();
    }

    public AudioFileMarker getMarker(int index) {
        if (index >= this.getMarkerCount()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (AudioFileMarker)((AudioFileMarker.AudioFileMarkerPtr)this.getMarkers0().next(index)).get();
    }

    public AudioFileRegion setMarker(int index, AudioFileMarker value) {
        if (index >= this.getMarkerCount()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        ((AudioFileMarker.AudioFileMarkerPtr)this.getMarkers0().next(index)).set((NativeObject)value);
        return this;
    }

    public AudioFileMarker[] getMarkers() {
        int count = this.getMarkerCount();
        AudioFileMarker[] array = new AudioFileMarker[count];
        AudioFileMarker.AudioFileMarkerPtr ptr = this.getMarkers0();
        for (int i = 0; i < count; ++i) {
            array[i] = (AudioFileMarker)((AudioFileMarker.AudioFileMarkerPtr)ptr.next(i)).get();
        }
        return array;
    }

    public AudioFileRegion setMarkers(AudioFileMarker[] markers) {
        this.setNumberMarkers(markers.length);
        this.getMarkers0().set((NativeObject[])markers);
        return this;
    }

    @StructMember(value=0)
    public native int getRegionID();

    @StructMember(value=0)
    public native AudioFileRegion setRegionID(int var1);

    @StructMember(value=1)
    public native String getName();

    @StructMember(value=1)
    public native AudioFileRegion setName(String var1);

    @StructMember(value=2)
    public native AudioFileRegionFlags getFlags();

    @StructMember(value=2)
    public native AudioFileRegion setFlags(AudioFileRegionFlags var1);

    @StructMember(value=3)
    protected native int getNumberMarkers();

    @StructMember(value=3)
    protected native AudioFileRegion setNumberMarkers(int var1);

    @StructMember(value=4)
    protected native AudioFileMarker.AudioFileMarkerPtr getMarkers0();

    @StructMember(value=4)
    protected native AudioFileRegion setMarkers0(AudioFileMarker.AudioFileMarkerPtr var1);

    public static class AudioFileRegionPtr
    extends Ptr<AudioFileRegion, AudioFileRegionPtr> {
    }
}

