/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coredata;

import org.robovm.apple.coredata.NSAtomicStoreCacheNode;
import org.robovm.apple.coredata.NSEntityDescription;
import org.robovm.apple.coredata.NSManagedObject;
import org.robovm.apple.coredata.NSManagedObjectID;
import org.robovm.apple.coredata.NSMigrationManager;
import org.robovm.apple.coredata.NSPersistentStore;
import org.robovm.apple.coredata.NSPersistentStoreCoordinator;
import org.robovm.apple.coredata.NSPersistentStoreMetadata;
import org.robovm.apple.coredata.NSPersistentStoreOptions;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreData")
@NativeClass
public class NSAtomicStore
extends NSPersistentStore {
    protected NSAtomicStore() {
    }

    protected NSAtomicStore(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSAtomicStore(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithPersistentStoreCoordinator:configurationName:URL:options:")
    public NSAtomicStore(NSPersistentStoreCoordinator coordinator, String configurationName, NSURL url, NSPersistentStoreOptions options) {
        super(null);
        this.initObject(this.init(coordinator, configurationName, url, options));
    }

    @Override
    @Method(selector="initWithPersistentStoreCoordinator:configurationName:URL:options:")
    @Pointer
    protected native long init(NSPersistentStoreCoordinator var1, String var2, NSURL var3, NSPersistentStoreOptions var4);

    public boolean load() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.load(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="load:")
    private native boolean load(NSError.NSErrorPtr var1);

    public boolean save() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.save(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="save:")
    private native boolean save(NSError.NSErrorPtr var1);

    @Method(selector="newCacheNodeForManagedObject:")
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    public native NSAtomicStoreCacheNode newCacheNode(NSManagedObject var1);

    @Method(selector="updateCacheNode:fromManagedObject:")
    public native void updateCacheNode(NSAtomicStoreCacheNode var1, NSManagedObject var2);

    @Method(selector="cacheNodes")
    public native NSSet<NSAtomicStoreCacheNode> getCacheNodes();

    @Method(selector="addCacheNodes:")
    public native void addCacheNodes(NSSet<NSAtomicStoreCacheNode> var1);

    @Method(selector="willRemoveCacheNodes:")
    public native void willRemoveCacheNodes(NSSet<NSAtomicStoreCacheNode> var1);

    @Method(selector="cacheNodeForObjectID:")
    public native NSAtomicStoreCacheNode getCacheNode(NSManagedObjectID var1);

    @Method(selector="objectIDForEntity:referenceObject:")
    public native NSManagedObjectID getObjectID(NSEntityDescription var1, NSObject var2);

    @Method(selector="newReferenceObjectForManagedObject:")
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    public native NSObject newReferenceObject(NSManagedObject var1);

    @Method(selector="referenceObjectForObjectID:")
    public native NSObject getReferenceObject(NSManagedObjectID var1);

    public static NSPersistentStoreMetadata getMetadataForPersistentStore(NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSPersistentStoreMetadata result = NSAtomicStore.getMetadataForPersistentStore(url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="metadataForPersistentStoreWithURL:error:")
    private static native NSPersistentStoreMetadata getMetadataForPersistentStore(NSURL var0, NSError.NSErrorPtr var1);

    public static boolean setMetadataForPersistentStore(NSPersistentStoreMetadata metadata, NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = NSAtomicStore.setMetadataForPersistentStore(metadata, url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setMetadata:forPersistentStoreWithURL:error:")
    private static native boolean setMetadataForPersistentStore(NSPersistentStoreMetadata var0, NSURL var1, NSError.NSErrorPtr var2);

    @Method(selector="migrationManagerClass")
    public static native Class<? extends NSMigrationManager> getMigrationManagerClass();

    static {
        ObjCRuntime.bind(NSAtomicStore.class);
    }

    public static class NSAtomicStorePtr
    extends Ptr<NSAtomicStore, NSAtomicStorePtr> {
    }
}

