/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coremidi;

import org.robovm.apple.corefoundation.CFPropertyList;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.coremidi.MIDIError;
import org.robovm.apple.coremidi.MIDIObjectType;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreMIDI")
@Marshaler(value=CFString.AsStringMarshaler.class)
public class MIDIObject
extends NativeObject {
    public int getIntegerProperty(String propertyID) {
        IntPtr ptr = new IntPtr();
        this.getIntegerProperty(propertyID, ptr);
        return ptr.get();
    }

    public String getStringProperty(String propertyID) {
        NSString.NSStringPtr ptr = new NSString.NSStringPtr();
        this.getStringProperty(propertyID, ptr);
        NSString str = (NSString)ptr.get();
        if (str != null) {
            return str.toString();
        }
        return null;
    }

    public NSData getDataProperty(String propertyID) {
        NSData.NSDataPtr ptr = new NSData.NSDataPtr();
        this.getDataProperty(propertyID, ptr);
        return (NSData)ptr.get();
    }

    public NSDictionary<?, ?> getDictionaryProperty(String propertyID) {
        NSDictionary.NSDictionaryPtr ptr = new NSDictionary.NSDictionaryPtr();
        this.getDictionaryProperty(propertyID, ptr);
        return (NSDictionary)ptr.get();
    }

    public CFPropertyList getProperties(boolean deep) {
        CFPropertyList.CFPropertyListPtr ptr = new CFPropertyList.CFPropertyListPtr();
        this.getProperties(ptr, deep);
        return (CFPropertyList)ptr.get();
    }

    public static MIDIObject findObjectById(int uniqueID) {
        MIDIObjectPtr ptr = new MIDIObjectPtr();
        MIDIObject.findByUniqueID(uniqueID, ptr, null);
        return (MIDIObject)ptr.get();
    }

    public static MIDIObjectType findObjectTypeById(int uniqueID) {
        IntPtr ptr = new IntPtr();
        MIDIObject.findByUniqueID(uniqueID, null, ptr);
        return MIDIObjectType.valueOf(ptr.get());
    }

    @Bridge(symbol="MIDIObjectGetIntegerProperty", optional=true)
    protected native MIDIError getIntegerProperty(String var1, IntPtr var2);

    @Bridge(symbol="MIDIObjectSetIntegerProperty", optional=true)
    public native MIDIError setIntegerProperty(String var1, int var2);

    @Bridge(symbol="MIDIObjectGetStringProperty", optional=true)
    protected native MIDIError getStringProperty(String var1, NSString.NSStringPtr var2);

    @Bridge(symbol="MIDIObjectSetStringProperty", optional=true)
    public native MIDIError setStringProperty(String var1, String var2);

    @Bridge(symbol="MIDIObjectGetDataProperty", optional=true)
    protected native MIDIError getDataProperty(String var1, NSData.NSDataPtr var2);

    @Bridge(symbol="MIDIObjectSetDataProperty", optional=true)
    public native MIDIError setDataProperty(String var1, NSData var2);

    @Bridge(symbol="MIDIObjectGetDictionaryProperty", optional=true)
    protected native MIDIError getDictionaryProperty(String var1, NSDictionary.NSDictionaryPtr var2);

    @Bridge(symbol="MIDIObjectSetDictionaryProperty", optional=true)
    public native MIDIError setDictionaryProperty(String var1, NSDictionary var2);

    @Bridge(symbol="MIDIObjectGetProperties", optional=true)
    protected native MIDIError getProperties(CFPropertyList.CFPropertyListPtr var1, boolean var2);

    @Bridge(symbol="MIDIObjectRemoveProperty", optional=true)
    public native MIDIError removeProperty(String var1);

    @Bridge(symbol="MIDIObjectFindByUniqueID", optional=true)
    protected static native MIDIError findByUniqueID(int var0, MIDIObjectPtr var1, IntPtr var2);

    static {
        Bro.bind(MIDIObject.class);
    }

    public static class MIDIObjectPtr
    extends Ptr<MIDIObject, MIDIObjectPtr> {
    }
}

