/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.mediaplayer;

import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.mediaplayer.MPMediaEntity;
import org.robovm.apple.mediaplayer.MPMediaEntityProperty;
import org.robovm.apple.mediaplayer.MPMediaGrouping;
import org.robovm.apple.mediaplayer.MPMediaItemArtwork;
import org.robovm.apple.mediaplayer.MPMediaItemProperty;
import org.robovm.apple.mediaplayer.MPMediaType;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="MediaPlayer")
@NativeClass
public class MPMediaItem
extends MPMediaEntity {
    public MPMediaItem() {
    }

    protected MPMediaItem(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected MPMediaItem(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Override
    @Property(selector="persistentID")
    public native long getPersistentID();

    @Property(selector="mediaType")
    public native MPMediaType getMediaType();

    @Property(selector="title")
    public native String getTitle();

    @Property(selector="albumTitle")
    public native String getAlbumTitle();

    @Property(selector="albumPersistentID")
    public native long getAlbumPersistentID();

    @Property(selector="artist")
    public native String getArtist();

    @Property(selector="artistPersistentID")
    public native long getArtistPersistentID();

    @Property(selector="albumArtist")
    public native String getAlbumArtist();

    @Property(selector="albumArtistPersistentID")
    public native long getAlbumArtistPersistentID();

    @Property(selector="genre")
    public native String getGenre();

    @Property(selector="genrePersistentID")
    public native long getGenrePersistentID();

    @Property(selector="composer")
    public native String getComposer();

    @Property(selector="composerPersistentID")
    public native long getComposerPersistentID();

    @Property(selector="playbackDuration")
    public native double getPlaybackDuration();

    @Property(selector="albumTrackNumber")
    @MachineSizedUInt
    public native long getAlbumTrackNumber();

    @Property(selector="albumTrackCount")
    @MachineSizedUInt
    public native long getAlbumTrackCount();

    @Property(selector="discNumber")
    @MachineSizedUInt
    public native long getDiscNumber();

    @Property(selector="discCount")
    @MachineSizedUInt
    public native long getDiscCount();

    @Property(selector="artwork")
    public native MPMediaItemArtwork getArtwork();

    @Property(selector="isExplicitItem")
    public native boolean isExplicitItem();

    @Property(selector="lyrics")
    public native String getLyrics();

    @Property(selector="isCompilation")
    public native boolean isCompilation();

    @Property(selector="releaseDate")
    public native NSDate getReleaseDate();

    @Property(selector="beatsPerMinute")
    @MachineSizedUInt
    public native long getBeatsPerMinute();

    @Property(selector="comments")
    public native String getComments();

    @Property(selector="assetURL")
    public native NSURL getAssetURL();

    @Property(selector="isCloudItem")
    public native boolean isCloudItem();

    @Property(selector="hasProtectedAsset")
    public native boolean isProtectedAsset();

    @Property(selector="podcastTitle")
    public native String getPodcastTitle();

    @Property(selector="podcastPersistentID")
    public native long getPodcastPersistentID();

    @Property(selector="playCount")
    @MachineSizedUInt
    public native long getPlayCount();

    @Property(selector="skipCount")
    @MachineSizedUInt
    public native long getSkipCount();

    @Property(selector="rating")
    @MachineSizedUInt
    public native long getRating();

    @Property(selector="lastPlayedDate")
    public native NSDate getLastPlayedDate();

    @Property(selector="userGrouping")
    public native String getUserGrouping();

    @Property(selector="bookmarkTime")
    public native double getBookmarkTime();

    @Property(selector="dateAdded")
    public native NSDate getDateAdded();

    @Property(selector="playbackStoreID")
    public native String getPlaybackStoreID();

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    @Override
    public long getPersistentIDLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.ItemPersistentID);
        if (val != null) {
            return val.longValue();
        }
        return 0L;
    }

    public long getAlbumPersistentIDLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.AlbumPersistentID);
        if (val != null) {
            return val.longValue();
        }
        return 0L;
    }

    public long getArtistPersistentIDLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.ArtistPersistentID);
        if (val != null) {
            return val.longValue();
        }
        return 0L;
    }

    public long getAlbumArtistPersistentIDLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.AlbumArtistPersistentID);
        if (val != null) {
            return val.longValue();
        }
        return 0L;
    }

    public long getGenrePersistentIDLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.GenrePersistentID);
        if (val != null) {
            return val.longValue();
        }
        return 0L;
    }

    public long getComposerPersistentIDLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.ComposerPersistentID);
        if (val != null) {
            return val.longValue();
        }
        return 0L;
    }

    public long getPodcastPersistentIDLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.PodcastPersistentID);
        if (val != null) {
            return val.longValue();
        }
        return 0L;
    }

    public MPMediaType getMediaTypeLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.MediaType);
        if (val != null) {
            return new MPMediaType(val.intValue());
        }
        return null;
    }

    public String getTitleLegacy() {
        NSString val = (NSString)this.getValue(MPMediaItemProperty.Title);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public String getAlbumTitleLegacy() {
        NSString val = (NSString)this.getValue(MPMediaItemProperty.AlbumTitle);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public String getArtistLegacy() {
        NSString val = (NSString)this.getValue(MPMediaItemProperty.Artist);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public String getAlbumArtistLegacy() {
        NSString val = (NSString)this.getValue(MPMediaItemProperty.AlbumArtist);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public String getGenreLegacy() {
        NSString val = (NSString)this.getValue(MPMediaItemProperty.Genre);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public String getComposerLegacy() {
        NSString val = (NSString)this.getValue(MPMediaItemProperty.Composer);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public double getPlaybackDurationLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.PlaybackDuration);
        if (val != null) {
            return val.doubleValue();
        }
        return 0.0;
    }

    public int getAlbumTrackNumberLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.AlbumTrackNumber);
        if (val != null) {
            return val.intValue();
        }
        return 0;
    }

    public int getAlbumTrackCountLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.AlbumTrackCount);
        if (val != null) {
            return val.intValue();
        }
        return 0;
    }

    public int getDiscNumberLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.DiscNumber);
        if (val != null) {
            return val.intValue();
        }
        return 0;
    }

    public int getDiscCountLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.DiscCount);
        if (val != null) {
            return val.intValue();
        }
        return 0;
    }

    public MPMediaItemArtwork getArtworkLegacy() {
        MPMediaItemArtwork val = (MPMediaItemArtwork)this.getValue(MPMediaItemProperty.Artwork);
        if (val != null) {
            return val;
        }
        return null;
    }

    public String getLyricsLegacy() {
        NSString val = (NSString)this.getValue(MPMediaItemProperty.Lyrics);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public boolean isCompilationLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.IsCompilation);
        if (val != null) {
            return val.booleanValue();
        }
        return false;
    }

    public NSDate getReleaseDateLegacy() {
        NSDate val = (NSDate)this.getValue(MPMediaItemProperty.ReleaseDate);
        if (val != null) {
            return val;
        }
        return null;
    }

    public int getBeatsPerMinuteLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.BeatsPerMinute);
        if (val != null) {
            return val.intValue();
        }
        return 0;
    }

    public String getCommentsLegacy() {
        NSString val = (NSString)this.getValue(MPMediaItemProperty.Comments);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public NSURL getAssetURLLegacy() {
        NSURL val = (NSURL)this.getValue(MPMediaItemProperty.AssetURL);
        if (val != null) {
            return val;
        }
        return null;
    }

    public boolean isCloudItemLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.IsCloudItem);
        if (val != null) {
            return val.booleanValue();
        }
        return false;
    }

    public String getPodcastTitleLegacy() {
        NSString val = (NSString)this.getValue(MPMediaItemProperty.PodcastTitle);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public int getPlayCountLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.PlayCount);
        if (val != null) {
            return val.intValue();
        }
        return 0;
    }

    public int getSkipCountLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.SkipCount);
        if (val != null) {
            return val.intValue();
        }
        return 0;
    }

    public int getRatingLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.Rating);
        if (val != null) {
            return val.intValue();
        }
        return 0;
    }

    public NSDate getLastPlayedDateLegacy() {
        NSDate val = (NSDate)this.getValue(MPMediaItemProperty.LastPlayedDate);
        if (val != null) {
            return val;
        }
        return null;
    }

    public String getUserGroupingLegacy() {
        NSString val = (NSString)this.getValue(MPMediaItemProperty.UserGrouping);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public double getBookmarkTimeLegacy() {
        NSNumber val = (NSNumber)this.getValue(MPMediaItemProperty.BookmarkTime);
        if (val != null) {
            return val.doubleValue();
        }
        return 0.0;
    }

    @Method(selector="canFilterByProperty:")
    public static native boolean canFilterByProperty(MPMediaEntityProperty var0);

    @Method(selector="persistentIDPropertyForGroupingType:")
    public static native MPMediaEntityProperty getPersistentIDProperty(MPMediaGrouping var0);

    @Method(selector="titlePropertyForGroupingType:")
    public static native MPMediaEntityProperty getTitleProperty(MPMediaGrouping var0);

    static {
        ObjCRuntime.bind(MPMediaItem.class);
    }

    public static class MPMediaItemPtr
    extends Ptr<MPMediaItem, MPMediaItemPtr> {
    }
}

