/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metal;

import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorCode;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.ValuedEnum;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;

@Marshaler(value=ValuedEnum.AsMachineSizedSIntMarshaler.class)
@Library(value="Metal")
public enum MTLCaptureError implements NSErrorCode
{
    NotSupported(1L),
    AlreadyCapturing(2L),
    InvalidDescriptor(3L);

    private final long n;

    @GlobalValue(symbol="MTLCaptureErrorDomain", optional=true)
    public static native String getClassDomain();

    private MTLCaptureError(long n2) {
        this.n = n2;
    }

    public long value() {
        return this.n;
    }

    public static MTLCaptureError valueOf(long n) {
        for (MTLCaptureError v : MTLCaptureError.values()) {
            if (v.n != n) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " + MTLCaptureError.class.getName());
    }

    static {
        Bro.bind(MTLCaptureError.class);
        Bro.bind(NSErrorWrap.class);
    }

    @StronglyLinked
    public static class NSErrorWrap
    extends NSError {
        protected NSErrorWrap(NSObject.SkipInit skipInit) {
            super(skipInit);
        }

        @Override
        public NSErrorCode getErrorCode() {
            try {
                return MTLCaptureError.valueOf(this.getCode());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static String getClassDomain() {
            return MTLCaptureError.getClassDomain();
        }
    }
}

