/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metalpsgraph;

import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.metal.MTLCommandQueue;
import org.robovm.apple.metalps.MPSCommandBuffer;
import org.robovm.apple.metalps.MPSDataType;
import org.robovm.apple.metalpsgraph.MPSGraphConvolution2DOpDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphDepthwiseConvolution2DOpDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphExecutionDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphLossReductionType;
import org.robovm.apple.metalpsgraph.MPSGraphOperation;
import org.robovm.apple.metalpsgraph.MPSGraphOptions;
import org.robovm.apple.metalpsgraph.MPSGraphPaddingMode;
import org.robovm.apple.metalpsgraph.MPSGraphPooling2DOpDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphResizeMode;
import org.robovm.apple.metalpsgraph.MPSGraphTensor;
import org.robovm.apple.metalpsgraph.MPSGraphTensorData;
import org.robovm.apple.metalpsgraph.MPSGraphTensorNamedDataLayout;
import org.robovm.apple.metalpsgraph.MPSGraphVariableOp;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="MetalPerformanceShadersGraph")
@NativeClass
public class MPSGraph
extends NSObject {
    public MPSGraph() {
    }

    protected MPSGraph(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected MPSGraph(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="options")
    public native MPSGraphOptions getOptions();

    @Property(selector="setOptions:")
    public native void setOptions(MPSGraphOptions var1);

    @Property(selector="placeholderTensors")
    public native NSArray<MPSGraphTensor> getPlaceholderTensors();

    @Method(selector="runWithFeeds:targetTensors:targetOperations:")
    public native NSDictionary<MPSGraphTensor, MPSGraphTensorData> run(NSDictionary<MPSGraphTensor, MPSGraphTensorData> var1, NSArray<MPSGraphTensor> var2, NSArray<MPSGraphOperation> var3);

    @Method(selector="runWithMTLCommandQueue:feeds:targetTensors:targetOperations:")
    public native NSDictionary<MPSGraphTensor, MPSGraphTensorData> run(MTLCommandQueue var1, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var2, NSArray<MPSGraphTensor> var3, NSArray<MPSGraphOperation> var4);

    @Method(selector="runWithMTLCommandQueue:feeds:targetOperations:resultsDictionary:")
    public native void run(MTLCommandQueue var1, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var2, NSArray<MPSGraphOperation> var3, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var4);

    @Method(selector="runAsyncWithFeeds:targetTensors:targetOperations:executionDescriptor:")
    public native NSDictionary<MPSGraphTensor, MPSGraphTensorData> runAsync(NSDictionary<MPSGraphTensor, MPSGraphTensorData> var1, NSArray<MPSGraphTensor> var2, NSArray<MPSGraphOperation> var3, MPSGraphExecutionDescriptor var4);

    @Method(selector="runAsyncWithMTLCommandQueue:feeds:targetTensors:targetOperations:executionDescriptor:")
    public native NSDictionary<MPSGraphTensor, MPSGraphTensorData> runAsync(MTLCommandQueue var1, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var2, NSArray<MPSGraphTensor> var3, NSArray<MPSGraphOperation> var4, MPSGraphExecutionDescriptor var5);

    @Method(selector="runAsyncWithMTLCommandQueue:feeds:targetOperations:resultsDictionary:executionDescriptor:")
    public native void runAsync(MTLCommandQueue var1, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var2, NSArray<MPSGraphOperation> var3, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var4, MPSGraphExecutionDescriptor var5);

    @Method(selector="encodeToCommandBuffer:feeds:targetTensors:targetOperations:executionDescriptor:")
    public native NSDictionary<MPSGraphTensor, MPSGraphTensorData> encodeToCommandBuffer(MPSCommandBuffer var1, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var2, NSArray<MPSGraphTensor> var3, NSArray<MPSGraphOperation> var4, MPSGraphExecutionDescriptor var5);

    @Method(selector="encodeToCommandBuffer:feeds:targetOperations:resultsDictionary:executionDescriptor:")
    public native void encodeToCommandBuffer(MPSCommandBuffer var1, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var2, NSArray<MPSGraphOperation> var3, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var4, MPSGraphExecutionDescriptor var5);

    @Method(selector="gradientForPrimaryTensor:withTensors:name:")
    public native NSDictionary<MPSGraphTensor, MPSGraphTensor> gradientForPrimaryTensor(MPSGraphTensor var1, NSArray<MPSGraphTensor> var2, String var3);

    @Method(selector="reLUWithTensor:name:")
    public native MPSGraphTensor reLU(MPSGraphTensor var1, String var2);

    @Method(selector="reLUGradientWithIncomingGradient:sourceTensor:name:")
    public native MPSGraphTensor reLUGradient(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="sigmoidWithTensor:name:")
    public native MPSGraphTensor sigmoid(MPSGraphTensor var1, String var2);

    @Method(selector="sigmoidGradientWithIncomingGradient:sourceTensor:name:")
    public native MPSGraphTensor sigmoidGradient(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="softMaxWithTensor:axis:name:")
    public native MPSGraphTensor softMax(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="softMaxGradientWithIncomingGradient:sourceTensor:axis:name:")
    public native MPSGraphTensor softMaxGradient(MPSGraphTensor var1, MPSGraphTensor var2, @MachineSizedSInt long var3, String var5);

    @Method(selector="identityWithTensor:name:")
    public native MPSGraphTensor identity(MPSGraphTensor var1, String var2);

    @Method(selector="exponentWithTensor:name:")
    public native MPSGraphTensor exponent(MPSGraphTensor var1, String var2);

    @Method(selector="exponentBase2WithTensor:name:")
    public native MPSGraphTensor exponentBase2(MPSGraphTensor var1, String var2);

    @Method(selector="exponentBase10WithTensor:name:")
    public native MPSGraphTensor exponentBase10(MPSGraphTensor var1, String var2);

    @Method(selector="logarithmWithTensor:name:")
    public native MPSGraphTensor logarithm(MPSGraphTensor var1, String var2);

    @Method(selector="logarithmBase2WithTensor:name:")
    public native MPSGraphTensor logarithmBase2(MPSGraphTensor var1, String var2);

    @Method(selector="logarithmBase10WithTensor:name:")
    public native MPSGraphTensor logarithmBase10(MPSGraphTensor var1, String var2);

    @Method(selector="squareWithTensor:name:")
    public native MPSGraphTensor square(MPSGraphTensor var1, String var2);

    @Method(selector="squareRootWithTensor:name:")
    public native MPSGraphTensor squareRoot(MPSGraphTensor var1, String var2);

    @Method(selector="reverseSquareRootWithTensor:name:")
    public native MPSGraphTensor reverseSquareRoot(MPSGraphTensor var1, String var2);

    @Method(selector="reciprocalWithTensor:name:")
    public native MPSGraphTensor reciprocal(MPSGraphTensor var1, String var2);

    @Method(selector="absoluteWithTensor:name:")
    public native MPSGraphTensor absolute(MPSGraphTensor var1, String var2);

    @Method(selector="negativeWithTensor:name:")
    public native MPSGraphTensor negative(MPSGraphTensor var1, String var2);

    @Method(selector="signWithTensor:name:")
    public native MPSGraphTensor sign(MPSGraphTensor var1, String var2);

    @Method(selector="signbitWithTensor:name:")
    public native MPSGraphTensor signbit(MPSGraphTensor var1, String var2);

    @Method(selector="ceilWithTensor:name:")
    public native MPSGraphTensor ceil(MPSGraphTensor var1, String var2);

    @Method(selector="floorWithTensor:name:")
    public native MPSGraphTensor floor(MPSGraphTensor var1, String var2);

    @Method(selector="roundWithTensor:name:")
    public native MPSGraphTensor round(MPSGraphTensor var1, String var2);

    @Method(selector="rintWithTensor:name:")
    public native MPSGraphTensor rint(MPSGraphTensor var1, String var2);

    @Method(selector="sinWithTensor:name:")
    public native MPSGraphTensor sin(MPSGraphTensor var1, String var2);

    @Method(selector="cosWithTensor:name:")
    public native MPSGraphTensor cos(MPSGraphTensor var1, String var2);

    @Method(selector="tanWithTensor:name:")
    public native MPSGraphTensor tan(MPSGraphTensor var1, String var2);

    @Method(selector="sinhWithTensor:name:")
    public native MPSGraphTensor sinh(MPSGraphTensor var1, String var2);

    @Method(selector="coshWithTensor:name:")
    public native MPSGraphTensor cosh(MPSGraphTensor var1, String var2);

    @Method(selector="tanhWithTensor:name:")
    public native MPSGraphTensor tanh(MPSGraphTensor var1, String var2);

    @Method(selector="asinWithTensor:name:")
    public native MPSGraphTensor asin(MPSGraphTensor var1, String var2);

    @Method(selector="acosWithTensor:name:")
    public native MPSGraphTensor acos(MPSGraphTensor var1, String var2);

    @Method(selector="atanWithTensor:name:")
    public native MPSGraphTensor atan(MPSGraphTensor var1, String var2);

    @Method(selector="asinhWithTensor:name:")
    public native MPSGraphTensor asinh(MPSGraphTensor var1, String var2);

    @Method(selector="acoshWithTensor:name:")
    public native MPSGraphTensor acosh(MPSGraphTensor var1, String var2);

    @Method(selector="atanhWithTensor:name:")
    public native MPSGraphTensor atanh(MPSGraphTensor var1, String var2);

    @Method(selector="notWithTensor:name:")
    public native MPSGraphTensor not(MPSGraphTensor var1, String var2);

    @Method(selector="isInfiniteWithTensor:name:")
    public native MPSGraphTensor isInfinite(MPSGraphTensor var1, String var2);

    @Method(selector="isFiniteWithTensor:name:")
    public native MPSGraphTensor isFinite(MPSGraphTensor var1, String var2);

    @Method(selector="isNaNWithTensor:name:")
    public native MPSGraphTensor isNaN(MPSGraphTensor var1, String var2);

    @Method(selector="erfWithTensor:name:")
    public native MPSGraphTensor erf(MPSGraphTensor var1, String var2);

    @Method(selector="additionWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor addition(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="subtractionWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor subtraction(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="multiplicationWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor multiplication(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="divisionWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor division(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="moduloWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor modulo(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="powerWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor power(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="minimumWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor minimum(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="maximumWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor maximum(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="equalWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor equal(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="notEqualWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor notEqual(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="lessThanWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor lessThan(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="lessThanOrEqualToWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor lessThanOrEqual(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="greaterThanWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor greaterThan(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="greaterThanOrEqualToWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor greaterThanOrEqual(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="logicalANDWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor logicalAND(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="logicalORWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor logicalOR(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="logicalNANDWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor logicalNAND(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="logicalNORWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor logicalNOR(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="logicalXORWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor logicalXOR(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="logicalXNORWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor logicalXNOR(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="atan2WithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor atan2(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="selectWithPredicateTensor:truePredicateTensor:falsePredicateTensor:name:")
    public native MPSGraphTensor select(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, String var4);

    @Method(selector="clampWithTensor:minValueTensor:maxValueTensor:name:")
    public native MPSGraphTensor clamp(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, String var4);

    @Method(selector="divisionNoNaNWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor divisionNoNaN(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="floorModuloWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor floorModulo(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="convolution2DWithSourceTensor:weightsTensor:descriptor:name:")
    public native MPSGraphTensor convolution2D(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphConvolution2DOpDescriptor var3, String var4);

    @Method(selector="convolution2DDataGradientWithIncomingGradientTensor:weightsTensor:outputShape:forwardConvolutionDescriptor:name:")
    public native MPSGraphTensor convolution2DDataGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphConvolution2DOpDescriptor var4, String var5);

    @Method(selector="convolution2DWeightsGradientWithIncomingGradientTensor:sourceTensor:outputShape:forwardConvolutionDescriptor:name:")
    public native MPSGraphTensor convolution2DWeightsGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphConvolution2DOpDescriptor var4, String var5);

    @Method(selector="convolutionTranspose2DWithSourceTensor:weightsTensor:outputShape:descriptor:name:")
    public native MPSGraphTensor convolutionTranspose2D(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphConvolution2DOpDescriptor var4, String var5);

    @Method(selector="convolutionTranspose2DDataGradientWithIncomingGradientTensor:weightsTensor:outputShape:forwardConvolutionDescriptor:name:")
    public native MPSGraphTensor convolutionTranspose2DDataGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphConvolution2DOpDescriptor var4, String var5);

    @Method(selector="convolutionTranspose2DWeightsGradientWithIncomingGradientTensor:sourceTensor:outputShape:forwardConvolutionDescriptor:name:")
    public native MPSGraphTensor convolutionTranspose2DWeightsGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphConvolution2DOpDescriptor var4, String var5);

    @Method(selector="depthwiseConvolution2DWithSourceTensor:weightsTensor:descriptor:name:")
    public native MPSGraphTensor depthwiseConvolution2D(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphDepthwiseConvolution2DOpDescriptor var3, String var4);

    @Method(selector="depthwiseConvolution2DDataGradientWithIncomingGradientTensor:weightsTensor:outputShape:descriptor:name:")
    public native MPSGraphTensor depthwiseConvolution2DDataGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphDepthwiseConvolution2DOpDescriptor var4, String var5);

    @Method(selector="depthwiseConvolution2DWeightsGradientWithIncomingGradientTensor:sourceTensor:outputShape:descriptor:name:")
    public native MPSGraphTensor depthwiseConvolution2DWeightsGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphDepthwiseConvolution2DOpDescriptor var4, String var5);

    @Method(selector="gatherNDWithUpdatesTensor:indicesTensor:batchDimensions:name:")
    public native MPSGraphTensor gatherND(MPSGraphTensor var1, MPSGraphTensor var2, @MachineSizedUInt long var3, String var5);

    @Method(selector="gatherWithUpdatesTensor:indicesTensor:axis:batchDimensions:name:")
    public native MPSGraphTensor gather(MPSGraphTensor var1, MPSGraphTensor var2, @MachineSizedUInt long var3, @MachineSizedUInt long var5, String var7);

    @Method(selector="softMaxCrossEntropyWithSourceTensor:labelsTensor:axis:reductionType:name:")
    public native MPSGraphTensor softMaxCrossEntropy(MPSGraphTensor var1, MPSGraphTensor var2, @MachineSizedSInt long var3, MPSGraphLossReductionType var5, String var6);

    @Method(selector="softMaxCrossEntropyGradientWithIncomingGradientTensor:sourceTensor:labelsTensor:axis:reductionType:name:")
    public native MPSGraphTensor softMaxCrossEntropyGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, @MachineSizedSInt long var4, MPSGraphLossReductionType var6, String var7);

    @Method(selector="matrixMultiplicationWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor matrixMultiplication(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="placeholderWithShape:dataType:name:")
    public native MPSGraphTensor placeholder(NSArray<NSNumber> var1, MPSDataType var2, String var3);

    @Method(selector="placeholderWithShape:name:")
    public native MPSGraphTensor placeholder(NSArray<NSNumber> var1, String var2);

    @Method(selector="constantWithData:shape:dataType:")
    public native MPSGraphTensor constant(NSData var1, NSArray<NSNumber> var2, MPSDataType var3);

    @Method(selector="constantWithScalar:dataType:")
    public native MPSGraphTensor constant(double var1, MPSDataType var3);

    @Method(selector="constantWithScalar:shape:dataType:")
    public native MPSGraphTensor constant(double var1, NSArray<NSNumber> var3, MPSDataType var4);

    @Method(selector="variableWithData:shape:dataType:name:")
    public native MPSGraphTensor variable(NSData var1, NSArray<NSNumber> var2, MPSDataType var3, String var4);

    @Method(selector="readVariable:name:")
    public native MPSGraphTensor readVariable(MPSGraphTensor var1, String var2);

    @Method(selector="assignVariable:withValueOfTensor:name:")
    public native MPSGraphOperation assignVariable(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="meanOfTensor:axes:name:")
    public native MPSGraphTensor mean(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="varianceOfTensor:meanTensor:axes:name:")
    public native MPSGraphTensor variance(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, String var4);

    @Method(selector="varianceOfTensor:axes:name:")
    public native MPSGraphTensor variance(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="normalizationWithTensor:meanTensor:varianceTensor:gammaTensor:betaTensor:epsilon:name:")
    public native MPSGraphTensor normalization(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, float var6, String var7);

    @Method(selector="normalizationGammaGradientWithIncomingGradientTensor:sourceTensor:meanTensor:varianceTensor:reductionAxes:epsilon:name:")
    public native MPSGraphTensor normalizationGammaGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, NSArray<NSNumber> var5, float var6, String var7);

    @Method(selector="normalizationBetaGradientWithIncomingGradientTensor:sourceTensor:reductionAxes:name:")
    public native MPSGraphTensor normalizationBetaGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, String var4);

    @Method(selector="normalizationGradientWithIncomingGradientTensor:sourceTensor:meanTensor:varianceTensor:gammaTensor:gammaGradientTensor:betaGradientTensor:reductionAxes:epsilon:name:")
    public native MPSGraphTensor normalizationGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphTensor var7, NSArray<NSNumber> var8, float var9, String var10);

    @Method(selector="oneHotWithIndicesTensor:depth:axis:dataType:onValue:offValue:name:")
    public native MPSGraphTensor oneHot(MPSGraphTensor var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, MPSDataType var6, double var7, double var9, String var11);

    @Method(selector="oneHotWithIndicesTensor:depth:dataType:onValue:offValue:name:")
    public native MPSGraphTensor oneHot(MPSGraphTensor var1, @MachineSizedUInt long var2, MPSDataType var4, double var5, double var7, String var9);

    @Method(selector="oneHotWithIndicesTensor:depth:axis:dataType:name:")
    public native MPSGraphTensor oneHot(MPSGraphTensor var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, MPSDataType var6, String var7);

    @Method(selector="oneHotWithIndicesTensor:depth:axis:name:")
    public native MPSGraphTensor oneHot(MPSGraphTensor var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, String var6);

    @Method(selector="oneHotWithIndicesTensor:depth:dataType:name:")
    public native MPSGraphTensor oneHot(MPSGraphTensor var1, @MachineSizedUInt long var2, MPSDataType var4, String var5);

    @Method(selector="oneHotWithIndicesTensor:depth:name:")
    public native MPSGraphTensor oneHot(MPSGraphTensor var1, @MachineSizedUInt long var2, String var4);

    @Method(selector="stochasticGradientDescentWithLearningRateTensor:valuesTensor:gradientTensor:name:")
    public native MPSGraphTensor stochasticGradientDescent(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, String var4);

    @Method(selector="applyStochasticGradientDescentWithLearningRateTensor:variable:gradientTensor:name:")
    public native MPSGraphOperation applyStochasticGradientDescent(MPSGraphTensor var1, MPSGraphVariableOp var2, MPSGraphTensor var3, String var4);

    @Method(selector="maxPooling2DWithSourceTensor:descriptor:name:")
    public native MPSGraphTensor maxPooling2D(MPSGraphTensor var1, MPSGraphPooling2DOpDescriptor var2, String var3);

    @Method(selector="maxPooling2DGradientWithGradientTensor:sourceTensor:descriptor:name:")
    public native MPSGraphTensor maxPooling2DGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphPooling2DOpDescriptor var3, String var4);

    @Method(selector="avgPooling2DWithSourceTensor:descriptor:name:")
    public native MPSGraphTensor avgPooling2D(MPSGraphTensor var1, MPSGraphPooling2DOpDescriptor var2, String var3);

    @Method(selector="avgPooling2DGradientWithGradientTensor:sourceTensor:descriptor:name:")
    public native MPSGraphTensor avgPooling2D(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphPooling2DOpDescriptor var3, String var4);

    @Method(selector="dropoutTensor:rate:name:")
    public native MPSGraphTensor dropout(MPSGraphTensor var1, double var2, String var4);

    @Method(selector="dropoutTensor:rateTensor:name:")
    public native MPSGraphTensor dropout(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="reductionSumWithTensor:axis:name:")
    public native MPSGraphTensor reductionSum(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="reductionSumWithTensor:axes:name:")
    public native MPSGraphTensor reductionSum(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="reductionMaximumWithTensor:axis:name:")
    public native MPSGraphTensor reductionMaximum(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="reductionMaximumWithTensor:axes:name:")
    public native MPSGraphTensor reductionMaximum(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="reductionMinimumWithTensor:axis:name:")
    public native MPSGraphTensor reductionMinimum(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="reductionMinimumWithTensor:axes:name:")
    public native MPSGraphTensor reductionMinimum(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="reductionProductWithTensor:axis:name:")
    public native MPSGraphTensor reductionProduct(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="reductionProductWithTensor:axes:name:")
    public native MPSGraphTensor reductionProduct(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="resizeTensor:size:mode:centerResult:alignCorners:layout:name:")
    public native MPSGraphTensor resizeTensor(MPSGraphTensor var1, NSArray<NSNumber> var2, MPSGraphResizeMode var3, boolean var4, boolean var5, MPSGraphTensorNamedDataLayout var6, String var7);

    @Method(selector="resizeWithGradientTensor:input:mode:centerResult:alignCorners:layout:name:")
    public native MPSGraphTensor resize(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphResizeMode var3, boolean var4, boolean var5, MPSGraphTensorNamedDataLayout var6, String var7);

    @Method(selector="scatterNDWithUpdatesTensor:indicesTensor:shape:batchDimensions:name:")
    public native MPSGraphTensor scatterND(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, @MachineSizedUInt long var4, String var6);

    @Method(selector="reshapeTensor:withShape:name:")
    public native MPSGraphTensor reshapeTensor(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="transposeTensor:dimension:withDimension:name:")
    public native MPSGraphTensor transposeTensor(MPSGraphTensor var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, String var6);

    @Method(selector="sliceTensor:dimension:start:length:name:")
    public native MPSGraphTensor sliceTensor(MPSGraphTensor var1, @MachineSizedUInt long var2, @MachineSizedSInt long var4, @MachineSizedSInt long var6, String var8);

    @Method(selector="concatTensor:withTensor:dimension:name:")
    public native MPSGraphTensor concatTensor(MPSGraphTensor var1, MPSGraphTensor var2, @MachineSizedUInt long var3, String var5);

    @Method(selector="concatTensors:dimension:name:")
    public native MPSGraphTensor concatTensors(NSArray<MPSGraphTensor> var1, @MachineSizedUInt long var2, String var4);

    @Method(selector="tileTensor:withMultiplier:name:")
    public native MPSGraphTensor tileTensor(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="tileGradientWithIncomingGradientTensor:sourceTensor:withMultiplier:name:")
    public native MPSGraphTensor tileGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, String var4);

    @Method(selector="padTensor:withPaddingMode:leftPadding:rightPadding:constantValue:name:")
    public native MPSGraphTensor padTensor(MPSGraphTensor var1, MPSGraphPaddingMode var2, NSArray<NSNumber> var3, NSArray<NSNumber> var4, double var5, String var7);

    @Method(selector="padGradientWithIncomingGradientTensor:sourceTensor:paddingMode:leftPadding:rightPadding:name:")
    public native MPSGraphTensor padGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphPaddingMode var3, NSArray<NSNumber> var4, NSArray<NSNumber> var5, String var6);

    static {
        ObjCRuntime.bind(MPSGraph.class);
    }

    public static class MPSGraphPtr
    extends Ptr<MPSGraph, MPSGraphPtr> {
    }
}

