/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.mlcompute;

import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.mlcompute.MLCDataType;
import org.robovm.apple.mlcompute.MLCDevice;
import org.robovm.apple.mlcompute.MLCRandomInitializerType;
import org.robovm.apple.mlcompute.MLCTensorData;
import org.robovm.apple.mlcompute.MLCTensorDescriptor;
import org.robovm.apple.mlcompute.MLCTensorOptimizerDeviceData;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="MLCompute")
@NativeClass
public class MLCTensor
extends NSObject {
    protected MLCTensor() {
    }

    protected MLCTensor(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected MLCTensor(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public MLCTensor(MLCTensorDescriptor tensorDescriptor) {
        super(null, MLCTensor.create(tensorDescriptor));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(MLCTensorDescriptor tensorDescriptor, MLCRandomInitializerType randomInitializerType) {
        super(null, MLCTensor.create(tensorDescriptor, randomInitializerType));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(MLCTensorDescriptor tensorDescriptor, NSNumber fillData) {
        super(null, MLCTensor.create(tensorDescriptor, fillData));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(MLCTensorDescriptor tensorDescriptor, MLCTensorData data) {
        super(null, MLCTensor.create(tensorDescriptor, data));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(NSArray<NSNumber> shape) {
        super(null, MLCTensor.create(shape));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(NSArray<NSNumber> shape, MLCRandomInitializerType randomInitializerType) {
        super(null, MLCTensor.create(shape, randomInitializerType));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(NSArray<NSNumber> shape, MLCDataType dataType) {
        super(null, MLCTensor.create(shape, dataType));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(NSArray<NSNumber> shape, MLCTensorData data, MLCDataType dataType) {
        super(null, MLCTensor.create(shape, data, dataType));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(NSArray<NSNumber> shape, NSNumber fillData, MLCDataType dataType) {
        super(null, MLCTensor.create(shape, fillData, dataType));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(@MachineSizedUInt long width, @MachineSizedUInt long height, @MachineSizedUInt long featureChannelCount, @MachineSizedUInt long batchSize) {
        super(null, MLCTensor.create(width, height, featureChannelCount, batchSize));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(@MachineSizedUInt long width, @MachineSizedUInt long height, @MachineSizedUInt long featureChannelCount, @MachineSizedUInt long batchSize, float fillData, MLCDataType dataType) {
        super(null, MLCTensor.create(width, height, featureChannelCount, batchSize, fillData, dataType));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(@MachineSizedUInt long width, @MachineSizedUInt long height, @MachineSizedUInt long featureChannelCount, @MachineSizedUInt long batchSize, MLCRandomInitializerType randomInitializerType) {
        super(null, MLCTensor.create(width, height, featureChannelCount, batchSize, randomInitializerType));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(@MachineSizedUInt long width, @MachineSizedUInt long height, @MachineSizedUInt long featureChannelCount, @MachineSizedUInt long batchSize, MLCTensorData data) {
        super(null, MLCTensor.create(width, height, featureChannelCount, batchSize, data));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(@MachineSizedUInt long width, @MachineSizedUInt long height, @MachineSizedUInt long featureChannelCount, @MachineSizedUInt long batchSize, MLCTensorData data, MLCDataType dataType) {
        super(null, MLCTensor.create(width, height, featureChannelCount, batchSize, data, dataType));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(@MachineSizedUInt long sequenceLength, @MachineSizedUInt long featureChannelCount, @MachineSizedUInt long batchSize) {
        super(null, MLCTensor.create(sequenceLength, featureChannelCount, batchSize));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(@MachineSizedUInt long sequenceLength, @MachineSizedUInt long featureChannelCount, @MachineSizedUInt long batchSize, MLCRandomInitializerType randomInitializerType) {
        super(null, MLCTensor.create(sequenceLength, featureChannelCount, batchSize, randomInitializerType));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(@MachineSizedUInt long sequenceLength, @MachineSizedUInt long featureChannelCount, @MachineSizedUInt long batchSize, MLCTensorData data) {
        super(null, MLCTensor.create(sequenceLength, featureChannelCount, batchSize, data));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(NSArray<NSNumber> sequenceLengths, boolean sortedSequences, @MachineSizedUInt long featureChannelCount, @MachineSizedUInt long batchSize, MLCRandomInitializerType randomInitializerType) {
        super(null, MLCTensor.create(sequenceLengths, sortedSequences, featureChannelCount, batchSize, randomInitializerType));
        MLCTensor.retain(this.getHandle());
    }

    public MLCTensor(NSArray<NSNumber> sequenceLengths, boolean sortedSequences, @MachineSizedUInt long featureChannelCount, @MachineSizedUInt long batchSize, MLCTensorData data) {
        super(null, MLCTensor.create(sequenceLengths, sortedSequences, featureChannelCount, batchSize, data));
        MLCTensor.retain(this.getHandle());
    }

    @Property(selector="tensorID")
    @MachineSizedUInt
    public native long getTensorID();

    @Property(selector="descriptor")
    public native MLCTensorDescriptor getDescriptor();

    @Property(selector="data")
    public native NSData getData();

    @Property(selector="label")
    public native String getLabel();

    @Property(selector="setLabel:")
    public native void setLabel(String var1);

    @Property(selector="device")
    public native MLCDevice getDevice();

    @Property(selector="optimizerData")
    public native NSArray<MLCTensorData> getOptimizerData();

    @Property(selector="optimizerDeviceData")
    public native NSArray<MLCTensorOptimizerDeviceData> getOptimizerDeviceData();

    @Property(selector="hasValidNumerics")
    public native boolean hasValidNumerics();

    @Method(selector="synchronizeData")
    public native boolean synchronizeData();

    @Method(selector="synchronizeOptimizerData")
    public native boolean synchronizeOptimizerData();

    @Method(selector="copyDataFromDeviceMemoryToBytes:length:synchronizeWithDevice:")
    public native boolean copyData(VoidPtr var1, @MachineSizedUInt long var2, boolean var4);

    @Method(selector="bindAndWriteData:toDevice:")
    public native boolean bindAndWriteData(MLCTensorData var1, MLCDevice var2);

    @Method(selector="bindOptimizerData:deviceData:")
    public native boolean bindOptimizerData(NSArray<MLCTensorData> var1, NSArray<MLCTensorOptimizerDeviceData> var2);

    @Method(selector="tensorWithDescriptor:")
    @Pointer
    protected static native long create(MLCTensorDescriptor var0);

    @Method(selector="tensorWithDescriptor:randomInitializerType:")
    @Pointer
    protected static native long create(MLCTensorDescriptor var0, MLCRandomInitializerType var1);

    @Method(selector="tensorWithDescriptor:fillWithData:")
    @Pointer
    protected static native long create(MLCTensorDescriptor var0, NSNumber var1);

    @Method(selector="tensorWithDescriptor:data:")
    @Pointer
    protected static native long create(MLCTensorDescriptor var0, MLCTensorData var1);

    @Method(selector="tensorWithShape:")
    @Pointer
    protected static native long create(NSArray<NSNumber> var0);

    @Method(selector="tensorWithShape:randomInitializerType:")
    @Pointer
    protected static native long create(NSArray<NSNumber> var0, MLCRandomInitializerType var1);

    @Method(selector="tensorWithShape:dataType:")
    @Pointer
    protected static native long create(NSArray<NSNumber> var0, MLCDataType var1);

    @Method(selector="tensorWithShape:data:dataType:")
    @Pointer
    protected static native long create(NSArray<NSNumber> var0, MLCTensorData var1, MLCDataType var2);

    @Method(selector="tensorWithShape:fillWithData:dataType:")
    @Pointer
    protected static native long create(NSArray<NSNumber> var0, NSNumber var1, MLCDataType var2);

    @Method(selector="tensorWithWidth:height:featureChannelCount:batchSize:")
    @Pointer
    protected static native long create(@MachineSizedUInt long var0, @MachineSizedUInt long var2, @MachineSizedUInt long var4, @MachineSizedUInt long var6);

    @Method(selector="tensorWithWidth:height:featureChannelCount:batchSize:fillWithData:dataType:")
    @Pointer
    protected static native long create(@MachineSizedUInt long var0, @MachineSizedUInt long var2, @MachineSizedUInt long var4, @MachineSizedUInt long var6, float var8, MLCDataType var9);

    @Method(selector="tensorWithWidth:height:featureChannelCount:batchSize:randomInitializerType:")
    @Pointer
    protected static native long create(@MachineSizedUInt long var0, @MachineSizedUInt long var2, @MachineSizedUInt long var4, @MachineSizedUInt long var6, MLCRandomInitializerType var8);

    @Method(selector="tensorWithWidth:height:featureChannelCount:batchSize:data:")
    @Pointer
    protected static native long create(@MachineSizedUInt long var0, @MachineSizedUInt long var2, @MachineSizedUInt long var4, @MachineSizedUInt long var6, MLCTensorData var8);

    @Method(selector="tensorWithWidth:height:featureChannelCount:batchSize:data:dataType:")
    @Pointer
    protected static native long create(@MachineSizedUInt long var0, @MachineSizedUInt long var2, @MachineSizedUInt long var4, @MachineSizedUInt long var6, MLCTensorData var8, MLCDataType var9);

    @Method(selector="tensorWithSequenceLength:featureChannelCount:batchSize:")
    @Pointer
    protected static native long create(@MachineSizedUInt long var0, @MachineSizedUInt long var2, @MachineSizedUInt long var4);

    @Method(selector="tensorWithSequenceLength:featureChannelCount:batchSize:randomInitializerType:")
    @Pointer
    protected static native long create(@MachineSizedUInt long var0, @MachineSizedUInt long var2, @MachineSizedUInt long var4, MLCRandomInitializerType var6);

    @Method(selector="tensorWithSequenceLength:featureChannelCount:batchSize:data:")
    @Pointer
    protected static native long create(@MachineSizedUInt long var0, @MachineSizedUInt long var2, @MachineSizedUInt long var4, MLCTensorData var6);

    @Method(selector="tensorWithSequenceLengths:sortedSequences:featureChannelCount:batchSize:randomInitializerType:")
    @Pointer
    protected static native long create(NSArray<NSNumber> var0, boolean var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, MLCRandomInitializerType var6);

    @Method(selector="tensorWithSequenceLengths:sortedSequences:featureChannelCount:batchSize:data:")
    @Pointer
    protected static native long create(NSArray<NSNumber> var0, boolean var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, MLCTensorData var6);

    static {
        ObjCRuntime.bind(MLCTensor.class);
    }

    public static class MLCTensorPtr
    extends Ptr<MLCTensor, MLCTensorPtr> {
    }
}

