/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSStringEncoding;
import org.robovm.apple.foundation.NSValue;
import org.robovm.apple.uikit.NSAttributedStringAttributes;
import org.robovm.apple.uikit.NSAttributedStringDocumentAttribute;
import org.robovm.apple.uikit.NSDocumentType;
import org.robovm.apple.uikit.NSDocumentViewMode;
import org.robovm.apple.uikit.NSTextLayoutSection;
import org.robovm.apple.uikit.UIColor;
import org.robovm.apple.uikit.UIEdgeInsets;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="UIKit")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class NSAttributedStringDocumentAttributes
extends NSDictionaryWrapper {
    NSAttributedStringDocumentAttributes(NSDictionary data) {
        super(data);
    }

    public NSAttributedStringDocumentAttributes() {
    }

    public boolean has(String key) {
        return this.data.containsKey(new NSString(key));
    }

    public NSObject get(String key) {
        if (this.has(key)) {
            return this.data.get(new NSString(key));
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes set(String key, NSObject value) {
        this.data.put(new NSString(key), value);
        return this;
    }

    public boolean has(NSAttributedStringDocumentAttribute key) {
        return this.data.containsKey(key.value());
    }

    public NSObject get(NSAttributedStringDocumentAttribute key) {
        if (this.has(key)) {
            return this.data.get(key.value());
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes set(NSAttributedStringDocumentAttribute key, NSObject value) {
        this.data.put((NSObject)key.value(), value);
        return this;
    }

    public NSDocumentType getDocumentType() {
        if (this.has(NSAttributedStringDocumentAttribute.DocumentType)) {
            NSString val = (NSString)this.get(NSAttributedStringDocumentAttribute.DocumentType);
            return NSDocumentType.valueOf(val);
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes setDocumentType(NSDocumentType documentType) {
        this.set(NSAttributedStringDocumentAttribute.DocumentType, (NSObject)documentType.value());
        return this;
    }

    public NSStringEncoding getCharacterEncoding() {
        if (this.has(NSAttributedStringDocumentAttribute.CharacterEncoding)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringDocumentAttribute.CharacterEncoding);
            return NSStringEncoding.valueOf(val.longValue());
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes setCharacterEncoding(NSStringEncoding characterEncoding) {
        this.set(NSAttributedStringDocumentAttribute.CharacterEncoding, (NSObject)NSNumber.valueOf(characterEncoding.value()));
        return this;
    }

    public NSAttributedStringAttributes getDefaultAttributes() {
        if (this.has(NSAttributedStringDocumentAttribute.DefaultAttributes)) {
            NSDictionary val = (NSDictionary)this.get(NSAttributedStringDocumentAttribute.DefaultAttributes);
            return new NSAttributedStringAttributes(val);
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes setDefaultAttributes(NSAttributedStringAttributes defaultAttributes) {
        this.set(NSAttributedStringDocumentAttribute.DefaultAttributes, (NSObject)defaultAttributes.getDictionary());
        return this;
    }

    public CGSize getPaperSize() {
        if (this.has(NSAttributedStringDocumentAttribute.PaperSize)) {
            NSValue val = (NSValue)this.get(NSAttributedStringDocumentAttribute.PaperSize);
            return val.sizeValue();
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes setPaperSize(CGSize paperSize) {
        this.set(NSAttributedStringDocumentAttribute.PaperSize, (NSObject)NSValue.valueOf(paperSize));
        return this;
    }

    public UIEdgeInsets getPaperMargin() {
        if (this.has(NSAttributedStringDocumentAttribute.PaperMargin)) {
            NSValue val = (NSValue)this.get(NSAttributedStringDocumentAttribute.PaperMargin);
            return val.edgeInsetsValue();
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes setPaperMargin(UIEdgeInsets paperMargin) {
        this.set(NSAttributedStringDocumentAttribute.PaperMargin, (NSObject)NSValue.valueOf(paperMargin));
        return this;
    }

    public CGSize getViewSize() {
        if (this.has(NSAttributedStringDocumentAttribute.ViewSize)) {
            NSValue val = (NSValue)this.get(NSAttributedStringDocumentAttribute.ViewSize);
            return val.sizeValue();
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes setViewSize(CGSize viewSize) {
        this.set(NSAttributedStringDocumentAttribute.ViewSize, (NSObject)NSValue.valueOf(viewSize));
        return this;
    }

    public double getViewZoom() {
        if (this.has(NSAttributedStringDocumentAttribute.ViewZoom)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringDocumentAttribute.ViewZoom);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSAttributedStringDocumentAttributes setViewZoom(double viewZoom) {
        this.set(NSAttributedStringDocumentAttribute.ViewZoom, (NSObject)NSNumber.valueOf(viewZoom));
        return this;
    }

    public boolean isReadOnly() {
        if (this.has(NSAttributedStringDocumentAttribute.ReadOnly)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringDocumentAttribute.ReadOnly);
            return val.booleanValue();
        }
        return false;
    }

    public NSAttributedStringDocumentAttributes setReadOnly(boolean readOnly) {
        this.set(NSAttributedStringDocumentAttribute.ReadOnly, (NSObject)NSNumber.valueOf(readOnly));
        return this;
    }

    public UIColor getBackgroundColor() {
        if (this.has(NSAttributedStringDocumentAttribute.BackgroundColor)) {
            UIColor val = (UIColor)this.get(NSAttributedStringDocumentAttribute.BackgroundColor);
            return val;
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes setBackgroundColor(UIColor backgroundColor) {
        this.set(NSAttributedStringDocumentAttribute.BackgroundColor, (NSObject)backgroundColor);
        return this;
    }

    public double getHyphenationFactor() {
        if (this.has(NSAttributedStringDocumentAttribute.HyphenationFactor)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringDocumentAttribute.HyphenationFactor);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSAttributedStringDocumentAttributes setHyphenationFactor(double hyphenationFactor) {
        this.set(NSAttributedStringDocumentAttribute.HyphenationFactor, (NSObject)NSNumber.valueOf(hyphenationFactor));
        return this;
    }

    public double getDefaultTabInterval() {
        if (this.has(NSAttributedStringDocumentAttribute.DefaultTabInterval)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringDocumentAttribute.DefaultTabInterval);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSAttributedStringDocumentAttributes setDefaultTabInterval(double defaultTabInterval) {
        this.set(NSAttributedStringDocumentAttribute.DefaultTabInterval, (NSObject)NSNumber.valueOf(defaultTabInterval));
        return this;
    }

    public NSDocumentViewMode getViewMode() {
        if (this.has(NSAttributedStringDocumentAttribute.ViewMode)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringDocumentAttribute.ViewMode);
            return NSDocumentViewMode.values()[val.intValue()];
        }
        return null;
    }

    public NSAttributedStringDocumentAttributes setViewMode(NSDocumentViewMode viewMode) {
        this.set(NSAttributedStringDocumentAttribute.ViewMode, (NSObject)NSNumber.valueOf(viewMode.ordinal()));
        return this;
    }

    public List<NSTextLayoutSection> getTextLayoutSections() {
        ArrayList<NSTextLayoutSection> list = new ArrayList<NSTextLayoutSection>();
        if (this.has(NSAttributedStringDocumentAttribute.TextLayoutSections)) {
            NSArray val = (NSArray)this.get(NSAttributedStringDocumentAttribute.TextLayoutSections);
            for (NSDictionary e : val) {
                list.add(new NSTextLayoutSection(e));
            }
        }
        return list;
    }

    public NSAttributedStringDocumentAttributes setTextLayoutSections(List<NSTextLayoutSection> sections) {
        NSMutableArray<NSDictionary> list = new NSMutableArray<NSDictionary>();
        for (NSTextLayoutSection e : sections) {
            list.add(e.getDictionary());
        }
        this.set(NSAttributedStringDocumentAttribute.TextLayoutSections, list);
        return this;
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<NSAttributedStringDocumentAttributes> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<NSAttributedStringDocumentAttributes> list = new ArrayList<NSAttributedStringDocumentAttributes>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new NSAttributedStringDocumentAttributes((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<NSAttributedStringDocumentAttributes> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (NSAttributedStringDocumentAttributes i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSAttributedStringDocumentAttributes toObject(Class<NSAttributedStringDocumentAttributes> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSAttributedStringDocumentAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(NSAttributedStringDocumentAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

