/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.List;
import org.robovm.apple.avfoundation.AVKeyValueStatus;
import org.robovm.apple.avfoundation.AVMetadataExtraAttributes;
import org.robovm.apple.avfoundation.AVMetadataIdentifier;
import org.robovm.apple.avfoundation.AVMetadataItemFilter;
import org.robovm.apple.avfoundation.AVMetadataItemValueRequest;
import org.robovm.apple.avfoundation.AVMetadataKey;
import org.robovm.apple.avfoundation.AVMetadataKeyCommon;
import org.robovm.apple.avfoundation.AVMetadataKeySpace;
import org.robovm.apple.coremedia.CMMetadataDataType;
import org.robovm.apple.coremedia.CMTime;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSLocale;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVMetadataItem
extends NSObject {
    public AVMetadataItem() {
    }

    protected AVMetadataItem(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected AVMetadataItem(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public AVMetadataItem(AVMetadataItem metadataItem, @Block VoidBlock1<AVMetadataItemValueRequest> handler) {
        super(null, AVMetadataItem.create(metadataItem, handler));
        AVMetadataItem.retain(this.getHandle());
    }

    @Property(selector="identifier")
    public native AVMetadataIdentifier getIdentifier();

    @Property(selector="extendedLanguageTag")
    public native String getExtendedLanguageTag();

    @Property(selector="locale")
    public native NSLocale getLocale();

    @Property(selector="time")
    @ByVal
    public native CMTime getTime();

    @Property(selector="duration")
    @ByVal
    public native CMTime getDuration();

    @Property(selector="dataType")
    public native CMMetadataDataType getDataType();

    @Property(selector="value")
    public native NSObject getValue();

    @Property(selector="extraAttributes")
    public native AVMetadataExtraAttributes getExtraAttributes();

    @Property(selector="startDate")
    public native NSDate getStartDate();

    @Property(selector="stringValue")
    public native String getStringValue();

    @Property(selector="numberValue")
    public native NSNumber getNumberValue();

    @Property(selector="dateValue")
    public native NSDate getDateValue();

    @Property(selector="dataValue")
    public native NSData getDataValue();

    @Property(selector="key")
    public native AVMetadataKey getKey();

    @Property(selector="commonKey")
    public native AVMetadataKeyCommon getCommonKey();

    @Property(selector="keySpace")
    public native AVMetadataKeySpace getKeySpace();

    public AVKeyValueStatus getStatusOfValue(AVMetadataKey key) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        AVKeyValueStatus result = this.getStatusOfValue(key, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="statusOfValueForKey:error:")
    private native AVKeyValueStatus getStatusOfValue(AVMetadataKey var1, NSError.NSErrorPtr var2);

    @Method(selector="loadValuesAsynchronouslyForKeys:completionHandler:")
    public native void loadValuesAsynchronously(@Marshaler(value=AVMetadataKey.AsListMarshaler.class) List<AVMetadataKey> var1, @Block Runnable var2);

    @Method(selector="metadataItemsFromArray:filteredAndSortedAccordingToPreferredLanguages:")
    public static native NSArray<AVMetadataItem> filterMetadataItemsByPreferredLanguages(NSArray<AVMetadataItem> var0, @Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1);

    @Method(selector="metadataItemsFromArray:filteredByIdentifier:")
    public static native NSArray<AVMetadataItem> filterMetadataItemsByIdentifier(NSArray<AVMetadataItem> var0, AVMetadataIdentifier var1);

    @Method(selector="metadataItemsFromArray:filteredByMetadataItemFilter:")
    public static native NSArray<AVMetadataItem> filterMetadataItems(NSArray<AVMetadataItem> var0, AVMetadataItemFilter var1);

    @Method(selector="identifierForKey:keySpace:")
    public static native AVMetadataIdentifier getIdentifierForKey(AVMetadataKey var0, AVMetadataKeySpace var1);

    @Method(selector="keySpaceForIdentifier:")
    public static native AVMetadataKeySpace getKeySpaceForIdentifier(AVMetadataIdentifier var0);

    @Method(selector="keyForIdentifier:")
    public static native AVMetadataKey getKeyForIdentifier(AVMetadataIdentifier var0);

    @Method(selector="metadataItemWithPropertiesOfMetadataItem:valueLoadingHandler:")
    @Pointer
    protected static native long create(AVMetadataItem var0, @Block VoidBlock1<AVMetadataItemValueRequest> var1);

    @Method(selector="metadataItemsFromArray:withLocale:")
    public static native NSArray<AVMetadataItem> filterMetadataItemsByLocale(NSArray<AVMetadataItem> var0, NSLocale var1);

    @Method(selector="metadataItemsFromArray:withKey:keySpace:")
    public static native NSArray<AVMetadataItem> filterMetadataItemsByKey(NSArray<AVMetadataItem> var0, AVMetadataKey var1, AVMetadataKeySpace var2);

    static {
        ObjCRuntime.bind(AVMetadataItem.class);
    }

    public static class AVMetadataItemPtr
    extends Ptr<AVMetadataItem, AVMetadataItemPtr> {
    }
}

