/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.List;
import org.robovm.apple.avfoundation.AVAsset;
import org.robovm.apple.avfoundation.AVAudioMix;
import org.robovm.apple.avfoundation.AVAudioSpatializationFormats;
import org.robovm.apple.avfoundation.AVMediaSelection;
import org.robovm.apple.avfoundation.AVMediaSelectionGroup;
import org.robovm.apple.avfoundation.AVMediaSelectionOption;
import org.robovm.apple.avfoundation.AVMetadataItem;
import org.robovm.apple.avfoundation.AVPlayerItemAccessLog;
import org.robovm.apple.avfoundation.AVPlayerItemErrorLog;
import org.robovm.apple.avfoundation.AVPlayerItemMediaDataCollector;
import org.robovm.apple.avfoundation.AVPlayerItemOutput;
import org.robovm.apple.avfoundation.AVPlayerItemStatus;
import org.robovm.apple.avfoundation.AVPlayerItemTrack;
import org.robovm.apple.avfoundation.AVTextStyleRule;
import org.robovm.apple.avfoundation.AVVariantPreferences;
import org.robovm.apple.avfoundation.AVVideoApertureMode;
import org.robovm.apple.avfoundation.AVVideoCompositing;
import org.robovm.apple.avfoundation.AVVideoComposition;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.coremedia.CMTime;
import org.robovm.apple.coremedia.CMTimeRange;
import org.robovm.apple.coremedia.CMTimebase;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.objc.block.VoidBooleanBlock;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVPlayerItem
extends NSObject {
    protected AVPlayerItem() {
    }

    protected AVPlayerItem(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected AVPlayerItem(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithURL:")
    public AVPlayerItem(NSURL URL2) {
        super(null);
        this.initObject(this.init(URL2));
    }

    @Method(selector="initWithAsset:")
    public AVPlayerItem(AVAsset asset) {
        super(null);
        this.initObject(this.init(asset));
    }

    @Method(selector="initWithAsset:automaticallyLoadedAssetKeys:")
    public AVPlayerItem(AVAsset asset, @Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> automaticallyLoadedAssetKeys) {
        super(null);
        this.initObject(this.init(asset, automaticallyLoadedAssetKeys));
    }

    @Property(selector="status")
    public native AVPlayerItemStatus getStatus();

    @Property(selector="error")
    public native NSError getError();

    @Property(selector="asset")
    public native AVAsset getAsset();

    @Property(selector="tracks")
    public native NSArray<AVPlayerItemTrack> getTracks();

    @Property(selector="duration")
    @ByVal
    public native CMTime getDuration();

    @Property(selector="presentationSize")
    @ByVal
    public native CGSize getPresentationSize();

    @Deprecated
    @Property(selector="timedMetadata")
    public native NSArray<AVMetadataItem> getTimedMetadata();

    @Property(selector="automaticallyLoadedAssetKeys")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getAutomaticallyLoadedAssetKeys();

    @Property(selector="canPlayFastForward")
    public native boolean canPlayFastForward();

    @Property(selector="canPlaySlowForward")
    public native boolean canPlaySlowForward();

    @Property(selector="canPlayReverse")
    public native boolean canPlayReverse();

    @Property(selector="canPlaySlowReverse")
    public native boolean canPlaySlowReverse();

    @Property(selector="canPlayFastReverse")
    public native boolean canPlayFastReverse();

    @Property(selector="canStepForward")
    public native boolean canStepForward();

    @Property(selector="canStepBackward")
    public native boolean canStepBackward();

    @Property(selector="configuredTimeOffsetFromLive")
    @ByVal
    public native CMTime getConfiguredTimeOffsetFromLive();

    @Property(selector="setConfiguredTimeOffsetFromLive:")
    public native void setConfiguredTimeOffsetFromLive(@ByVal CMTime var1);

    @Property(selector="recommendedTimeOffsetFromLive")
    @ByVal
    public native CMTime getRecommendedTimeOffsetFromLive();

    @Property(selector="automaticallyPreservesTimeOffsetFromLive")
    public native boolean automaticallyPreservesTimeOffsetFromLive();

    @Property(selector="setAutomaticallyPreservesTimeOffsetFromLive:")
    public native void setAutomaticallyPreservesTimeOffsetFromLive(boolean var1);

    @Property(selector="forwardPlaybackEndTime")
    @ByVal
    public native CMTime getForwardPlaybackEndTime();

    @Property(selector="setForwardPlaybackEndTime:")
    public native void setForwardPlaybackEndTime(@ByVal CMTime var1);

    @Property(selector="reversePlaybackEndTime")
    @ByVal
    public native CMTime getReversePlaybackEndTime();

    @Property(selector="setReversePlaybackEndTime:")
    public native void setReversePlaybackEndTime(@ByVal CMTime var1);

    @Property(selector="seekableTimeRanges")
    @Marshaler(value=CMTimeRange.AsValuedListMarshaler.class)
    public native List<CMTimeRange> getSeekableTimeRanges();

    @Property(selector="timebase")
    public native CMTimebase getTimebase();

    @Property(selector="videoComposition")
    public native AVVideoComposition getVideoComposition();

    @Property(selector="setVideoComposition:")
    public native void setVideoComposition(AVVideoComposition var1);

    @Property(selector="customVideoCompositor")
    public native AVVideoCompositing getCustomVideoCompositor();

    @Property(selector="seekingWaitsForVideoCompositionRendering")
    public native boolean seekingWaitsForVideoCompositionRendering();

    @Property(selector="setSeekingWaitsForVideoCompositionRendering:")
    public native void seekingWaitsForVideoCompositionRendering(boolean var1);

    @Property(selector="textStyleRules")
    public native NSArray<AVTextStyleRule> getTextStyleRules();

    @Property(selector="setTextStyleRules:")
    public native void setTextStyleRules(NSArray<AVTextStyleRule> var1);

    @Property(selector="videoApertureMode")
    public native AVVideoApertureMode getVideoApertureMode();

    @Property(selector="setVideoApertureMode:")
    public native void setVideoApertureMode(AVVideoApertureMode var1);

    @Property(selector="appliesPerFrameHDRDisplayMetadata")
    public native boolean appliesPerFrameHDRDisplayMetadata();

    @Property(selector="setAppliesPerFrameHDRDisplayMetadata:")
    public native void setAppliesPerFrameHDRDisplayMetadata(boolean var1);

    @Property(selector="audioTimePitchAlgorithm")
    public native String getAudioTimePitchAlgorithm();

    @Property(selector="setAudioTimePitchAlgorithm:")
    public native void setAudioTimePitchAlgorithm(String var1);

    @Deprecated
    @Property(selector="isAudioSpatializationAllowed")
    public native boolean isAudioSpatializationAllowed();

    @Deprecated
    @Property(selector="setAudioSpatializationAllowed:")
    public native void setAudioSpatializationAllowed(boolean var1);

    @Property(selector="allowedAudioSpatializationFormats")
    public native AVAudioSpatializationFormats getAllowedAudioSpatializationFormats();

    @Property(selector="setAllowedAudioSpatializationFormats:")
    public native void setAllowedAudioSpatializationFormats(AVAudioSpatializationFormats var1);

    @Property(selector="audioMix")
    public native AVAudioMix getAudioMix();

    @Property(selector="setAudioMix:")
    public native void setAudioMix(AVAudioMix var1);

    @Property(selector="loadedTimeRanges")
    @Marshaler(value=CMTimeRange.AsValuedListMarshaler.class)
    public native List<CMTimeRange> getLoadedTimeRanges();

    @Property(selector="isPlaybackLikelyToKeepUp")
    public native boolean isPlaybackLikelyToKeepUp();

    @Property(selector="isPlaybackBufferFull")
    public native boolean isPlaybackBufferFull();

    @Property(selector="isPlaybackBufferEmpty")
    public native boolean isPlaybackBufferEmpty();

    @Property(selector="canUseNetworkResourcesForLiveStreamingWhilePaused")
    public native boolean canUseNetworkResourcesForLiveStreamingWhilePaused();

    @Property(selector="setCanUseNetworkResourcesForLiveStreamingWhilePaused:")
    public native void setCanUseNetworkResourcesForLiveStreamingWhilePaused(boolean var1);

    @Property(selector="preferredForwardBufferDuration")
    public native double getPreferredForwardBufferDuration();

    @Property(selector="setPreferredForwardBufferDuration:")
    public native void setPreferredForwardBufferDuration(double var1);

    @Property(selector="preferredPeakBitRate")
    public native double getPreferredPeakBitRate();

    @Property(selector="setPreferredPeakBitRate:")
    public native void setPreferredPeakBitRate(double var1);

    @Property(selector="preferredMaximumResolution")
    @ByVal
    public native CGSize getPreferredMaximumResolution();

    @Property(selector="setPreferredMaximumResolution:")
    public native void setPreferredMaximumResolution(@ByVal CGSize var1);

    @Property(selector="startsOnFirstEligibleVariant")
    public native boolean isStartsOnFirstEligibleVariant();

    @Property(selector="setStartsOnFirstEligibleVariant:")
    public native void setStartsOnFirstEligibleVariant(boolean var1);

    @Property(selector="variantPreferences")
    public native AVVariantPreferences getVariantPreferences();

    @Property(selector="setVariantPreferences:")
    public native void setVariantPreferences(AVVariantPreferences var1);

    @Property(selector="currentMediaSelection")
    public native AVMediaSelection getCurrentMediaSelection();

    @Property(selector="outputs")
    public native NSArray<AVPlayerItemOutput> getOutputs();

    @Property(selector="mediaDataCollectors")
    public native NSArray<AVPlayerItemMediaDataCollector> getMediaDataCollectors();

    @Property(selector="automaticallyHandlesInterstitialEvents")
    public native boolean automaticallyHandlesInterstitialEvents();

    @Property(selector="setAutomaticallyHandlesInterstitialEvents:")
    public native void setAutomaticallyHandlesInterstitialEvents(boolean var1);

    @Property(selector="templatePlayerItem")
    public native AVPlayerItem getTemplatePlayerItem();

    @GlobalValue(symbol="AVPlayerItemTimeJumpedNotification", optional=true)
    public static native NSString TimeJumpedNotification();

    @GlobalValue(symbol="AVPlayerItemDidPlayToEndTimeNotification", optional=true)
    public static native NSString DidPlayToEndTimeNotification();

    @GlobalValue(symbol="AVPlayerItemFailedToPlayToEndTimeNotification", optional=true)
    public static native NSString FailedToPlayToEndTimeNotification();

    @GlobalValue(symbol="AVPlayerItemPlaybackStalledNotification", optional=true)
    public static native NSString PlaybackStalledNotification();

    @GlobalValue(symbol="AVPlayerItemNewAccessLogEntryNotification", optional=true)
    public static native NSString NewAccessLogEntryNotification();

    @GlobalValue(symbol="AVPlayerItemNewErrorLogEntryNotification", optional=true)
    public static native NSString NewErrorLogEntryNotification();

    @GlobalValue(symbol="AVPlayerItemRecommendedTimeOffsetFromLiveDidChangeNotification", optional=true)
    public static native NSString RecommendedTimeOffsetFromLiveDidChangeNotification();

    @GlobalValue(symbol="AVPlayerItemMediaSelectionDidChangeNotification", optional=true)
    public static native NSString MediaSelectionDidChangeNotification();

    @GlobalValue(symbol="AVPlayerItemFailedToPlayToEndTimeErrorKey", optional=true)
    protected static native NSString FailedToPlayToEndTimeErrorKey();

    @Method(selector="initWithURL:")
    @Pointer
    protected native long init(NSURL var1);

    @Method(selector="initWithAsset:")
    @Pointer
    protected native long init(AVAsset var1);

    @Method(selector="initWithAsset:automaticallyLoadedAssetKeys:")
    @Pointer
    protected native long init(AVAsset var1, @Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var2);

    @Method(selector="currentTime")
    @ByVal
    public native CMTime getCurrentTime();

    @Method(selector="seekToTime:completionHandler:")
    public native void seekToTime(@ByVal CMTime var1, @Block VoidBooleanBlock var2);

    @Method(selector="seekToTime:toleranceBefore:toleranceAfter:completionHandler:")
    public native void seekToTime(@ByVal CMTime var1, @ByVal CMTime var2, @ByVal CMTime var3, @Block VoidBooleanBlock var4);

    @Method(selector="cancelPendingSeeks")
    public native void cancelPendingSeeks();

    @Method(selector="currentDate")
    public native NSDate getCurrentDate();

    @Method(selector="seekToDate:completionHandler:")
    public native boolean seekToDate(NSDate var1, @Block VoidBooleanBlock var2);

    @Method(selector="stepByCount:")
    public native void stepByCount(@MachineSizedSInt long var1);

    @Method(selector="selectMediaOption:inMediaSelectionGroup:")
    public native void selectMediaOption(AVMediaSelectionOption var1, AVMediaSelectionGroup var2);

    @Method(selector="selectMediaOptionAutomaticallyInMediaSelectionGroup:")
    public native void selectMediaOptionAutomatically(AVMediaSelectionGroup var1);

    @Method(selector="accessLog")
    public native AVPlayerItemAccessLog getAccessLog();

    @Method(selector="errorLog")
    public native AVPlayerItemErrorLog getErrorLog();

    @Method(selector="addOutput:")
    public native void addOutput(AVPlayerItemOutput var1);

    @Method(selector="removeOutput:")
    public native void removeOutput(AVPlayerItemOutput var1);

    @Method(selector="addMediaDataCollector:")
    public native void addMediaDataCollector(AVPlayerItemMediaDataCollector var1);

    @Method(selector="removeMediaDataCollector:")
    public native void removeMediaDataCollector(AVPlayerItemMediaDataCollector var1);

    @Deprecated
    @Method(selector="seekToTime:")
    public native void seekToTime(@ByVal CMTime var1);

    @Deprecated
    @Method(selector="seekToTime:toleranceBefore:toleranceAfter:")
    public native void seekToTime(@ByVal CMTime var1, @ByVal CMTime var2, @ByVal CMTime var3);

    @Deprecated
    @Method(selector="seekToDate:")
    public native boolean seekToDate(NSDate var1);

    @Deprecated
    @Method(selector="selectedMediaOptionInMediaSelectionGroup:")
    public native AVMediaSelectionOption getSelectedMediaOption(AVMediaSelectionGroup var1);

    static {
        ObjCRuntime.bind(AVPlayerItem.class);
    }

    public static class AVPlayerItemPtr
    extends Ptr<AVPlayerItem, AVPlayerItemPtr> {
    }

    public static class Notifications {
        public static NSObject observeTimeJumped(AVPlayerItem object, final VoidBlock1<AVPlayerItem> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVPlayerItem.TimeJumpedNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification notification) {
                    block.invoke((Object)((AVPlayerItem)notification.getObject()));
                }
            });
        }

        public static NSObject observeDidPlayToEndTime(AVPlayerItem object, final VoidBlock1<AVPlayerItem> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVPlayerItem.DidPlayToEndTimeNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification notification) {
                    block.invoke((Object)((AVPlayerItem)notification.getObject()));
                }
            });
        }

        public static NSObject observeFailedToPlayToEndTime(AVPlayerItem object, final VoidBlock2<AVPlayerItem, NSError> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVPlayerItem.FailedToPlayToEndTimeNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification notification) {
                    NSDictionary<?, ?> data = notification.getUserInfo();
                    NSError error = null;
                    if (data.containsKey(AVPlayerItem.FailedToPlayToEndTimeErrorKey())) {
                        error = (NSError)data.get(AVPlayerItem.FailedToPlayToEndTimeErrorKey());
                    }
                    block.invoke((Object)((AVPlayerItem)notification.getObject()), (Object)error);
                }
            });
        }

        public static NSObject observePlaybackStalled(AVPlayerItem object, final VoidBlock1<AVPlayerItem> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVPlayerItem.PlaybackStalledNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification notification) {
                    block.invoke((Object)((AVPlayerItem)notification.getObject()));
                }
            });
        }

        public static NSObject observeNewAccessLogEntry(AVPlayerItem object, final VoidBlock1<AVPlayerItem> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVPlayerItem.NewAccessLogEntryNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification notification) {
                    block.invoke((Object)((AVPlayerItem)notification.getObject()));
                }
            });
        }

        public static NSObject observeNewErrorLogEntry(AVPlayerItem object, final VoidBlock1<AVPlayerItem> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVPlayerItem.NewErrorLogEntryNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification notification) {
                    block.invoke((Object)((AVPlayerItem)notification.getObject()));
                }
            });
        }
    }
}

