/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coredata;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.coredata.NSPersistentStoreType;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSUUID;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreData")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class NSPersistentStoreMetadata
extends NSDictionaryWrapper {
    NSPersistentStoreMetadata(NSDictionary data) {
        super(data);
    }

    public NSPersistentStoreMetadata() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public NSPersistentStoreMetadata set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public String getType() {
        if (this.has(Keys.Type())) {
            NSString val = (NSString)this.get(Keys.Type());
            return val.toString();
        }
        return null;
    }

    public NSPersistentStoreMetadata setType(String type) {
        this.set(Keys.Type(), new NSString(type));
        return this;
    }

    public NSUUID getUUID() {
        if (this.has(Keys.UUID())) {
            NSUUID val = (NSUUID)this.get(Keys.UUID());
            return val;
        }
        return null;
    }

    public NSPersistentStoreMetadata setUUID(NSUUID uUID) {
        this.set(Keys.UUID(), uUID);
        return this;
    }

    public NSDictionary<?, ?> getModelVersionHashes() {
        if (this.has(Keys.ModelVersionHashes())) {
            NSDictionary val = (NSDictionary)this.get(Keys.ModelVersionHashes());
            return val;
        }
        return null;
    }

    public NSSet<?> getModelVersionIdentifiers() {
        if (this.has(Keys.ModelVersionIdentifiers())) {
            NSSet val = (NSSet)this.get(Keys.ModelVersionIdentifiers());
            return val;
        }
        return null;
    }

    public long getOSCompatibility() {
        if (this.has(Keys.OSCompatibility())) {
            NSNumber val = (NSNumber)this.get(Keys.OSCompatibility());
            return val.longValue();
        }
        return 0L;
    }

    public NSPersistentStoreMetadata setType(NSPersistentStoreType type) {
        this.data.put(Keys.Type(), (NSObject)type.value());
        return this;
    }

    @Library(value="CoreData")
    public static class Keys {
        @GlobalValue(symbol="NSStoreTypeKey", optional=true)
        public static native NSString Type();

        @GlobalValue(symbol="NSStoreUUIDKey", optional=true)
        public static native NSString UUID();

        @GlobalValue(symbol="NSStoreModelVersionHashesKey", optional=true)
        public static native NSString ModelVersionHashes();

        @GlobalValue(symbol="NSStoreModelVersionIdentifiersKey", optional=true)
        public static native NSString ModelVersionIdentifiers();

        @GlobalValue(symbol="NSPersistentStoreOSCompatibility", optional=true)
        public static native NSString OSCompatibility();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<NSPersistentStoreMetadata> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<NSPersistentStoreMetadata> list = new ArrayList<NSPersistentStoreMetadata>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new NSPersistentStoreMetadata((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<NSPersistentStoreMetadata> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (NSPersistentStoreMetadata i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSPersistentStoreMetadata toObject(Class<NSPersistentStoreMetadata> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSPersistentStoreMetadata(o);
        }

        @MarshalsPointer
        public static long toNative(NSPersistentStoreMetadata o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

