/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corehaptic;

import org.robovm.apple.avfoundation.AVAudioSession;
import org.robovm.apple.corehaptic.CHHapticAdvancedPatternPlayer;
import org.robovm.apple.corehaptic.CHHapticDeviceCapability;
import org.robovm.apple.corehaptic.CHHapticEngineFinishedAction;
import org.robovm.apple.corehaptic.CHHapticEngineStoppedReason;
import org.robovm.apple.corehaptic.CHHapticPattern;
import org.robovm.apple.corehaptic.CHHapticPatternPlayer;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.Block1;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreHaptics")
@NativeClass
public class CHHapticEngine
extends NSObject {
    protected CHHapticEngine(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected CHHapticEngine(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initAndReturnError:")
    public CHHapticEngine() throws NSErrorException {
        super(null);
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long handle = this.init(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        this.initObject(handle);
    }

    @Method(selector="initWithAudioSession:error:")
    public CHHapticEngine(AVAudioSession audioSession) throws NSErrorException {
        super(null);
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long handle = this.init(audioSession, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        this.initObject(handle);
    }

    @Property(selector="currentTime")
    public native double getCurrentTime();

    @Property(selector="stoppedHandler")
    @Block
    public native VoidBlock1<CHHapticEngineStoppedReason> getStoppedHandler();

    @Property(selector="setStoppedHandler:")
    public native void setStoppedHandler(@Block VoidBlock1<CHHapticEngineStoppedReason> var1);

    @Property(selector="resetHandler")
    @Block
    public native Runnable getResetHandler();

    @Property(selector="setResetHandler:")
    public native void setResetHandler(@Block Runnable var1);

    @Property(selector="playsHapticsOnly")
    public native boolean isPlaysHapticsOnly();

    @Property(selector="setPlaysHapticsOnly:")
    public native void setPlaysHapticsOnly(boolean var1);

    @Property(selector="isMutedForAudio")
    public native boolean isMutedForAudio();

    @Property(selector="setIsMutedForAudio:")
    public native void setIsMutedForAudio(boolean var1);

    @Property(selector="isMutedForHaptics")
    public native boolean isMutedForHaptics();

    @Property(selector="setIsMutedForHaptics:")
    public native void setIsMutedForHaptics(boolean var1);

    @Property(selector="isAutoShutdownEnabled")
    public native boolean isAutoShutdownEnabled();

    @Property(selector="setAutoShutdownEnabled:")
    public native void setAutoShutdownEnabled(boolean var1);

    @Method(selector="initAndReturnError:")
    @Pointer
    private native long init(NSError.NSErrorPtr var1);

    @Method(selector="initWithAudioSession:error:")
    @Pointer
    private native long init(AVAudioSession var1, NSError.NSErrorPtr var2);

    @Method(selector="startWithCompletionHandler:")
    public native void start(@Block VoidBlock1<NSError> var1);

    @Method(selector="startAndReturnError:")
    public native boolean startAndReturnError(NSError.NSErrorPtr var1);

    @Method(selector="stopWithCompletionHandler:")
    public native void stop(@Block VoidBlock1<NSError> var1);

    @Method(selector="notifyWhenPlayersFinished:")
    public native void notifyWhenPlayersFinished(@Block Block1<NSError, CHHapticEngineFinishedAction> var1);

    public CHHapticPatternPlayer createPlayer(CHHapticPattern pattern) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        CHHapticPatternPlayer result = this.createPlayer(pattern, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="createPlayerWithPattern:error:")
    private native CHHapticPatternPlayer createPlayer(CHHapticPattern var1, NSError.NSErrorPtr var2);

    public CHHapticAdvancedPatternPlayer createAdvancedPlayer(CHHapticPattern pattern) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        CHHapticAdvancedPatternPlayer result = this.createAdvancedPlayer(pattern, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="createAdvancedPlayerWithPattern:error:")
    private native CHHapticAdvancedPatternPlayer createAdvancedPlayer(CHHapticPattern var1, NSError.NSErrorPtr var2);

    @MachineSizedUInt
    public long registerAudioResource(NSURL resourceURL, NSDictionary<?, ?> options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long result = this.registerAudioResource(resourceURL, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="registerAudioResource:options:error:")
    @MachineSizedUInt
    private native long registerAudioResource(NSURL var1, NSDictionary<?, ?> var2, NSError.NSErrorPtr var3);

    public boolean unregisterAudioResource(@MachineSizedUInt long resourceID) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.unregisterAudioResource(resourceID, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="unregisterAudioResource:error:")
    private native boolean unregisterAudioResource(@MachineSizedUInt long var1, NSError.NSErrorPtr var3);

    public boolean playPattern(NSURL fileURL) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.playPattern(fileURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="playPatternFromURL:error:")
    private native boolean playPattern(NSURL var1, NSError.NSErrorPtr var2);

    public boolean playPattern(NSData data) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.playPattern(data, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="playPatternFromData:error:")
    private native boolean playPattern(NSData var1, NSError.NSErrorPtr var2);

    @Method(selector="capabilitiesForHardware")
    public static native CHHapticDeviceCapability capabilitiesForHardware();

    static {
        ObjCRuntime.bind(CHHapticEngine.class);
    }

    public static class CHHapticEnginePtr
    extends Ptr<CHHapticEngine, CHHapticEnginePtr> {
    }
}

