/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coremidi;

import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.coremidi.MIDIDriver;
import org.robovm.apple.coremidi.MIDIEntity;
import org.robovm.apple.coremidi.MIDIError;
import org.robovm.apple.coremidi.MIDIObject;
import org.robovm.apple.coremidi.MIDIProtocolID;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreMIDI")
public class MIDIDevice
extends MIDIObject {
    public MIDIError addEntity(String name, boolean embedded, @MachineSizedUInt long numSourceEndpoints, @MachineSizedUInt long numDestinationEndpoints, MIDIEntity newEntity) {
        MIDIEntity.MIDIEntityPtr ptr = new MIDIEntity.MIDIEntityPtr();
        ptr.set(newEntity);
        return this.addEntity(name, embedded, numSourceEndpoints, numDestinationEndpoints, ptr);
    }

    public static MIDIDevice create(MIDIDriver owner, String name, String manufacturer, String model) {
        MIDIDevicePtr ptr = new MIDIDevicePtr();
        MIDIDevice.create(owner, name, manufacturer, model, ptr);
        return (MIDIDevice)ptr.get();
    }

    public static MIDIDevice createExternal(String name, String manufacturer, String model) {
        MIDIDevicePtr ptr = new MIDIDevicePtr();
        MIDIDevice.createExternal(name, manufacturer, model, ptr);
        return (MIDIDevice)ptr.get();
    }

    @Bridge(symbol="MIDIDeviceGetNumberOfEntities", optional=true)
    @MachineSizedUInt
    public native long getNumberOfEntities();

    @Bridge(symbol="MIDIDeviceGetEntity", optional=true)
    public native MIDIEntity getEntity(@MachineSizedUInt long var1);

    @Bridge(symbol="MIDIDeviceNewEntity", optional=true)
    public native OSStatus newEntity(String var1, MIDIProtocolID var2, boolean var3, @MachineSizedUInt long var4, @MachineSizedUInt long var6, MIDIEntity.MIDIEntityPtr var8);

    @Deprecated
    @Bridge(symbol="MIDIDeviceAddEntity", optional=true)
    protected native MIDIError addEntity(String var1, boolean var2, @MachineSizedUInt long var3, @MachineSizedUInt long var5, MIDIEntity.MIDIEntityPtr var7);

    @Bridge(symbol="MIDIDeviceRemoveEntity", optional=true)
    public native MIDIError removeEntity(MIDIEntity var1);

    @Bridge(symbol="MIDIExternalDeviceCreate", optional=true)
    protected static native MIDIError createExternal(String var0, String var1, String var2, MIDIDevicePtr var3);

    @Bridge(symbol="MIDIDeviceCreate", optional=true)
    protected static native MIDIError create(MIDIDriver var0, String var1, String var2, String var3, MIDIDevicePtr var4);

    @Bridge(symbol="MIDIDeviceDispose", optional=true)
    public native MIDIError dispose();

    static {
        Bro.bind(MIDIDevice.class);
    }

    public static class MIDIDevicePtr
    extends Ptr<MIDIDevice, MIDIDevicePtr> {
    }
}

