/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.cryptotokenkit;

import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorCode;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.ValuedEnum;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;

@Marshaler(value=ValuedEnum.AsMachineSizedSIntMarshaler.class)
@Library(value="CryptoTokenKit")
public enum TKErrorCode implements NSErrorCode
{
    CodeNotImplemented(-1L),
    CodeCommunicationError(-2L),
    CodeCorruptedData(-3L),
    CodeCanceledByUser(-4L),
    CodeAuthenticationFailed(-5L),
    CodeObjectNotFound(-6L),
    CodeTokenNotFound(-7L),
    CodeBadParameter(-8L),
    CodeAuthenticationNeeded(-9L),
    AuthenticationFailed(-5L),
    ObjectNotFound(-6L),
    TokenNotFound(-7L);

    private final long n;

    @GlobalValue(symbol="TKErrorDomain", optional=true)
    public static native String getClassDomain();

    private TKErrorCode(long n2) {
        this.n = n2;
    }

    public long value() {
        return this.n;
    }

    public static TKErrorCode valueOf(long n) {
        for (TKErrorCode v : TKErrorCode.values()) {
            if (v.n != n) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " + TKErrorCode.class.getName());
    }

    static {
        Bro.bind(TKErrorCode.class);
        Bro.bind(NSErrorWrap.class);
    }

    @StronglyLinked
    public static class NSErrorWrap
    extends NSError {
        protected NSErrorWrap(NSObject.SkipInit skipInit) {
            super(skipInit);
        }

        @Override
        public NSErrorCode getErrorCode() {
            try {
                return TKErrorCode.valueOf(this.getCode());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static String getClassDomain() {
            return TKErrorCode.getClassDomain();
        }
    }
}

