/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.glkit;

import java.nio.FloatBuffer;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Array;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

public class GLKVector3
extends Struct<GLKVector3> {
    public GLKVector3() {
    }

    public GLKVector3(FloatBuffer v) {
        this.setV(v);
    }

    @StructMember(value=0)
    @Array(value={3})
    public native FloatBuffer getV();

    @StructMember(value=0)
    public native GLKVector3 setV(@Array(value={3}) FloatBuffer var1);

    public static GLKVector3 create(float x, float y, float z) {
        float[] v = new float[]{x, y, z};
        return GLKVector3.create(v);
    }

    public static GLKVector3 create(float[] values) {
        return new GLKVector3(FloatBuffer.wrap(values));
    }

    public GLKVector3 negate() {
        float[] v = new float[]{-this.getV().get(0), -this.getV().get(1), -this.getV().get(2)};
        return GLKVector3.create(v);
    }

    public GLKVector3 add(GLKVector3 vectorRight) {
        return GLKVector3.add(this, vectorRight);
    }

    public static GLKVector3 add(GLKVector3 vectorLeft, GLKVector3 vectorRight) {
        float[] vectorLeft_v = new float[3];
        float[] vectorRight_v = new float[3];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        float[] v = new float[]{vectorLeft_v[0] + vectorRight_v[0], vectorLeft_v[1] + vectorRight_v[1], vectorLeft_v[2] + vectorRight_v[2]};
        return GLKVector3.create(v);
    }

    public GLKVector3 subtract(GLKVector3 vectorRight) {
        return GLKVector3.subtract(this, vectorRight);
    }

    public static GLKVector3 subtract(GLKVector3 vectorLeft, GLKVector3 vectorRight) {
        float[] vectorLeft_v = new float[3];
        float[] vectorRight_v = new float[3];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        float[] v = new float[]{vectorLeft_v[0] - vectorRight_v[0], vectorLeft_v[1] - vectorRight_v[1], vectorLeft_v[2] - vectorRight_v[2]};
        return GLKVector3.create(v);
    }

    public GLKVector3 multiply(GLKVector3 vectorRight) {
        return GLKVector3.multiply(this, vectorRight);
    }

    public static GLKVector3 multiply(GLKVector3 vectorLeft, GLKVector3 vectorRight) {
        float[] vectorLeft_v = new float[3];
        float[] vectorRight_v = new float[3];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        float[] v = new float[]{vectorLeft_v[0] * vectorRight_v[0], vectorLeft_v[1] * vectorRight_v[1], vectorLeft_v[2] * vectorRight_v[2]};
        return GLKVector3.create(v);
    }

    public GLKVector3 divide(GLKVector3 vectorRight) {
        return GLKVector3.divide(this, vectorRight);
    }

    public static GLKVector3 divide(GLKVector3 vectorLeft, GLKVector3 vectorRight) {
        float[] vectorLeft_v = new float[3];
        float[] vectorRight_v = new float[3];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        float[] v = new float[]{vectorLeft_v[0] / vectorRight_v[0], vectorLeft_v[1] / vectorRight_v[1], vectorLeft_v[2] / vectorRight_v[2]};
        return GLKVector3.create(v);
    }

    public GLKVector3 addScalar(float value) {
        float[] vectorLeft_v = new float[3];
        this.getV().get(vectorLeft_v);
        float[] v = new float[]{vectorLeft_v[0] + value, vectorLeft_v[1] + value, vectorLeft_v[2] + value};
        return GLKVector3.create(v);
    }

    public GLKVector3 subtractScalar(float value) {
        float[] vectorLeft_v = new float[3];
        this.getV().get(vectorLeft_v);
        float[] v = new float[]{vectorLeft_v[0] - value, vectorLeft_v[1] - value, vectorLeft_v[2] - value};
        return GLKVector3.create(v);
    }

    public GLKVector3 multiplyScalar(float value) {
        float[] vectorLeft_v = new float[3];
        this.getV().get(vectorLeft_v);
        float[] v = new float[]{vectorLeft_v[0] * value, vectorLeft_v[1] * value, vectorLeft_v[2] * value};
        return GLKVector3.create(v);
    }

    public GLKVector3 divideScalar(float value) {
        float[] vectorLeft_v = new float[3];
        this.getV().get(vectorLeft_v);
        float[] v = new float[]{vectorLeft_v[0] / value, vectorLeft_v[1] / value, vectorLeft_v[2] / value};
        return GLKVector3.create(v);
    }

    public GLKVector3 maximum(GLKVector3 vectorRight) {
        return GLKVector3.maximum(this, vectorRight);
    }

    public static GLKVector3 maximum(GLKVector3 vectorLeft, GLKVector3 vectorRight) {
        float[] vectorLeft_v = new float[3];
        float[] vectorRight_v = new float[3];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        GLKVector3 max = (GLKVector3)vectorLeft.copy();
        if (vectorRight_v[0] > vectorLeft_v[0]) {
            max.getV().put(0, vectorRight_v[0]);
        }
        if (vectorRight_v[1] > vectorLeft_v[1]) {
            max.getV().put(1, vectorRight_v[1]);
        }
        if (vectorRight_v[2] > vectorLeft_v[2]) {
            max.getV().put(2, vectorRight_v[2]);
        }
        return max;
    }

    public GLKVector3 minimum(GLKVector3 vectorRight) {
        return GLKVector3.minimum(this, vectorRight);
    }

    public static GLKVector3 minimum(GLKVector3 vectorLeft, GLKVector3 vectorRight) {
        float[] vectorLeft_v = new float[3];
        float[] vectorRight_v = new float[3];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        GLKVector3 min = (GLKVector3)vectorLeft.copy();
        if (vectorRight_v[0] < vectorLeft_v[0]) {
            min.getV().put(0, vectorRight_v[0]);
        }
        if (vectorRight_v[1] < vectorLeft_v[1]) {
            min.getV().put(1, vectorRight_v[1]);
        }
        if (vectorRight_v[2] < vectorLeft_v[2]) {
            min.getV().put(2, vectorRight_v[2]);
        }
        return min;
    }

    public boolean allEqualToVector3(GLKVector3 vectorRight) {
        return GLKVector3.allEqualToVector3(this, vectorRight);
    }

    public static boolean allEqualToVector3(GLKVector3 vectorLeft, GLKVector3 vectorRight) {
        float[] vectorLeft_v = new float[3];
        float[] vectorRight_v = new float[3];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        boolean compare = false;
        if (vectorLeft_v[0] == vectorRight_v[0] && vectorLeft_v[1] == vectorRight_v[1] && vectorLeft_v[2] == vectorRight_v[2]) {
            compare = true;
        }
        return compare;
    }

    public boolean allEqualToScalar(float value) {
        boolean compare = false;
        if (this.getV().get(0) == value && this.getV().get(1) == value && this.getV().get(2) == value) {
            compare = true;
        }
        return compare;
    }

    public boolean allGreaterThanVector3(GLKVector3 vectorRight) {
        return GLKVector3.allGreaterThanVector3(this, vectorRight);
    }

    public static boolean allGreaterThanVector3(GLKVector3 vectorLeft, GLKVector3 vectorRight) {
        float[] vectorLeft_v = new float[3];
        float[] vectorRight_v = new float[3];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        boolean compare = false;
        if (vectorLeft_v[0] > vectorRight_v[0] && vectorLeft_v[1] > vectorRight_v[1] && vectorLeft_v[2] > vectorRight_v[2]) {
            compare = true;
        }
        return compare;
    }

    public boolean allGreaterThanScalar(float value) {
        boolean compare = false;
        if (this.getV().get(0) > value && this.getV().get(1) > value && this.getV().get(2) > value) {
            compare = true;
        }
        return compare;
    }

    public boolean allGreaterThanOrEqualToVector3(GLKVector3 vectorRight) {
        return GLKVector3.allGreaterThanOrEqualToVector3(this, vectorRight);
    }

    public static boolean allGreaterThanOrEqualToVector3(GLKVector3 vectorLeft, GLKVector3 vectorRight) {
        float[] vectorLeft_v = new float[3];
        float[] vectorRight_v = new float[3];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        boolean compare = false;
        if (vectorLeft_v[0] >= vectorRight_v[0] && vectorLeft_v[1] >= vectorRight_v[1] && vectorLeft_v[2] >= vectorRight_v[2]) {
            compare = true;
        }
        return compare;
    }

    public boolean allGreaterThanOrEqualToScalar(float value) {
        boolean compare = false;
        if (this.getV().get(0) >= value && this.getV().get(1) >= value && this.getV().get(2) >= value) {
            compare = true;
        }
        return compare;
    }

    public GLKVector3 normalize() {
        float scale = 1.0f / this.length();
        float[] v = new float[]{this.getV().get(0) * scale, this.getV().get(1) * scale, this.getV().get(2) * scale};
        return GLKVector3.create(v);
    }

    public float dotProduct(GLKVector3 vectorRight) {
        return GLKVector3.dotProduct(this, vectorRight);
    }

    public static float dotProduct(GLKVector3 vectorLeft, GLKVector3 vectorRight) {
        float[] vectorLeft_v = new float[3];
        float[] vectorRight_v = new float[3];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        return vectorLeft_v[0] * vectorRight_v[0] + vectorLeft_v[1] * vectorRight_v[1] + vectorLeft_v[2] * vectorRight_v[2];
    }

    public float length() {
        float[] vector_v = new float[3];
        this.getV().get(vector_v);
        return (float)Math.sqrt(vector_v[0] * vector_v[0] + vector_v[1] * vector_v[1] + vector_v[2] * vector_v[2]);
    }

    public float distance(GLKVector3 vectorEnd) {
        return GLKVector3.distance(this, vectorEnd);
    }

    public static float distance(GLKVector3 vectorStart, GLKVector3 vectorEnd) {
        return GLKVector3.subtract(vectorEnd, vectorStart).length();
    }

    public GLKVector3 lerp(GLKVector3 vectorEnd, float t) {
        return GLKVector3.lerp(this, vectorEnd, t);
    }

    public static GLKVector3 lerp(GLKVector3 vectorStart, GLKVector3 vectorEnd, float t) {
        float[] vectorStart_v = new float[3];
        float[] vectorEnd_v = new float[3];
        vectorStart.getV().get(vectorStart_v);
        vectorEnd.getV().get(vectorEnd_v);
        float[] v = new float[]{vectorStart_v[0] + (vectorEnd_v[0] - vectorStart_v[0]) * t, vectorStart_v[1] + (vectorEnd_v[1] - vectorStart_v[1]) * t, vectorStart_v[2] + (vectorEnd_v[2] - vectorStart_v[2]) * t};
        return GLKVector3.create(v);
    }

    public GLKVector3 crossProduct(GLKVector3 vectorRight) {
        return GLKVector3.crossProduct(this, vectorRight);
    }

    public static GLKVector3 crossProduct(GLKVector3 vectorLeft, GLKVector3 vectorRight) {
        float[] vectorLeft_v = new float[3];
        float[] vectorRight_v = new float[3];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        float[] v = new float[]{vectorLeft_v[1] * vectorRight_v[2] - vectorLeft_v[2] * vectorRight_v[1], vectorLeft_v[2] * vectorRight_v[0] - vectorLeft_v[0] * vectorRight_v[2], vectorLeft_v[0] * vectorRight_v[1] - vectorLeft_v[1] * vectorRight_v[0]};
        return GLKVector3.create(v);
    }

    public GLKVector3 project(GLKVector3 projectionVector) {
        return GLKVector3.project(this, projectionVector);
    }

    public static GLKVector3 project(GLKVector3 vectorToProject, GLKVector3 projectionVector) {
        float scale = GLKVector3.dotProduct(projectionVector, vectorToProject) / GLKVector3.dotProduct(projectionVector, projectionVector);
        GLKVector3 v = projectionVector.multiplyScalar(scale);
        return v;
    }

    static {
        Bro.bind(GLKVector3.class);
    }

    public static class GLKVector3Ptr
    extends Ptr<GLKVector3, GLKVector3Ptr> {
    }
}

