/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.addressbook;

import org.robovm.apple.addressbook.ABPersonAddressPart;
import org.robovm.apple.addressbook.ABPropertyLabel;
import org.robovm.apple.addressbookui.ABAddressFormating;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableDictionary;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="AddressBook")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class ABPersonAddress {
    private CFDictionary data;
    private CFString label;

    public ABPersonAddress(String label) {
        this.data = CFMutableDictionary.create();
        this.label = new CFString(label);
    }

    public ABPersonAddress(ABPropertyLabel label) {
        this.data = CFMutableDictionary.create();
        this.label = label.value();
    }

    protected ABPersonAddress(CFDictionary data, CFString label) {
        this.data = data;
        this.label = label;
    }

    public String getAddressPart(ABPersonAddressPart part) {
        if (this.data.containsKey((NativeObject)part.value())) {
            CFString val = this.data.get((NativeObject)part.value(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public ABPersonAddress setAddressPart(ABPersonAddressPart part, String s) {
        this.data.put((NativeObject)part.value(), new CFString(s));
        return this;
    }

    public String getLabel() {
        return this.label.toString();
    }

    protected CFString getLabel0() {
        return this.label;
    }

    public CFDictionary getDictionary() {
        return this.data;
    }

    public String getStreet() {
        return this.getAddressPart(ABPersonAddressPart.Street);
    }

    public ABPersonAddress setStreet(String s) {
        return this.setAddressPart(ABPersonAddressPart.Street, s);
    }

    public String getCity() {
        return this.getAddressPart(ABPersonAddressPart.City);
    }

    public ABPersonAddress setCity(String s) {
        return this.setAddressPart(ABPersonAddressPart.City, s);
    }

    public String getState() {
        return this.getAddressPart(ABPersonAddressPart.State);
    }

    public ABPersonAddress setState(String s) {
        return this.setAddressPart(ABPersonAddressPart.State, s);
    }

    public String getZIP() {
        return this.getAddressPart(ABPersonAddressPart.ZIP);
    }

    public ABPersonAddress setZIP(String s) {
        return this.setAddressPart(ABPersonAddressPart.ZIP, s);
    }

    public String getCountry() {
        return this.getAddressPart(ABPersonAddressPart.Country);
    }

    public ABPersonAddress setCountry(String s) {
        return this.setAddressPart(ABPersonAddressPart.Country, s);
    }

    public String getCountryCode() {
        return this.getAddressPart(ABPersonAddressPart.CountryCode);
    }

    public ABPersonAddress setCountryCode(String s) {
        return this.setAddressPart(ABPersonAddressPart.CountryCode, s);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean addCountryName) {
        return ABAddressFormating.createString(this.data, addCountryName);
    }

    static {
        Bro.bind(ABPersonAddress.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static ABPersonAddress toObject(Class<ABPersonAddress> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new ABPersonAddress(o, ABPropertyLabel.HomeLabel());
        }

        @MarshalsPointer
        public static long toNative(ABPersonAddress o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

