/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import org.robovm.apple.audiotoolbox.AudioConverterProperty;
import org.robovm.apple.coreaudio.AudioBufferList;
import org.robovm.apple.coreaudio.AudioClassDescription;
import org.robovm.apple.coreaudio.AudioStreamBasicDescription;
import org.robovm.apple.coreaudio.AudioStreamPacketDescription;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.FloatPtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="AudioToolbox")
public class AudioConverter
extends NativeObject {
    protected AudioConverter() {
    }

    public static AudioConverter create(AudioStreamBasicDescription sourceFormat, AudioStreamBasicDescription destinationFormat) throws OSStatusException {
        AudioConverterPtr ptr = new AudioConverterPtr();
        OSStatus status = AudioConverter.create0(sourceFormat, destinationFormat, ptr);
        OSStatusException.throwIfNecessary(status);
        return (AudioConverter)ptr.get();
    }

    public static AudioConverter create(AudioStreamBasicDescription sourceFormat, AudioStreamBasicDescription destinationFormat, AudioClassDescription[] classDescriptions) throws OSStatusException {
        AudioConverterPtr ptr = new AudioConverterPtr();
        AudioClassDescription classes = new AudioClassDescription();
        classes.update(classDescriptions);
        OSStatus status = AudioConverter.create0(sourceFormat, destinationFormat, classDescriptions.length, classes, ptr);
        OSStatusException.throwIfNecessary(status);
        return (AudioConverter)ptr.get();
    }

    public void dispose() throws OSStatusException {
        OSStatus status = this.dispose0();
        OSStatusException.throwIfNecessary(status);
    }

    public void reset() throws OSStatusException {
        OSStatus status = this.reset0();
        OSStatusException.throwIfNecessary(status);
    }

    public int getPropertySize(AudioConverterProperty id) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getPropertyInfo0(id, ptr, null);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public boolean isPropertyWritable(AudioConverterProperty id) throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.getPropertyInfo0(id, null, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public <T extends Struct<T>> T getProperty(AudioConverterProperty id, Class<T> type) throws OSStatusException {
        Struct data = Struct.allocate(type);
        IntPtr dataSize = new IntPtr(Struct.sizeOf((Struct)data));
        OSStatus status = this.getProperty0(id, dataSize, (VoidPtr)data.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
        return (T)data;
    }

    public <T extends Struct<T>> void setProperty(AudioConverterProperty id, T data) throws OSStatusException {
        OSStatus status = this.setProperty0(id, data == null ? 0 : Struct.sizeOf(data), data == null ? null : (VoidPtr)data.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
    }

    public int getPropertyAsInt(AudioConverterProperty id) throws OSStatusException {
        IntPtr ptr = this.getProperty(id, IntPtr.class);
        return ptr.get();
    }

    public long getPropertyAsLong(AudioConverterProperty id) throws OSStatusException {
        LongPtr ptr = this.getProperty(id, LongPtr.class);
        return ptr.get();
    }

    public float getPropertyAsFloat(AudioConverterProperty id) throws OSStatusException {
        FloatPtr ptr = this.getProperty(id, FloatPtr.class);
        return ptr.get();
    }

    public double getPropertyAsDouble(AudioConverterProperty id) throws OSStatusException {
        DoublePtr ptr = this.getProperty(id, DoublePtr.class);
        return ptr.get();
    }

    public void setProperty(AudioConverterProperty id, int value) throws OSStatusException {
        this.setProperty(id, new IntPtr(value));
    }

    public void setProperty(AudioConverterProperty id, long value) throws OSStatusException {
        this.setProperty(id, new LongPtr(value));
    }

    public void setProperty(AudioConverterProperty id, float value) throws OSStatusException {
        this.setProperty(id, new FloatPtr(value));
    }

    public void setProperty(AudioConverterProperty id, double value) throws OSStatusException {
        this.setProperty(id, new DoublePtr(value));
    }

    public byte[] convertBuffer(byte[] buffer) throws OSStatusException {
        BytePtr bytePtr = new BytePtr();
        IntPtr sizePtr = new IntPtr(buffer.length);
        OSStatus status = this.convertBuffer0(buffer.length, VM.getArrayValuesAddress((Object)buffer), sizePtr, bytePtr);
        OSStatusException.throwIfNecessary(status);
        return bytePtr.toByteArray(sizePtr.get());
    }

    public void convertComplexBuffer(int numberPCMFrames, AudioBufferList inputData, AudioBufferList outputData) throws OSStatusException {
        OSStatus status = this.convertComplexBuffer0(numberPCMFrames, inputData, outputData);
        OSStatusException.throwIfNecessary(status);
    }

    @Bridge(symbol="AudioConverterNew", optional=true)
    protected static native OSStatus create0(AudioStreamBasicDescription var0, AudioStreamBasicDescription var1, AudioConverterPtr var2);

    @Bridge(symbol="AudioConverterNewSpecific", optional=true)
    protected static native OSStatus create0(AudioStreamBasicDescription var0, AudioStreamBasicDescription var1, int var2, AudioClassDescription var3, AudioConverterPtr var4);

    @Bridge(symbol="AudioConverterDispose", optional=true)
    protected native OSStatus dispose0();

    @Bridge(symbol="AudioConverterReset", optional=true)
    protected native OSStatus reset0();

    @Bridge(symbol="AudioConverterGetPropertyInfo", optional=true)
    protected native OSStatus getPropertyInfo0(AudioConverterProperty var1, IntPtr var2, BooleanPtr var3);

    @Bridge(symbol="AudioConverterGetProperty", optional=true)
    protected native OSStatus getProperty0(AudioConverterProperty var1, IntPtr var2, VoidPtr var3);

    @Bridge(symbol="AudioConverterSetProperty", optional=true)
    protected native OSStatus setProperty0(AudioConverterProperty var1, int var2, VoidPtr var3);

    @Bridge(symbol="AudioConverterConvertBuffer", optional=true)
    protected native OSStatus convertBuffer0(int var1, @Pointer long var2, IntPtr var4, BytePtr var5);

    @Bridge(symbol="AudioConverterFillComplexBuffer", optional=true)
    protected native OSStatus fillComplexBuffer0(FunctionPtr var1, @Pointer long var2, IntPtr var4, AudioBufferList var5, AudioStreamPacketDescription.AudioStreamPacketDescriptionPtr var6);

    @Bridge(symbol="AudioConverterConvertComplexBuffer", optional=true)
    protected native OSStatus convertComplexBuffer0(int var1, AudioBufferList var2, AudioBufferList var3);

    static {
        Bro.bind(AudioConverter.class);
    }

    public static class AudioConverterPtr
    extends Ptr<AudioConverter, AudioConverterPtr> {
    }
}

