/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.List;
import org.robovm.apple.avfoundation.AVAssetWriterDelegate;
import org.robovm.apple.avfoundation.AVAssetWriterInput;
import org.robovm.apple.avfoundation.AVAssetWriterInputGroup;
import org.robovm.apple.avfoundation.AVAssetWriterStatus;
import org.robovm.apple.avfoundation.AVAudioSettings;
import org.robovm.apple.avfoundation.AVMediaType;
import org.robovm.apple.avfoundation.AVMetadataItem;
import org.robovm.apple.avfoundation.AVPixelBufferAttributes;
import org.robovm.apple.avfoundation.AVVideoSettings;
import org.robovm.apple.coremedia.CMTime;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.uniformtypeid.UTType;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVAssetWriter
extends NSObject {
    protected AVAssetWriter() {
    }

    protected AVAssetWriter(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected AVAssetWriter(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithURL:fileType:error:")
    public AVAssetWriter(NSURL outputURL, String outputFileType) throws NSErrorException {
        super(null);
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long handle = this.init(outputURL, outputFileType, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        this.initObject(handle);
    }

    @Method(selector="initWithContentType:")
    public AVAssetWriter(UTType outputContentType) {
        super(null);
        this.initObject(this.init(outputContentType));
    }

    @Property(selector="outputURL")
    public native NSURL getOutputURL();

    @Property(selector="outputFileType")
    public native String getOutputFileType();

    @Property(selector="availableMediaTypes")
    @Marshaler(value=AVMediaType.AsListMarshaler.class)
    public native List<AVMediaType> getAvailableMediaTypes();

    @Property(selector="status")
    public native AVAssetWriterStatus getStatus();

    @Property(selector="error")
    public native NSError getError();

    @Property(selector="metadata")
    public native NSArray<AVMetadataItem> getMetadata();

    @Property(selector="setMetadata:")
    public native void setMetadata(NSArray<AVMetadataItem> var1);

    @Property(selector="shouldOptimizeForNetworkUse")
    public native boolean shouldOptimizeForNetworkUse();

    @Property(selector="setShouldOptimizeForNetworkUse:")
    public native void setShouldOptimizeForNetworkUse(boolean var1);

    @Property(selector="directoryForTemporaryFiles")
    public native NSURL getDirectoryForTemporaryFiles();

    @Property(selector="setDirectoryForTemporaryFiles:")
    public native void setDirectoryForTemporaryFiles(NSURL var1);

    @Property(selector="inputs")
    public native NSArray<AVAssetWriterInput> getInputs();

    @Property(selector="movieFragmentInterval")
    @ByVal
    public native CMTime getMovieFragmentInterval();

    @Property(selector="setMovieFragmentInterval:")
    public native void setMovieFragmentInterval(@ByVal CMTime var1);

    @Property(selector="initialMovieFragmentSequenceNumber")
    @MachineSizedSInt
    public native long getInitialMovieFragmentSequenceNumber();

    @Property(selector="setInitialMovieFragmentSequenceNumber:")
    public native void setInitialMovieFragmentSequenceNumber(@MachineSizedSInt long var1);

    @Property(selector="producesCombinableFragments")
    public native boolean isProducesCombinableFragments();

    @Property(selector="setProducesCombinableFragments:")
    public native void setProducesCombinableFragments(boolean var1);

    @Property(selector="overallDurationHint")
    @ByVal
    public native CMTime getOverallDurationHint();

    @Property(selector="setOverallDurationHint:")
    public native void setOverallDurationHint(@ByVal CMTime var1);

    @Property(selector="movieTimeScale")
    public native int getMovieTimeScale();

    @Property(selector="setMovieTimeScale:")
    public native void setMovieTimeScale(int var1);

    @Property(selector="inputGroups")
    public native NSArray<AVAssetWriterInputGroup> getInputGroups();

    @Property(selector="preferredOutputSegmentInterval")
    @ByVal
    public native CMTime getPreferredOutputSegmentInterval();

    @Property(selector="setPreferredOutputSegmentInterval:")
    public native void setPreferredOutputSegmentInterval(@ByVal CMTime var1);

    @Property(selector="initialSegmentStartTime")
    @ByVal
    public native CMTime getInitialSegmentStartTime();

    @Property(selector="setInitialSegmentStartTime:")
    public native void setInitialSegmentStartTime(@ByVal CMTime var1);

    @Property(selector="outputFileTypeProfile")
    public native String getOutputFileTypeProfile();

    @Property(selector="setOutputFileTypeProfile:")
    public native void setOutputFileTypeProfile(String var1);

    @Property(selector="delegate")
    public native AVAssetWriterDelegate getDelegate();

    @Property(selector="setDelegate:", strongRef=true)
    public native void setDelegate(AVAssetWriterDelegate var1);

    public boolean canApplyOutputSettings(AVAudioSettings outputSettings, AVMediaType mediaType) {
        return this.canApplyOutputSettings(outputSettings.getDictionary(), mediaType);
    }

    public boolean canApplyOutputSettings(AVVideoSettings outputSettings, AVMediaType mediaType) {
        return this.canApplyOutputSettings(outputSettings.getDictionary(), mediaType);
    }

    public boolean canApplyOutputSettings(AVPixelBufferAttributes outputSettings, AVMediaType mediaType) {
        return this.canApplyOutputSettings((NSDictionary)outputSettings.getDictionary().as(NSDictionary.class), mediaType);
    }

    @Method(selector="initWithURL:fileType:error:")
    @Pointer
    private native long init(NSURL var1, String var2, NSError.NSErrorPtr var3);

    @Method(selector="initWithContentType:")
    @Pointer
    protected native long init(UTType var1);

    @Method(selector="canApplyOutputSettings:forMediaType:")
    protected native boolean canApplyOutputSettings(NSDictionary<NSString, ?> var1, AVMediaType var2);

    @Method(selector="canAddInput:")
    public native boolean canAddInput(AVAssetWriterInput var1);

    @Method(selector="addInput:")
    public native void addInput(AVAssetWriterInput var1);

    @Method(selector="startWriting")
    public native boolean startWriting();

    @Method(selector="startSessionAtSourceTime:")
    public native void startSession(@ByVal CMTime var1);

    @Method(selector="endSessionAtSourceTime:")
    public native void endSession(@ByVal CMTime var1);

    @Method(selector="cancelWriting")
    public native void cancelWriting();

    @Method(selector="finishWritingWithCompletionHandler:")
    public native void finishWriting(@Block Runnable var1);

    @Method(selector="canAddInputGroup:")
    public native boolean canAddInputGroup(AVAssetWriterInputGroup var1);

    @Method(selector="addInputGroup:")
    public native void addInputGroup(AVAssetWriterInputGroup var1);

    @Method(selector="flushSegment")
    public native void flushSegment();

    static {
        ObjCRuntime.bind(AVAssetWriter.class);
    }

    public static class AVAssetWriterPtr
    extends Ptr<AVAssetWriter, AVAssetWriterPtr> {
    }
}

