/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.avfoundation.AVAudioBitRateStrategy;
import org.robovm.apple.avfoundation.AVAudioQuality;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="AVFoundation")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class AVAudioEncoderSettings
extends NSDictionaryWrapper {
    AVAudioEncoderSettings(NSDictionary data) {
        super(data);
    }

    public AVAudioEncoderSettings() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public AVAudioEncoderSettings set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public AVAudioQuality getAudioQuality() {
        if (this.has(Keys.AudioQuality())) {
            NSNumber val = (NSNumber)this.get(Keys.AudioQuality());
            return AVAudioQuality.valueOf(val.longValue());
        }
        return null;
    }

    public AVAudioEncoderSettings setAudioQuality(AVAudioQuality audioQuality) {
        this.set(Keys.AudioQuality(), NSNumber.valueOf(audioQuality.value()));
        return this;
    }

    public AVAudioQuality getAudioQualityForVBR() {
        if (this.has(Keys.AudioQualityForVBR())) {
            NSNumber val = (NSNumber)this.get(Keys.AudioQualityForVBR());
            return AVAudioQuality.valueOf(val.longValue());
        }
        return null;
    }

    public AVAudioEncoderSettings setAudioQualityForVBR(AVAudioQuality audioQualityForVBR) {
        this.set(Keys.AudioQualityForVBR(), NSNumber.valueOf(audioQualityForVBR.value()));
        return this;
    }

    public int getBitRate() {
        if (this.has(Keys.BitRate())) {
            NSNumber val = (NSNumber)this.get(Keys.BitRate());
            return val.intValue();
        }
        return 0;
    }

    public AVAudioEncoderSettings setBitRate(int bitRate) {
        this.set(Keys.BitRate(), NSNumber.valueOf(bitRate));
        return this;
    }

    public int getBitRatePerChannel() {
        if (this.has(Keys.BitRatePerChannel())) {
            NSNumber val = (NSNumber)this.get(Keys.BitRatePerChannel());
            return val.intValue();
        }
        return 0;
    }

    public AVAudioEncoderSettings setBitRatePerChannel(int bitRatePerChannel) {
        this.set(Keys.BitRatePerChannel(), NSNumber.valueOf(bitRatePerChannel));
        return this;
    }

    public AVAudioBitRateStrategy getBitRateStrategy() {
        if (this.has(Keys.BitRateStrategy())) {
            NSString val = (NSString)this.get(Keys.BitRateStrategy());
            return AVAudioBitRateStrategy.valueOf(val);
        }
        return null;
    }

    public AVAudioEncoderSettings setBitRateStrategy(AVAudioBitRateStrategy bitRateStrategy) {
        this.set(Keys.BitRateStrategy(), (NSObject)bitRateStrategy.value());
        return this;
    }

    public int getBitDepthHint() {
        if (this.has(Keys.BitDepthHint())) {
            NSNumber val = (NSNumber)this.get(Keys.BitDepthHint());
            return val.intValue();
        }
        return 0;
    }

    public AVAudioEncoderSettings setBitDepthHint(int bitDepthHint) {
        this.set(Keys.BitDepthHint(), NSNumber.valueOf(bitDepthHint));
        return this;
    }

    @Library(value="AVFoundation")
    public static class Keys {
        @GlobalValue(symbol="AVEncoderAudioQualityKey", optional=true)
        public static native NSString AudioQuality();

        @GlobalValue(symbol="AVEncoderAudioQualityForVBRKey", optional=true)
        public static native NSString AudioQualityForVBR();

        @GlobalValue(symbol="AVEncoderBitRateKey", optional=true)
        public static native NSString BitRate();

        @GlobalValue(symbol="AVEncoderBitRatePerChannelKey", optional=true)
        public static native NSString BitRatePerChannel();

        @GlobalValue(symbol="AVEncoderBitRateStrategyKey", optional=true)
        public static native NSString BitRateStrategy();

        @GlobalValue(symbol="AVEncoderBitDepthHintKey", optional=true)
        public static native NSString BitDepthHint();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<AVAudioEncoderSettings> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<AVAudioEncoderSettings> list = new ArrayList<AVAudioEncoderSettings>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new AVAudioEncoderSettings((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<AVAudioEncoderSettings> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (AVAudioEncoderSettings i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVAudioEncoderSettings toObject(Class<AVAudioEncoderSettings> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new AVAudioEncoderSettings(o);
        }

        @MarshalsPointer
        public static long toNative(AVAudioEncoderSettings o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

