/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.avfoundation.AVAudioEncoderSettings;
import org.robovm.apple.avfoundation.AVSampleRateConverterSettings;
import org.robovm.apple.coreaudio.AudioChannelLayout;
import org.robovm.apple.coreaudio.AudioFormat;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="AVFoundation")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class AVAudioSettings
extends NSDictionaryWrapper {
    private AVAudioEncoderSettings encoderSettings;
    private AVSampleRateConverterSettings sampleRateConverterSettings;

    AVAudioSettings(NSDictionary data) {
        super(data);
    }

    public AVAudioSettings() {
    }

    public AVAudioEncoderSettings getEncoderSettings() {
        if (this.encoderSettings == null) {
            this.encoderSettings = new AVAudioEncoderSettings(this.data);
        }
        return this.encoderSettings;
    }

    public AVAudioSettings setEncoderSettings(AVAudioEncoderSettings settings) {
        if (settings == null) {
            throw new NullPointerException("settings");
        }
        this.encoderSettings = settings;
        this.data.putAll(settings.getDictionary());
        return this;
    }

    public AVSampleRateConverterSettings getSampleRateConverterSettings() {
        if (this.sampleRateConverterSettings == null) {
            this.sampleRateConverterSettings = new AVSampleRateConverterSettings(this.data);
        }
        return this.sampleRateConverterSettings;
    }

    public AVAudioSettings setSampleRateConverterSettings(AVSampleRateConverterSettings settings) {
        if (settings == null) {
            throw new NullPointerException("settings");
        }
        this.sampleRateConverterSettings = settings;
        this.data.putAll(settings.getDictionary());
        return this;
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public AVAudioSettings set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    @WeaklyLinked
    public AudioFormat getFormat() {
        if (this.has(Keys.FormatID())) {
            NSNumber val = (NSNumber)this.get(Keys.FormatID());
            return AudioFormat.valueOf(val.longValue());
        }
        return null;
    }

    @WeaklyLinked
    public AVAudioSettings setFormat(AudioFormat format) {
        this.set(Keys.FormatID(), NSNumber.valueOf(format.value()));
        return this;
    }

    public double getSampleRate() {
        if (this.has(Keys.SampleRate())) {
            NSNumber val = (NSNumber)this.get(Keys.SampleRate());
            return val.doubleValue();
        }
        return 0.0;
    }

    public AVAudioSettings setSampleRate(double sampleRate) {
        this.set(Keys.SampleRate(), NSNumber.valueOf(sampleRate));
        return this;
    }

    public int getNumberOfChannels() {
        if (this.has(Keys.NumberOfChannels())) {
            NSNumber val = (NSNumber)this.get(Keys.NumberOfChannels());
            return val.intValue();
        }
        return 0;
    }

    public AVAudioSettings setNumberOfChannels(int numberOfChannels) {
        this.set(Keys.NumberOfChannels(), NSNumber.valueOf(numberOfChannels));
        return this;
    }

    public boolean isLinearPCMNonInterleaved() {
        if (this.has(Keys.IsNonInterleaved())) {
            NSNumber val = (NSNumber)this.get(Keys.IsNonInterleaved());
            return val.booleanValue();
        }
        return false;
    }

    public AVAudioSettings setLinearPCMNonInterleaved(boolean linearPCMNonInterleaved) {
        this.set(Keys.IsNonInterleaved(), NSNumber.valueOf(linearPCMNonInterleaved));
        return this;
    }

    @WeaklyLinked
    public AudioChannelLayout getChannelLayout() {
        if (this.has(Keys.ChannelLayout())) {
            NSData val = (NSData)this.get(Keys.ChannelLayout());
            return val.getStructData(AudioChannelLayout.class);
        }
        return null;
    }

    @WeaklyLinked
    public AVAudioSettings setChannelLayout(AudioChannelLayout channelLayout) {
        this.set(Keys.ChannelLayout(), new NSData(channelLayout));
        return this;
    }

    @Library(value="AVFoundation")
    public static class Keys {
        @GlobalValue(symbol="AVFormatIDKey", optional=true)
        public static native NSString FormatID();

        @GlobalValue(symbol="AVSampleRateKey", optional=true)
        public static native NSString SampleRate();

        @GlobalValue(symbol="AVNumberOfChannelsKey", optional=true)
        public static native NSString NumberOfChannels();

        @GlobalValue(symbol="AVLinearPCMBitDepthKey", optional=true)
        public static native NSString BitDepthKey();

        @GlobalValue(symbol="AVLinearPCMIsBigEndianKey", optional=true)
        public static native NSString IsBigEndianKey();

        @GlobalValue(symbol="AVLinearPCMIsFloatKey", optional=true)
        public static native NSString IsFloatKey();

        @GlobalValue(symbol="AVLinearPCMIsNonInterleaved", optional=true)
        public static native NSString IsNonInterleaved();

        @GlobalValue(symbol="AVChannelLayoutKey", optional=true)
        public static native NSString ChannelLayout();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<AVAudioSettings> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<AVAudioSettings> list = new ArrayList<AVAudioSettings>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new AVAudioSettings((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<AVAudioSettings> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (AVAudioSettings i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVAudioSettings toObject(Class<AVAudioSettings> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new AVAudioSettings(o);
        }

        @MarshalsPointer
        public static long toNative(AVAudioSettings o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

