/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.avfoundation.AVPixelAspectRatio;
import org.robovm.apple.avfoundation.AVVideoCleanAperture;
import org.robovm.apple.avfoundation.AVVideoCodecType;
import org.robovm.apple.avfoundation.AVVideoH264EntropyMode;
import org.robovm.apple.avfoundation.AVVideoProfileLevel;
import org.robovm.apple.avfoundation.AVVideoScalingMode;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="AVFoundation")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class AVVideoSettings
extends NSDictionaryWrapper {
    AVVideoSettings(NSDictionary data) {
        super(data);
    }

    public AVVideoSettings() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public AVVideoSettings set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public AVVideoCodecType getCodec() {
        if (this.has(Keys.Codec())) {
            NSString val = (NSString)this.get(Keys.Codec());
            return AVVideoCodecType.valueOf(val);
        }
        return null;
    }

    public AVVideoSettings setCodec(AVVideoCodecType codec) {
        this.set(Keys.Codec(), (NSObject)codec.value());
        return this;
    }

    public long getWidth() {
        if (this.has(Keys.Width())) {
            NSNumber val = (NSNumber)this.get(Keys.Width());
            return val.longValue();
        }
        return 0L;
    }

    public AVVideoSettings setWidth(long width) {
        this.set(Keys.Width(), NSNumber.valueOf(width));
        return this;
    }

    public long getHeight() {
        if (this.has(Keys.Height())) {
            NSNumber val = (NSNumber)this.get(Keys.Height());
            return val.longValue();
        }
        return 0L;
    }

    public AVVideoSettings setHeight(long height) {
        this.set(Keys.Height(), NSNumber.valueOf(height));
        return this;
    }

    public AVVideoCleanAperture getCleanAperture() {
        if (this.has(Keys.CleanAperture())) {
            NSDictionary val = (NSDictionary)this.get(Keys.CleanAperture());
            return new AVVideoCleanAperture(val);
        }
        return null;
    }

    public AVVideoSettings setCleanAperture(AVVideoCleanAperture cleanAperture) {
        this.set(Keys.CleanAperture(), cleanAperture.getDictionary());
        return this;
    }

    public AVVideoScalingMode getScalingMode() {
        if (this.has(Keys.ScalingMode())) {
            NSString val = (NSString)this.get(Keys.ScalingMode());
            return AVVideoScalingMode.valueOf(val);
        }
        return null;
    }

    public AVVideoSettings setScalingMode(AVVideoScalingMode scalingMode) {
        this.set(Keys.ScalingMode(), (NSObject)scalingMode.value());
        return this;
    }

    public boolean allowsFrameReordering() {
        if (this.has(Keys.AllowFrameReordering())) {
            NSNumber val = (NSNumber)this.get(Keys.AllowFrameReordering());
            return val.booleanValue();
        }
        return false;
    }

    public AVVideoSettings setAllowsFrameReordering(boolean allowsFrameReordering) {
        this.set(Keys.AllowFrameReordering(), NSNumber.valueOf(allowsFrameReordering));
        return this;
    }

    public AVVideoProfileLevel getProfileLevel() {
        if (this.has(Keys.ProfileLevel())) {
            NSString val = (NSString)this.get(Keys.ProfileLevel());
            return AVVideoProfileLevel.valueOf(val);
        }
        return null;
    }

    public AVVideoSettings setProfileLevel(AVVideoProfileLevel profileLevel) {
        this.set(Keys.ProfileLevel(), (NSObject)profileLevel.value());
        return this;
    }

    public AVVideoH264EntropyMode getH264EntropyMode() {
        if (this.has(Keys.H264EntropyMode())) {
            NSString val = (NSString)this.get(Keys.H264EntropyMode());
            return AVVideoH264EntropyMode.valueOf(val);
        }
        return null;
    }

    public AVVideoSettings setH264EntropyMode(AVVideoH264EntropyMode h264EntropyMode) {
        this.set(Keys.H264EntropyMode(), (NSObject)h264EntropyMode.value());
        return this;
    }

    public double getExpectedSourceFrameRate() {
        if (this.has(Keys.ExpectedSourceFrameRate())) {
            NSNumber val = (NSNumber)this.get(Keys.ExpectedSourceFrameRate());
            return val.doubleValue();
        }
        return 0.0;
    }

    public AVVideoSettings setExpectedSourceFrameRate(double expectedSourceFrameRate) {
        this.set(Keys.ExpectedSourceFrameRate(), NSNumber.valueOf(expectedSourceFrameRate));
        return this;
    }

    public double getAverageNonDroppableFrameRate() {
        if (this.has(Keys.AverageNonDroppableFrameRate())) {
            NSNumber val = (NSNumber)this.get(Keys.AverageNonDroppableFrameRate());
            return val.doubleValue();
        }
        return 0.0;
    }

    public AVVideoSettings setAverageNonDroppableFrameRate(double averageNonDroppableFrameRate) {
        this.set(Keys.AverageNonDroppableFrameRate(), NSNumber.valueOf(averageNonDroppableFrameRate));
        return this;
    }

    public AVPixelAspectRatio getPixelAspectRatio() {
        if (this.has(Keys.PixelAspectRatio())) {
            NSDictionary val = (NSDictionary)this.get(Keys.PixelAspectRatio());
            AVPixelAspectRatio result = new AVPixelAspectRatio(val.getLong(AVPixelAspectRatio.HorizontalSpacing(), 0L), val.getLong(AVPixelAspectRatio.VerticalSpacing(), 0L));
            return result;
        }
        return null;
    }

    public AVVideoSettings setPixelAspectRatio(AVPixelAspectRatio pixelAspectRatio) {
        NSMutableDictionary val = new NSMutableDictionary();
        ((NSDictionary)val).put((Object)AVPixelAspectRatio.HorizontalSpacing(), pixelAspectRatio.getHorizontalSpacing());
        ((NSDictionary)val).put((Object)AVPixelAspectRatio.VerticalSpacing(), pixelAspectRatio.getVerticalSpacing());
        this.set(Keys.PixelAspectRatio(), val);
        return this;
    }

    @Library(value="AVFoundation")
    public static class Keys {
        @GlobalValue(symbol="AVVideoCodecKey", optional=true)
        public static native NSString Codec();

        @GlobalValue(symbol="AVVideoWidthKey", optional=true)
        public static native NSString Width();

        @GlobalValue(symbol="AVVideoHeightKey", optional=true)
        public static native NSString Height();

        @GlobalValue(symbol="AVVideoPixelAspectRatioKey", optional=true)
        public static native NSString PixelAspectRatio();

        @GlobalValue(symbol="AVVideoCleanApertureKey", optional=true)
        public static native NSString CleanAperture();

        @GlobalValue(symbol="AVVideoScalingModeKey", optional=true)
        public static native NSString ScalingMode();

        @GlobalValue(symbol="AVVideoColorPropertiesKey", optional=true)
        public static native NSString ColorProperties();

        @GlobalValue(symbol="AVVideoColorPrimariesKey", optional=true)
        public static native NSString ColorPrimaries();

        @GlobalValue(symbol="AVVideoTransferFunctionKey", optional=true)
        public static native NSString TransferFunction();

        @GlobalValue(symbol="AVVideoYCbCrMatrixKey", optional=true)
        public static native NSString YCbCrMatrix();

        @GlobalValue(symbol="AVVideoAllowWideColorKey", optional=true)
        public static native NSString AllowWideColor();

        @GlobalValue(symbol="AVVideoCompressionPropertiesKey", optional=true)
        public static native NSString CompressionProperties();

        @GlobalValue(symbol="AVVideoAppleProRAWBitDepthKey", optional=true)
        public static native NSString AppleProRAWBitDepth();

        @GlobalValue(symbol="AVVideoAllowFrameReorderingKey", optional=true)
        public static native NSString AllowFrameReordering();

        @GlobalValue(symbol="AVVideoProfileLevelKey", optional=true)
        public static native NSString ProfileLevel();

        @GlobalValue(symbol="AVVideoH264EntropyModeKey", optional=true)
        public static native NSString H264EntropyMode();

        @GlobalValue(symbol="AVVideoExpectedSourceFrameRateKey", optional=true)
        public static native NSString ExpectedSourceFrameRate();

        @GlobalValue(symbol="AVVideoAverageNonDroppableFrameRateKey", optional=true)
        public static native NSString AverageNonDroppableFrameRate();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<AVVideoSettings> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<AVVideoSettings> list = new ArrayList<AVVideoSettings>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new AVVideoSettings((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<AVVideoSettings> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (AVVideoSettings i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVVideoSettings toObject(Class<AVVideoSettings> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new AVVideoSettings(o);
        }

        @MarshalsPointer
        public static long toNative(AVVideoSettings o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

