/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.classkit;

import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorCode;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.ValuedEnum;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;

@Marshaler(value=ValuedEnum.AsMachineSizedSIntMarshaler.class)
@Library(value="ClassKit")
public enum CLSErrorCode implements NSErrorCode
{
    None(0L),
    ClassKitUnavailable(1L),
    InvalidArgument(2L),
    InvalidModification(3L),
    AuthorizationDenied(4L),
    DatabaseInaccessible(5L),
    Limits(6L),
    InvalidCreate(7L),
    InvalidUpdate(8L),
    PartialFailure(9L);

    private final long n;

    @GlobalValue(symbol="CLSErrorCodeDomain", optional=true)
    public static native String getClassDomain();

    @GlobalValue(symbol="CLSErrorObjectKey", optional=true)
    public static native String getObjecKey();

    @GlobalValue(symbol="CLSErrorUnderlyingErrorsKey", optional=true)
    public static native String getUnderlyingErrorsKey();

    private CLSErrorCode(long n2) {
        this.n = n2;
    }

    public long value() {
        return this.n;
    }

    public static CLSErrorCode valueOf(long n) {
        for (CLSErrorCode v : CLSErrorCode.values()) {
            if (v.n != n) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " + CLSErrorCode.class.getName());
    }

    static {
        Bro.bind(CLSErrorCode.class);
        Bro.bind(NSErrorWrap.class);
    }

    @StronglyLinked
    public static class NSErrorWrap
    extends NSError {
        protected NSErrorWrap(NSObject.SkipInit skipInit) {
            super(skipInit);
        }

        @Override
        public NSErrorCode getErrorCode() {
            try {
                return CLSErrorCode.valueOf(this.getCode());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static String getClassDomain() {
            return CLSErrorCode.getClassDomain();
        }
    }
}

