/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corebluetooth;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corebluetooth.CBUUID;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreBluetooth")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CBAdvertisementData
extends NSDictionaryWrapper {
    CBAdvertisementData(NSDictionary data) {
        super(data);
    }

    public CBAdvertisementData() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public CBAdvertisementData set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public String getLocalName() {
        if (this.has(Keys.LocalName())) {
            NSString val = (NSString)this.get(Keys.LocalName());
            return val.toString();
        }
        return null;
    }

    public CBAdvertisementData setLocalName(String localName) {
        this.set(Keys.LocalName(), new NSString(localName));
        return this;
    }

    public double getTxPowerLevel() {
        if (this.has(Keys.TxPowerLevel())) {
            NSNumber val = (NSNumber)this.get(Keys.TxPowerLevel());
            return val.doubleValue();
        }
        return 0.0;
    }

    public CBAdvertisementData setTxPowerLevel(double txPowerLevel) {
        this.set(Keys.TxPowerLevel(), NSNumber.valueOf(txPowerLevel));
        return this;
    }

    public NSArray getServiceUUIDs() {
        if (this.has(Keys.ServiceUUIDs())) {
            NSArray val = (NSArray)this.get(Keys.ServiceUUIDs());
            return val;
        }
        return null;
    }

    public CBAdvertisementData setServiceUUIDs(NSArray serviceUUIDs) {
        this.set(Keys.ServiceUUIDs(), serviceUUIDs);
        return this;
    }

    public NSData getManufacturerData() {
        if (this.has(Keys.ManufacturerData())) {
            NSData val = (NSData)this.get(Keys.ManufacturerData());
            return val;
        }
        return null;
    }

    public CBAdvertisementData setManufacturerData(NSData manufacturerData) {
        this.set(Keys.ManufacturerData(), manufacturerData);
        return this;
    }

    public NSArray<CBUUID> getOverflowServiceUUIDs() {
        if (this.has(Keys.OverflowServiceUUIDs())) {
            NSArray val = (NSArray)this.get(Keys.OverflowServiceUUIDs());
            return val;
        }
        return null;
    }

    public CBAdvertisementData setOverflowServiceUUIDs(NSArray<CBUUID> overflowServiceUUIDs) {
        this.set(Keys.OverflowServiceUUIDs(), overflowServiceUUIDs);
        return this;
    }

    public boolean isConnectable() {
        if (this.has(Keys.IsConnectable())) {
            NSNumber val = (NSNumber)this.get(Keys.IsConnectable());
            return val.booleanValue();
        }
        return false;
    }

    public CBAdvertisementData setIsConnectable(boolean isConnectable) {
        this.set(Keys.IsConnectable(), NSNumber.valueOf(isConnectable));
        return this;
    }

    public NSArray<CBUUID> getSolicitedServiceUUIDs() {
        if (this.has(Keys.SolicitedServiceUUIDs())) {
            NSArray val = (NSArray)this.get(Keys.SolicitedServiceUUIDs());
            return val;
        }
        return null;
    }

    public CBAdvertisementData setSolicitedServiceUUIDs(NSArray<CBUUID> solicitedServiceUUIDs) {
        this.set(Keys.SolicitedServiceUUIDs(), solicitedServiceUUIDs);
        return this;
    }

    @Library(value="CoreBluetooth")
    public static class Keys {
        @GlobalValue(symbol="CBAdvertisementDataLocalNameKey", optional=true)
        public static native NSString LocalName();

        @GlobalValue(symbol="CBAdvertisementDataTxPowerLevelKey", optional=true)
        public static native NSString TxPowerLevel();

        @GlobalValue(symbol="CBAdvertisementDataServiceUUIDsKey", optional=true)
        public static native NSString ServiceUUIDs();

        @GlobalValue(symbol="CBAdvertisementDataServiceDataKey", optional=true)
        public static native NSString ServiceData();

        @GlobalValue(symbol="CBAdvertisementDataManufacturerDataKey", optional=true)
        public static native NSString ManufacturerData();

        @GlobalValue(symbol="CBAdvertisementDataOverflowServiceUUIDsKey", optional=true)
        public static native NSString OverflowServiceUUIDs();

        @GlobalValue(symbol="CBAdvertisementDataIsConnectable", optional=true)
        public static native NSString IsConnectable();

        @GlobalValue(symbol="CBAdvertisementDataSolicitedServiceUUIDsKey", optional=true)
        public static native NSString SolicitedServiceUUIDs();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CBAdvertisementData> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CBAdvertisementData> list = new ArrayList<CBAdvertisementData>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new CBAdvertisementData((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CBAdvertisementData> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (CBAdvertisementData i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CBAdvertisementData toObject(Class<CBAdvertisementData> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CBAdvertisementData(o);
        }

        @MarshalsPointer
        public static long toNative(CBAdvertisementData o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

