/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coredata;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.coredata.NSManagedObject;
import org.robovm.apple.coredata.NSManagedObjectID;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreData")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class NSManagedObjectContextNotification
extends NSDictionaryWrapper {
    NSManagedObjectContextNotification(NSDictionary data) {
        super(data);
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public NSSet<NSManagedObject> getInsertedObjects() {
        if (this.has(Keys.InsertedObjects())) {
            NSSet val = (NSSet)this.get(Keys.InsertedObjects());
            return val;
        }
        return null;
    }

    public NSSet<NSManagedObject> getUpdatedObjects() {
        if (this.has(Keys.UpdatedObjects())) {
            NSSet val = (NSSet)this.get(Keys.UpdatedObjects());
            return val;
        }
        return null;
    }

    public NSSet<NSManagedObject> getDeletedObjects() {
        if (this.has(Keys.DeletedObjects())) {
            NSSet val = (NSSet)this.get(Keys.DeletedObjects());
            return val;
        }
        return null;
    }

    public NSSet<NSManagedObject> getRefreshedObjects() {
        if (this.has(Keys.RefreshedObjects())) {
            NSSet val = (NSSet)this.get(Keys.RefreshedObjects());
            return val;
        }
        return null;
    }

    public NSSet<NSManagedObject> getInvalidatedObjects() {
        if (this.has(Keys.InvalidatedObjects())) {
            NSSet val = (NSSet)this.get(Keys.InvalidatedObjects());
            return val;
        }
        return null;
    }

    public NSArray<NSManagedObjectID> getAllInvalidatedObjects() {
        if (this.has(Keys.InvalidatedAllObjects())) {
            NSArray val = (NSArray)this.get(Keys.InvalidatedAllObjects());
            return val;
        }
        return null;
    }

    @Library(value="CoreData")
    public static class Keys {
        @GlobalValue(symbol="NSInsertedObjectsKey", optional=true)
        public static native NSString InsertedObjects();

        @GlobalValue(symbol="NSUpdatedObjectsKey", optional=true)
        public static native NSString UpdatedObjects();

        @GlobalValue(symbol="NSDeletedObjectsKey", optional=true)
        public static native NSString DeletedObjects();

        @GlobalValue(symbol="NSRefreshedObjectsKey", optional=true)
        public static native NSString RefreshedObjects();

        @GlobalValue(symbol="NSInvalidatedObjectsKey", optional=true)
        public static native NSString InvalidatedObjects();

        @GlobalValue(symbol="NSInvalidatedAllObjectsKey", optional=true)
        public static native NSString InvalidatedAllObjects();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<NSManagedObjectContextNotification> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<NSManagedObjectContextNotification> list = new ArrayList<NSManagedObjectContextNotification>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new NSManagedObjectContextNotification((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<NSManagedObjectContextNotification> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (NSManagedObjectContextNotification i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSManagedObjectContextNotification toObject(Class<NSManagedObjectContextNotification> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSManagedObjectContextNotification(o);
        }

        @MarshalsPointer
        public static long toNative(NSManagedObjectContextNotification o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

