/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coredata;

import org.robovm.apple.coredata.NSCoreDataCoreSpotlightDelegate;
import org.robovm.apple.coredata.NSMigrationManager;
import org.robovm.apple.coredata.NSPersistentStoreCoordinator;
import org.robovm.apple.coredata.NSPersistentStoreMetadata;
import org.robovm.apple.coredata.NSPersistentStoreOptions;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreData")
@NativeClass
public class NSPersistentStore
extends NSObject {
    protected NSPersistentStore() {
    }

    protected NSPersistentStore(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSPersistentStore(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithPersistentStoreCoordinator:configurationName:URL:options:")
    public NSPersistentStore(NSPersistentStoreCoordinator root, String name, NSURL url, NSPersistentStoreOptions options) {
        super(null);
        this.initObject(this.init(root, name, url, options));
    }

    @Property(selector="persistentStoreCoordinator")
    public native NSPersistentStoreCoordinator getPersistentStoreCoordinator();

    @Property(selector="configurationName")
    public native String getConfigurationName();

    @Property(selector="options")
    public native NSPersistentStoreOptions getOptions();

    @Property(selector="URL")
    public native NSURL getURL();

    @Property(selector="setURL:")
    public native void setURL(NSURL var1);

    @Property(selector="identifier")
    public native String getIdentifier();

    @Property(selector="setIdentifier:")
    public native void setIdentifier(String var1);

    @Property(selector="type")
    public native String getType();

    @Property(selector="isReadOnly")
    public native boolean isReadOnly();

    @Property(selector="setReadOnly:")
    public native void setReadOnly(boolean var1);

    @Property(selector="metadata")
    public native NSPersistentStoreMetadata getMetadata();

    @Property(selector="setMetadata:")
    public native void setMetadata(NSPersistentStoreMetadata var1);

    @Property(selector="coreSpotlightExporter")
    public native NSCoreDataCoreSpotlightDelegate getCoreSpotlightExporter();

    @Method(selector="initWithPersistentStoreCoordinator:configurationName:URL:options:")
    @Pointer
    protected native long init(NSPersistentStoreCoordinator var1, String var2, NSURL var3, NSPersistentStoreOptions var4);

    public boolean loadMetadata() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.loadMetadata(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="loadMetadata:")
    private native boolean loadMetadata(NSError.NSErrorPtr var1);

    @Method(selector="didAddToPersistentStoreCoordinator:")
    public native void didAddToPersistentStoreCoordinator(NSPersistentStoreCoordinator var1);

    @Method(selector="willRemoveFromPersistentStoreCoordinator:")
    public native void willRemoveFromPersistentStoreCoordinator(NSPersistentStoreCoordinator var1);

    public static NSPersistentStoreMetadata getMetadataForPersistentStore(NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSPersistentStoreMetadata result = NSPersistentStore.getMetadataForPersistentStore(url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="metadataForPersistentStoreWithURL:error:")
    private static native NSPersistentStoreMetadata getMetadataForPersistentStore(NSURL var0, NSError.NSErrorPtr var1);

    public static boolean setMetadataForPersistentStore(NSPersistentStoreMetadata metadata, NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = NSPersistentStore.setMetadataForPersistentStore(metadata, url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setMetadata:forPersistentStoreWithURL:error:")
    private static native boolean setMetadataForPersistentStore(NSPersistentStoreMetadata var0, NSURL var1, NSError.NSErrorPtr var2);

    @Method(selector="migrationManagerClass")
    public static native Class<? extends NSMigrationManager> getMigrationManagerClass();

    static {
        ObjCRuntime.bind(NSPersistentStore.class);
    }

    public static class NSPersistentStorePtr
    extends Ptr<NSPersistentStore, NSPersistentStorePtr> {
    }
}

