/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.GlobalValueEnumeration;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreFoundation")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@StronglyLinked
public class CFCalendarIdentifier
extends GlobalValueEnumeration<CFString> {
    public static final CFCalendarIdentifier Gregorian;
    public static final CFCalendarIdentifier Buddhist;
    public static final CFCalendarIdentifier Chinese;
    public static final CFCalendarIdentifier Hebrew;
    public static final CFCalendarIdentifier Islamic;
    public static final CFCalendarIdentifier IslamicCivil;
    public static final CFCalendarIdentifier Japanese;
    public static final CFCalendarIdentifier RepublicOfChina;
    public static final CFCalendarIdentifier Persian;
    public static final CFCalendarIdentifier Indian;
    public static final CFCalendarIdentifier ISO8601;
    public static final CFCalendarIdentifier IslamicTabular;
    public static final CFCalendarIdentifier IslamicUmmAlQura;
    private static CFCalendarIdentifier[] values;

    CFCalendarIdentifier(String getterName) {
        super(Values.class, getterName);
    }

    public static CFCalendarIdentifier valueOf(CFString value) {
        for (CFCalendarIdentifier v : values) {
            if (!((CFString)v.value()).equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " + CFCalendarIdentifier.class.getName());
    }

    static {
        Bro.bind(CFCalendarIdentifier.class);
        Gregorian = new CFCalendarIdentifier("Gregorian");
        Buddhist = new CFCalendarIdentifier("Buddhist");
        Chinese = new CFCalendarIdentifier("Chinese");
        Hebrew = new CFCalendarIdentifier("Hebrew");
        Islamic = new CFCalendarIdentifier("Islamic");
        IslamicCivil = new CFCalendarIdentifier("IslamicCivil");
        Japanese = new CFCalendarIdentifier("Japanese");
        RepublicOfChina = new CFCalendarIdentifier("RepublicOfChina");
        Persian = new CFCalendarIdentifier("Persian");
        Indian = new CFCalendarIdentifier("Indian");
        ISO8601 = new CFCalendarIdentifier("ISO8601");
        IslamicTabular = new CFCalendarIdentifier("IslamicTabular");
        IslamicUmmAlQura = new CFCalendarIdentifier("IslamicUmmAlQura");
        values = new CFCalendarIdentifier[]{Gregorian, Buddhist, Chinese, Hebrew, Islamic, IslamicCivil, Japanese, RepublicOfChina, Persian, Indian, ISO8601, IslamicTabular, IslamicUmmAlQura};
    }

    @Library(value="CoreFoundation")
    @StronglyLinked
    public static class Values {
        @GlobalValue(symbol="kCFGregorianCalendar", optional=true)
        public static native CFString Gregorian();

        @GlobalValue(symbol="kCFBuddhistCalendar", optional=true)
        public static native CFString Buddhist();

        @GlobalValue(symbol="kCFChineseCalendar", optional=true)
        public static native CFString Chinese();

        @GlobalValue(symbol="kCFHebrewCalendar", optional=true)
        public static native CFString Hebrew();

        @GlobalValue(symbol="kCFIslamicCalendar", optional=true)
        public static native CFString Islamic();

        @GlobalValue(symbol="kCFIslamicCivilCalendar", optional=true)
        public static native CFString IslamicCivil();

        @GlobalValue(symbol="kCFJapaneseCalendar", optional=true)
        public static native CFString Japanese();

        @GlobalValue(symbol="kCFRepublicOfChinaCalendar", optional=true)
        public static native CFString RepublicOfChina();

        @GlobalValue(symbol="kCFPersianCalendar", optional=true)
        public static native CFString Persian();

        @GlobalValue(symbol="kCFIndianCalendar", optional=true)
        public static native CFString Indian();

        @GlobalValue(symbol="kCFISO8601Calendar", optional=true)
        public static native CFString ISO8601();

        @GlobalValue(symbol="kCFIslamicTabularCalendar", optional=true)
        public static native CFString IslamicTabular();

        @GlobalValue(symbol="kCFIslamicUmmAlQuraCalendar", optional=true)
        public static native CFString IslamicUmmAlQura();

        static {
            Bro.bind(Values.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CFCalendarIdentifier> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CFCalendarIdentifier> list = new ArrayList<CFCalendarIdentifier>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(CFCalendarIdentifier.valueOf(o.get(i, CFString.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CFCalendarIdentifier> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CFCalendarIdentifier o : l) {
                ((CFArray)array).add((NativeObject)o.value());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CFCalendarIdentifier toObject(Class<CFCalendarIdentifier> cls, long handle, long flags) {
            CFString o = (CFString)CFType.Marshaler.toObject(CFString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return CFCalendarIdentifier.valueOf(o);
        }

        @MarshalsPointer
        public static long toNative(CFCalendarIdentifier o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative((CFType)o.value(), flags);
        }
    }
}

