/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFDictionaryKeyCallBacks;
import org.robovm.apple.corefoundation.CFDictionaryValueCallBacks;
import org.robovm.apple.corefoundation.CFMutableDictionary;
import org.robovm.apple.corefoundation.CFPropertyList;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreFoundation")
public class CFDictionary
extends CFPropertyList {
    static final Method cbPutAll;

    protected CFDictionary() {
    }

    @Callback
    private static void cbPutAll(VoidPtr key, VoidPtr value, CFMutableDictionary thiz) {
        thiz.put((NativeObject)key, (NativeObject)value);
    }

    public static <K extends NativeObject, V extends NativeObject> CFDictionary create(Map<K, V> m) {
        if (m == null) {
            throw new NullPointerException("m");
        }
        if (m.size() == 0) {
            return CFDictionary.create(null, null, null, 0L, CFDictionary.getTypeKeyCallBacks(), CFDictionary.getTypeValueCallBacks());
        }
        return CFDictionary.create(m.keySet(), m.values());
    }

    public static <K extends NativeObject, V extends NativeObject> CFDictionary create(Collection<K> k, Collection<V> v) {
        if (k == null) {
            throw new NullPointerException("k");
        }
        if (v == null) {
            throw new NullPointerException("v");
        }
        if (k.size() == 0) {
            return CFDictionary.create(null, null, null, 0L, CFDictionary.getTypeKeyCallBacks(), CFDictionary.getTypeValueCallBacks());
        }
        if (k.iterator().next() instanceof NSObject) {
            return CFDictionary.create((NativeObject[])k.toArray(new NSObject[k.size()]), (NativeObject[])v.toArray(new NSObject[v.size()]));
        }
        if (k.iterator().next() instanceof CFType) {
            return CFDictionary.create(k.toArray(new CFType[k.size()]), v.toArray(new CFType[v.size()]));
        }
        throw new IllegalArgumentException("items can only be of type CFType or NSObject!");
    }

    public static CFDictionary create(NativeObject[] k, NativeObject[] v) {
        if (k == null) {
            throw new NullPointerException("k");
        }
        if (v == null) {
            throw new NullPointerException("v");
        }
        if (k.length == 0) {
            return CFDictionary.create(null, null, null, 0L, CFDictionary.getTypeKeyCallBacks(), CFDictionary.getTypeValueCallBacks());
        }
        if (k[0] instanceof NSObject) {
            NSObject.NSObjectPtr keys = (NSObject.NSObjectPtr)Struct.allocate(NSObject.NSObjectPtr.class, (int)k.length);
            keys.set((NativeObject[])((NSObject[])k));
            NSObject.NSObjectPtr values = (NSObject.NSObjectPtr)Struct.allocate(NSObject.NSObjectPtr.class, (int)v.length);
            values.set((NativeObject[])((NSObject[])v));
            return CFDictionary.create(null, (VoidPtr.VoidPtrPtr)keys.as(VoidPtr.VoidPtrPtr.class), (VoidPtr.VoidPtrPtr)values.as(VoidPtr.VoidPtrPtr.class), v.length, CFDictionary.getTypeKeyCallBacks(), CFDictionary.getTypeValueCallBacks());
        }
        if (k[0] instanceof CFType) {
            CFType.CFTypePtr keys = (CFType.CFTypePtr)Struct.allocate(CFType.CFTypePtr.class, (int)k.length);
            keys.set((CFType[])k);
            CFType.CFTypePtr values = (CFType.CFTypePtr)Struct.allocate(CFType.CFTypePtr.class, (int)v.length);
            values.set((CFType[])v);
            return CFDictionary.create(null, (VoidPtr.VoidPtrPtr)keys.as(VoidPtr.VoidPtrPtr.class), (VoidPtr.VoidPtrPtr)values.as(VoidPtr.VoidPtrPtr.class), v.length, CFDictionary.getTypeKeyCallBacks(), CFDictionary.getTypeValueCallBacks());
        }
        throw new IllegalArgumentException("items can only be of type CFType or NSObject!");
    }

    public <K extends NativeObject, V extends NativeObject> Map<K, V> asMap(Class<K> keyType, Class<V> valueType) {
        HashMap<NativeObject, NativeObject> map = new HashMap<NativeObject, NativeObject>();
        VoidPtr.VoidPtrPtr keys = new VoidPtr.VoidPtrPtr();
        VoidPtr.VoidPtrPtr values = new VoidPtr.VoidPtrPtr();
        this.getKeysAndValues(keys, values);
        VoidPtr kp = (VoidPtr)keys.get();
        VoidPtr vp = (VoidPtr)values.get();
        map.put(kp.as(keyType), vp.as(valueType));
        long n = this.size();
        for (long i = 1L; i < n; ++i) {
            VoidPtr k = (VoidPtr)kp.next();
            VoidPtr v = (VoidPtr)vp.next();
            map.put(k.as(keyType), v.as(valueType));
        }
        return map;
    }

    public <V extends NativeObject> Map<String, V> asStringMap(Class<V> valueType) {
        HashMap<String, NativeObject> map = new HashMap<String, NativeObject>();
        VoidPtr.VoidPtrPtr keys = new VoidPtr.VoidPtrPtr();
        VoidPtr.VoidPtrPtr values = new VoidPtr.VoidPtrPtr();
        this.getKeysAndValues(keys, values);
        VoidPtr kp = (VoidPtr)keys.get();
        VoidPtr vp = (VoidPtr)values.get();
        map.put(((CFString)kp.as(CFString.class)).toString(), vp.as(valueType));
        long n = this.size();
        for (long i = 1L; i < n; ++i) {
            VoidPtr.VoidPtrPtr k = (VoidPtr.VoidPtrPtr)keys.next();
            VoidPtr.VoidPtrPtr v = (VoidPtr.VoidPtrPtr)values.next();
            map.put(((CFString)((VoidPtr)k.get()).as(CFString.class)).toString(), ((VoidPtr)v.get()).as(valueType));
        }
        return map;
    }

    public Map<String, String> asStringStringMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        VoidPtr.VoidPtrPtr keys = new VoidPtr.VoidPtrPtr();
        VoidPtr.VoidPtrPtr values = new VoidPtr.VoidPtrPtr();
        this.getKeysAndValues(keys, values);
        VoidPtr kp = (VoidPtr)keys.get();
        VoidPtr vp = (VoidPtr)values.get();
        map.put(((CFString)kp.as(CFString.class)).toString(), ((CFString)vp.as(CFString.class)).toString());
        long n = this.size();
        for (long i = 1L; i < n; ++i) {
            VoidPtr.VoidPtrPtr k = (VoidPtr.VoidPtrPtr)keys.next();
            VoidPtr.VoidPtrPtr v = (VoidPtr.VoidPtrPtr)values.next();
            map.put(((CFString)((VoidPtr)k.get()).as(CFString.class)).toString(), ((CFString)((VoidPtr)v.get()).as(CFString.class)).toString());
        }
        return map;
    }

    public static <V extends NativeObject> CFDictionary fromStringMap(Map<String, V> m) {
        ArrayList<CFString> keys = new ArrayList<CFString>();
        for (String key : m.keySet()) {
            keys.add(new CFString(key));
        }
        return CFDictionary.create(keys, m.values());
    }

    public static CFDictionary fromStringStringMap(Map<String, String> m) {
        NativeObject[] keys = new CFString[m.size()];
        NativeObject[] values = new CFString[m.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : m.entrySet()) {
            keys[i] = new CFString(entry.getKey());
            values[i] = new CFString(entry.getValue());
            ++i;
        }
        return CFDictionary.create(keys, values);
    }

    public <T extends NativeObject> T get(NativeObject key, Class<T> type) {
        return (T)this.getValue((VoidPtr)key.as(VoidPtr.class)).as(type);
    }

    public boolean containsKey(NativeObject key) {
        return this.containsKey((VoidPtr)key.as(VoidPtr.class));
    }

    public boolean containsValue(NativeObject value) {
        return this.containsValue((VoidPtr)value.as(VoidPtr.class));
    }

    @MachineSizedSInt
    public long size() {
        return this.getCount();
    }

    public void put(NativeObject key, NativeObject value) {
        throw new UnsupportedOperationException("CFDictionary is immutable. Use CFMutableDictionary instead!");
    }

    public void putAll(CFDictionary dict) {
        throw new UnsupportedOperationException("CFDictionary is immutable. Use CFMutableDictionary instead!");
    }

    public void remove(NativeObject key) {
        throw new UnsupportedOperationException("CFDictionary is immutable. Use CFMutableDictionary instead!");
    }

    public void clear() {
        throw new UnsupportedOperationException("CFDictionary is immutable. Use CFMutableDictionary instead!");
    }

    @GlobalValue(symbol="kCFTypeDictionaryKeyCallBacks", optional=true)
    @ByVal
    public static native CFDictionaryKeyCallBacks getTypeKeyCallBacks();

    @GlobalValue(symbol="kCFCopyStringDictionaryKeyCallBacks", optional=true)
    @ByVal
    public static native CFDictionaryKeyCallBacks getCopyStringKeyCallBacks();

    @GlobalValue(symbol="kCFTypeDictionaryValueCallBacks", optional=true)
    @ByVal
    public static native CFDictionaryValueCallBacks getTypeValueCallBacks();

    @Bridge(symbol="CFDictionaryGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFDictionaryCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFDictionary create(CFAllocator var0, VoidPtr.VoidPtrPtr var1, VoidPtr.VoidPtrPtr var2, @MachineSizedSInt long var3, CFDictionaryKeyCallBacks var5, CFDictionaryValueCallBacks var6);

    @Bridge(symbol="CFDictionaryCreateCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFDictionary createCopy(CFAllocator var0, CFDictionary var1);

    @Bridge(symbol="CFDictionaryGetCount", optional=true)
    @MachineSizedSInt
    protected native long getCount();

    @Bridge(symbol="CFDictionaryGetCountOfKey", optional=true)
    @MachineSizedSInt
    protected native long getCountOfKey(VoidPtr var1);

    @Bridge(symbol="CFDictionaryGetCountOfValue", optional=true)
    @MachineSizedSInt
    protected native long getCountOfValue(VoidPtr var1);

    @Bridge(symbol="CFDictionaryContainsKey", optional=true)
    protected native boolean containsKey(VoidPtr var1);

    @Bridge(symbol="CFDictionaryContainsValue", optional=true)
    protected native boolean containsValue(VoidPtr var1);

    @Bridge(symbol="CFDictionaryGetValue", optional=true)
    protected native VoidPtr getValue(VoidPtr var1);

    @Bridge(symbol="CFDictionaryGetValueIfPresent", optional=true)
    protected native boolean getValueIfPresent(VoidPtr var1, VoidPtr.VoidPtrPtr var2);

    @Bridge(symbol="CFDictionaryGetKeysAndValues", optional=true)
    protected native void getKeysAndValues(VoidPtr.VoidPtrPtr var1, VoidPtr.VoidPtrPtr var2);

    @Bridge(symbol="CFDictionaryApplyFunction", optional=true)
    protected native void applyFunction(FunctionPtr var1, @Pointer long var2);

    static {
        try {
            cbPutAll = CFDictionary.class.getDeclaredMethod("cbPutAll", VoidPtr.class, VoidPtr.class, CFMutableDictionary.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CFDictionary.class);
    }

    public static class CFDictionaryPtr
    extends Ptr<CFDictionary, CFDictionaryPtr> {
    }

    public static class AsStringStringMapMarshaler {
        @MarshalsPointer
        public static Map<String, String> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            return o.asStringStringMap();
        }

        @MarshalsPointer
        public static long toNative(Map<String, String> l, long flags) {
            if (l == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(CFDictionary.fromStringStringMap(l), flags);
        }
    }

    public static class AsStringMapMarshaler {
        @MarshalsPointer
        public static Map<String, ?> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            return o.asStringMap(NativeObject.class);
        }

        @MarshalsPointer
        public static long toNative(Map<String, ?> l, long flags) {
            if (l == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(CFDictionary.fromStringMap(l), flags);
        }
    }

    public static class AsMapMarshaler {
        @MarshalsPointer
        public static Map<?, ?> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            return o.asMap(NativeObject.class, NativeObject.class);
        }

        @MarshalsPointer
        public static long toNative(Map<?, ?> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFDictionary o = CFDictionary.create(l);
            return CFType.Marshaler.toNative(o, flags);
        }
    }
}

