/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFFileDescriptorCallBackType;
import org.robovm.apple.corefoundation.CFFileDescriptorContext;
import org.robovm.apple.corefoundation.CFRunLoopSource;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreFoundation")
public class CFFileDescriptor
extends CFType {
    private static final AtomicLong refconId = new AtomicLong();
    private static final LongMap<CFFileDescriptorCallback> callbacks = new LongMap();
    private static final Method cbInvoke;

    protected CFFileDescriptor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbInvoke(CFFileDescriptor fileDescriptor, CFFileDescriptorCallBackType callBackTypes, @Pointer long info) {
        CFFileDescriptorCallback callback = null;
        LongMap<CFFileDescriptorCallback> longMap = callbacks;
        synchronized (longMap) {
            callback = (CFFileDescriptorCallback)callbacks.get(info);
        }
        callback.invoke(fileDescriptor, callBackTypes);
    }

    public static CFFileDescriptor create(int fd, boolean closeOnInvalidate, CFFileDescriptorCallback callback) {
        return CFFileDescriptor.create(null, fd, closeOnInvalidate, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFFileDescriptor create(CFAllocator allocator, int fd, boolean closeOnInvalidate, CFFileDescriptorCallback callback) {
        long refconId = CFFileDescriptor.refconId.getAndIncrement();
        CFFileDescriptorContext context = new CFFileDescriptorContext();
        context.setInfo(refconId);
        CFFileDescriptor result = CFFileDescriptor.create(allocator, fd, closeOnInvalidate, new FunctionPtr(cbInvoke), context);
        if (result != null) {
            LongMap<CFFileDescriptorCallback> longMap = callbacks;
            synchronized (longMap) {
                callbacks.put(refconId, (Object)callback);
            }
        }
        return result;
    }

    public CFRunLoopSource createRunLoopSource(@MachineSizedSInt long order) {
        return this.createRunLoopSource(null, order);
    }

    public CFRunLoopSource createRunLoopSource(CFAllocator allocator, @MachineSizedSInt long order) {
        return CFFileDescriptor.createRunLoopSource(allocator, this, order);
    }

    @Bridge(symbol="CFFileDescriptorGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFFileDescriptorCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFFileDescriptor create(CFAllocator var0, int var1, boolean var2, FunctionPtr var3, CFFileDescriptorContext var4);

    @Bridge(symbol="CFFileDescriptorGetNativeDescriptor", optional=true)
    public native int getNativeDescriptor();

    @Bridge(symbol="CFFileDescriptorEnableCallBacks", optional=true)
    public native void enableCallBacks(CFFileDescriptorCallBackType var1);

    @Bridge(symbol="CFFileDescriptorDisableCallBacks", optional=true)
    public native void disableCallBacks(CFFileDescriptorCallBackType var1);

    @Bridge(symbol="CFFileDescriptorInvalidate", optional=true)
    public native void invalidate();

    @Bridge(symbol="CFFileDescriptorIsValid", optional=true)
    public native boolean isValid();

    @Bridge(symbol="CFFileDescriptorCreateRunLoopSource", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFRunLoopSource createRunLoopSource(CFAllocator var0, CFFileDescriptor var1, @MachineSizedSInt long var2);

    static {
        try {
            cbInvoke = CFFileDescriptor.class.getDeclaredMethod("cbInvoke", CFFileDescriptor.class, CFFileDescriptorCallBackType.class, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CFFileDescriptor.class);
    }

    public static interface CFFileDescriptorCallback {
        public void invoke(CFFileDescriptor var1, CFFileDescriptorCallBackType var2);
    }

    public static class CFFileDescriptorPtr
    extends Ptr<CFFileDescriptor, CFFileDescriptorPtr> {
    }
}

