/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.nio.ByteBuffer;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFData;
import org.robovm.apple.corefoundation.CFRange;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreFoundation")
public class CFMutableData
extends CFData {
    protected CFMutableData() {
    }

    static void checkOffsetAndCount(int arrayLength, int offset, int count) {
        if ((offset | count) < 0 || offset > arrayLength || arrayLength - offset < count) {
            throw new ArrayIndexOutOfBoundsException("length=" + arrayLength + "; regionStart=" + offset + "; regionLength=" + count);
        }
    }

    public static CFMutableData create(long capacity) {
        return CFMutableData.create((CFAllocator)null, capacity);
    }

    public static CFMutableData createCopy(long capacity, CFData theData) {
        return CFMutableData.createCopy(null, capacity, theData);
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return VM.newDirectByteBuffer((long)this.getMutableBytePtr(), (long)this.getLength());
    }

    public CFMutableData append(ByteBuffer bytes) {
        long handle = CFMutableData.getEffectiveAddress(bytes) + (long)bytes.position();
        this.append(handle, bytes.remaining());
        return this;
    }

    public CFMutableData append(byte[] bytes) {
        return this.append(bytes, 0, bytes.length);
    }

    public CFMutableData append(byte[] bytes, int offset, int length) {
        CFMutableData.checkOffsetAndCount(bytes.length, offset, length);
        if (length == 0) {
            return this;
        }
        this.append(VM.getArrayValuesAddress((Object)bytes) + (long)offset, length);
        return this;
    }

    public CFMutableData insert(long location, ByteBuffer bytes) {
        return this.replace(new CFRange(location, 0L), bytes);
    }

    public CFMutableData insert(long location, byte[] bytes) {
        return this.replace(new CFRange(location, 0L), bytes, 0, bytes.length);
    }

    public CFMutableData insert(long location, byte[] bytes, int offset, int length) {
        return this.replace(new CFRange(location, 0L), bytes, offset, length);
    }

    public CFMutableData replace(CFRange range, ByteBuffer bytes) {
        long handle = CFMutableData.getEffectiveAddress(bytes) + (long)bytes.position();
        this.replace(range, handle, bytes.remaining());
        return this;
    }

    public CFMutableData replace(CFRange range, byte[] bytes) {
        return this.replace(range, bytes, 0, bytes.length);
    }

    public CFMutableData replace(CFRange range, byte[] bytes, int offset, int length) {
        CFMutableData.checkOffsetAndCount(bytes.length, offset, length);
        this.replace(range, VM.getArrayValuesAddress((Object)bytes) + (long)offset, length);
        return this;
    }

    public CFMutableData delete(CFRange range) {
        this.deleteBytes(range);
        return this;
    }

    @Bridge(symbol="CFDataCreateMutable", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFMutableData create(CFAllocator var0, @MachineSizedSInt long var1);

    @Bridge(symbol="CFDataCreateMutableCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFMutableData createCopy(CFAllocator var0, @MachineSizedSInt long var1, CFData var3);

    @Bridge(symbol="CFDataGetMutableBytePtr", optional=true)
    @Pointer
    protected native long getMutableBytePtr();

    @Bridge(symbol="CFDataSetLength", optional=true)
    public native void setLength(@MachineSizedSInt long var1);

    @Bridge(symbol="CFDataIncreaseLength", optional=true)
    public native void increaseLength(@MachineSizedSInt long var1);

    @Bridge(symbol="CFDataAppendBytes", optional=true)
    protected native void append(@Pointer long var1, @MachineSizedSInt long var3);

    @Bridge(symbol="CFDataReplaceBytes", optional=true)
    protected native void replace(@ByVal CFRange var1, @Pointer long var2, @MachineSizedSInt long var4);

    @Bridge(symbol="CFDataDeleteBytes", optional=true)
    protected native void deleteBytes(@ByVal CFRange var1);

    static {
        Bro.bind(CFMutableData.class);
    }

    public static class CFMutableDataPtr
    extends Ptr<CFMutableData, CFMutableDataPtr> {
    }
}

