/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryKeyCallBacks;
import org.robovm.apple.corefoundation.CFDictionaryValueCallBacks;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreFoundation")
public class CFMutableDictionary
extends CFDictionary {
    protected CFMutableDictionary() {
    }

    public static CFMutableDictionary create() {
        return CFMutableDictionary.create(0L);
    }

    public static CFMutableDictionary create(long capacity) {
        return CFMutableDictionary.create(null, capacity, CFMutableDictionary.getTypeKeyCallBacks(), CFMutableDictionary.getTypeValueCallBacks());
    }

    @Override
    public void put(NativeObject key, NativeObject value) {
        this.setValue((VoidPtr)key.as(VoidPtr.class), (VoidPtr)value.as(VoidPtr.class));
    }

    @Override
    public void putAll(CFDictionary dict) {
        dict.applyFunction(new FunctionPtr(cbPutAll), this.getHandle());
    }

    @Override
    public void remove(NativeObject key) {
        this.removeValue((VoidPtr)key.as(VoidPtr.class));
    }

    @Override
    public void clear() {
        this.removeAllValues();
    }

    @Bridge(symbol="CFDictionaryCreateMutable", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFMutableDictionary create(CFAllocator var0, @MachineSizedSInt long var1, CFDictionaryKeyCallBacks var3, CFDictionaryValueCallBacks var4);

    @Bridge(symbol="CFDictionaryCreateMutableCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFMutableDictionary createCopy(CFAllocator var0, @MachineSizedSInt long var1, CFDictionary var3);

    @Bridge(symbol="CFDictionaryAddValue", optional=true)
    private native void addValue(VoidPtr var1, VoidPtr var2);

    @Bridge(symbol="CFDictionarySetValue", optional=true)
    private native void setValue(VoidPtr var1, VoidPtr var2);

    @Bridge(symbol="CFDictionaryReplaceValue", optional=true)
    private native void replaceValue(VoidPtr var1, VoidPtr var2);

    @Bridge(symbol="CFDictionaryRemoveValue", optional=true)
    private native void removeValue(VoidPtr var1);

    @Bridge(symbol="CFDictionaryRemoveAllValues", optional=true)
    private native void removeAllValues();

    static {
        Bro.bind(CFMutableDictionary.class);
    }

    public static class CFMutableDictionaryPtr
    extends Ptr<CFMutableDictionary, CFMutableDictionaryPtr> {
    }
}

