/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFComparisonResult;
import org.robovm.apple.corefoundation.CFNumberType;
import org.robovm.apple.corefoundation.CFPropertyList;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.CharPtr;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.FloatPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.ShortPtr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreFoundation")
public class CFNumber
extends CFPropertyList {
    protected CFNumber() {
    }

    public byte byteValue() {
        VoidPtr ptr = new VoidPtr();
        this.getValue(CFNumberType.SInt8Type, ptr);
        return ((BytePtr)ptr.as(BytePtr.class)).get();
    }

    public short shortValue() {
        VoidPtr ptr = new VoidPtr();
        this.getValue(CFNumberType.SInt16Type, ptr);
        return ((ShortPtr)ptr.as(ShortPtr.class)).get();
    }

    public char charValue() {
        VoidPtr ptr = new VoidPtr();
        this.getValue(CFNumberType.SInt16Type, ptr);
        return ((CharPtr)ptr.as(CharPtr.class)).get();
    }

    public int intValue() {
        VoidPtr ptr = new VoidPtr();
        this.getValue(CFNumberType.SInt32Type, ptr);
        return ((IntPtr)ptr.as(IntPtr.class)).get();
    }

    public long longValue() {
        VoidPtr ptr = new VoidPtr();
        this.getValue(CFNumberType.SInt8Type, ptr);
        return ((LongPtr)ptr.as(LongPtr.class)).get();
    }

    public float floatValue() {
        VoidPtr ptr = new VoidPtr();
        this.getValue(CFNumberType.Float32Type, ptr);
        return ((FloatPtr)ptr.as(FloatPtr.class)).get();
    }

    public double doubleValue() {
        VoidPtr ptr = new VoidPtr();
        this.getValue(CFNumberType.Float64Type, ptr);
        return ((DoublePtr)ptr.as(DoublePtr.class)).get();
    }

    public boolean booleanValue() {
        int b = this.intValue();
        return b != 0;
    }

    public static CFNumber valueOf(byte value) {
        return CFNumber.create(null, CFNumberType.SInt8Type, (VoidPtr)new BytePtr(value).as(VoidPtr.class));
    }

    public static CFNumber valueOf(short value) {
        return CFNumber.create(null, CFNumberType.SInt16Type, (VoidPtr)new ShortPtr(value).as(VoidPtr.class));
    }

    public static CFNumber valueOf(char value) {
        return CFNumber.create(null, CFNumberType.SInt16Type, (VoidPtr)new CharPtr(value).as(VoidPtr.class));
    }

    public static CFNumber valueOf(int value) {
        return CFNumber.create(null, CFNumberType.SInt32Type, (VoidPtr)new IntPtr(value).as(VoidPtr.class));
    }

    public static CFNumber valueOf(long value) {
        return CFNumber.create(null, CFNumberType.SInt64Type, (VoidPtr)new LongPtr(value).as(VoidPtr.class));
    }

    public static CFNumber valueOf(float value) {
        return CFNumber.create(null, CFNumberType.Float32Type, (VoidPtr)new FloatPtr(value).as(VoidPtr.class));
    }

    public static CFNumber valueOf(double value) {
        return CFNumber.create(null, CFNumberType.Float64Type, (VoidPtr)new DoublePtr(value).as(VoidPtr.class));
    }

    public static CFNumber valueOf(boolean value) {
        return CFNumber.create(null, CFNumberType.SInt32Type, (VoidPtr)new IntPtr(value ? 1 : 0).as(VoidPtr.class));
    }

    public static CFNumber valueOf(Number value) {
        if (value instanceof Byte) {
            return CFNumber.valueOf((Byte)value);
        }
        if (value instanceof Short) {
            return CFNumber.valueOf((Short)value);
        }
        if (value instanceof Integer) {
            return CFNumber.valueOf((Integer)value);
        }
        if (value instanceof Long) {
            return CFNumber.valueOf((Long)value);
        }
        if (value instanceof Float) {
            return CFNumber.valueOf(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return CFNumber.valueOf((Double)value);
        }
        throw new IllegalArgumentException("value is not a supported number type: " + value.getClass());
    }

    public CFComparisonResult compareTo(CFNumber otherNumber) {
        return this.compareTo(otherNumber, null);
    }

    @GlobalValue(symbol="kCFNumberPositiveInfinity", optional=true)
    public static native CFNumber getPositiveInfinity();

    @GlobalValue(symbol="kCFNumberNegativeInfinity", optional=true)
    public static native CFNumber getNegativeInfinity();

    @GlobalValue(symbol="kCFNumberNaN", optional=true)
    public static native CFNumber getNaN();

    @Bridge(symbol="CFNumberGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFNumberCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFNumber create(CFAllocator var0, CFNumberType var1, VoidPtr var2);

    @Bridge(symbol="CFNumberGetType", optional=true)
    public native CFNumberType getType();

    @Bridge(symbol="CFNumberGetByteSize", optional=true)
    @MachineSizedSInt
    public native long getByteSize();

    @Bridge(symbol="CFNumberIsFloatType", optional=true)
    public native boolean isFloatType();

    @Bridge(symbol="CFNumberGetValue", optional=true)
    private native boolean getValue(CFNumberType var1, VoidPtr var2);

    @Bridge(symbol="CFNumberCompare", optional=true)
    private native CFComparisonResult compareTo(CFNumber var1, VoidPtr var2);

    static {
        Bro.bind(CFNumber.class);
    }

    public static class CFNumberPtr
    extends Ptr<CFNumber, CFNumberPtr> {
    }
}

