/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFRunLoopExitReason;
import org.robovm.apple.corefoundation.CFRunLoopMode;
import org.robovm.apple.corefoundation.CFRunLoopObserver;
import org.robovm.apple.corefoundation.CFRunLoopSource;
import org.robovm.apple.corefoundation.CFRunLoopTimer;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.objc.annotation.Block;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreFoundation")
public class CFRunLoop
extends CFType {
    protected CFRunLoop() {
    }

    public void addCommonMode(CFRunLoopMode mode) {
        this.addCommonMode(((CFString)mode.value()).toString());
    }

    public double getNextTimerFireDate(CFRunLoopMode mode) {
        return this.getNextTimerFireDate(((CFString)mode.value()).toString());
    }

    public static CFRunLoopExitReason runInMode(CFRunLoopMode mode, double seconds, boolean returnAfterSourceHandled) {
        return CFRunLoop.runInMode(((CFString)mode.value()).toString(), seconds, returnAfterSourceHandled);
    }

    public void performBlock(String mode, Runnable block) {
        this.performBlock(new CFString(mode), block);
    }

    public void performBlock(List<String> mode, Runnable block) {
        this.performBlock(CFArray.fromStrings(mode), block);
    }

    public boolean containsSource(CFRunLoopSource source, CFRunLoopMode mode) {
        return this.containsSource(source, ((CFString)mode.value()).toString());
    }

    public void addSource(CFRunLoopSource source, CFRunLoopMode mode) {
        this.addSource(source, ((CFString)mode.value()).toString());
    }

    public void removeSource(CFRunLoopSource source, CFRunLoopMode mode) {
        this.removeSource(source, ((CFString)mode.value()).toString());
    }

    public boolean containsObserver(CFRunLoopObserver observer, CFRunLoopMode mode) {
        return this.containsObserver(observer, ((CFString)mode.value()).toString());
    }

    public void addObserver(CFRunLoopObserver observer, CFRunLoopMode mode) {
        this.addObserver(observer, ((CFString)mode.value()).toString());
    }

    public void removeObserver(CFRunLoopObserver observer, CFRunLoopMode mode) {
        this.removeObserver(observer, ((CFString)mode.value()).toString());
    }

    public boolean containsTimer(CFRunLoopTimer timer, CFRunLoopMode mode) {
        return this.containsTimer(timer, ((CFString)mode.value()).toString());
    }

    public void addTimer(CFRunLoopTimer timer, CFRunLoopMode mode) {
        this.addTimer(timer, ((CFString)mode.value()).toString());
    }

    public void removeTimer(CFRunLoopTimer timer, CFRunLoopMode mode) {
        this.removeTimer(timer, ((CFString)mode.value()).toString());
    }

    @Bridge(symbol="CFRunLoopGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFRunLoopGetCurrent", optional=true)
    public static native CFRunLoop getCurrent();

    @Bridge(symbol="CFRunLoopGetMain", optional=true)
    public static native CFRunLoop getMain();

    @Bridge(symbol="CFRunLoopCopyCurrentMode", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getCurrentMode();

    @Bridge(symbol="CFRunLoopCopyAllModes", optional=true)
    @Marshaler(value=CFArray.AsStringListMarshaler.class)
    public native List<String> getAllModes();

    @Bridge(symbol="CFRunLoopAddCommonMode", optional=true)
    public native void addCommonMode(String var1);

    @Bridge(symbol="CFRunLoopGetNextTimerFireDate", optional=true)
    public native double getNextTimerFireDate(String var1);

    @Bridge(symbol="CFRunLoopRun", optional=true)
    public static native void run();

    @Bridge(symbol="CFRunLoopRunInMode", optional=true)
    public static native CFRunLoopExitReason runInMode(String var0, double var1, boolean var3);

    @Bridge(symbol="CFRunLoopIsWaiting", optional=true)
    public native boolean isWaiting();

    @Bridge(symbol="CFRunLoopWakeUp", optional=true)
    public native void wakeUp();

    @Bridge(symbol="CFRunLoopStop", optional=true)
    public native void stop();

    @Bridge(symbol="CFRunLoopPerformBlock", optional=true)
    private native void performBlock(CFType var1, @Block Runnable var2);

    @Bridge(symbol="CFRunLoopContainsSource", optional=true)
    public native boolean containsSource(CFRunLoopSource var1, String var2);

    @Bridge(symbol="CFRunLoopAddSource", optional=true)
    public native void addSource(CFRunLoopSource var1, String var2);

    @Bridge(symbol="CFRunLoopRemoveSource", optional=true)
    public native void removeSource(CFRunLoopSource var1, String var2);

    @Bridge(symbol="CFRunLoopContainsObserver", optional=true)
    public native boolean containsObserver(CFRunLoopObserver var1, String var2);

    @Bridge(symbol="CFRunLoopAddObserver", optional=true)
    public native void addObserver(CFRunLoopObserver var1, String var2);

    @Bridge(symbol="CFRunLoopRemoveObserver", optional=true)
    public native void removeObserver(CFRunLoopObserver var1, String var2);

    @Bridge(symbol="CFRunLoopContainsTimer", optional=true)
    public native boolean containsTimer(CFRunLoopTimer var1, String var2);

    @Bridge(symbol="CFRunLoopAddTimer", optional=true)
    public native void addTimer(CFRunLoopTimer var1, String var2);

    @Bridge(symbol="CFRunLoopRemoveTimer", optional=true)
    public native void removeTimer(CFRunLoopTimer var1, String var2);

    static {
        Bro.bind(CFRunLoop.class);
    }

    public static class CFRunLoopPtr
    extends Ptr<CFRunLoop, CFRunLoopPtr> {
    }
}

