/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.util.Collection;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFSetCallBacks;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreFoundation")
public class CFSet
extends CFType {
    protected CFSet() {
    }

    public static <T extends NativeObject> CFSet create(Collection<T> objects) {
        if (objects == null) {
            throw new NullPointerException("objects");
        }
        if (objects.size() == 0 || objects.iterator().next() instanceof CFType) {
            return CFSet.create(objects.toArray(new CFType[objects.size()]));
        }
        if (objects.iterator().next() instanceof NSObject) {
            return CFSet.create(objects.toArray(new NSObject[objects.size()]));
        }
        throw new IllegalArgumentException("items can only be of type CFType or NSObject!");
    }

    public static CFSet create(NSObject ... objects) {
        if (objects == null) {
            throw new NullPointerException("objects");
        }
        if (objects.length == 0) {
            return CFSet.create(null, null, 0L, CFSet.getTypeCallBacks());
        }
        NSObject.NSObjectPtr values = (NSObject.NSObjectPtr)Struct.allocate(NSObject.NSObjectPtr.class, (int)objects.length);
        values.set((NativeObject[])objects);
        return CFSet.create(null, (VoidPtr.VoidPtrPtr)values.as(VoidPtr.VoidPtrPtr.class), objects.length, CFSet.getTypeCallBacks());
    }

    public static CFSet create(CFType ... objects) {
        if (objects == null) {
            throw new NullPointerException("objects");
        }
        if (objects.length == 0) {
            return CFSet.create(null, null, 0L, CFSet.getTypeCallBacks());
        }
        CFType.CFTypePtr values = (CFType.CFTypePtr)Struct.allocate(CFType.CFTypePtr.class, (int)objects.length);
        values.set(objects);
        return CFSet.create(null, (VoidPtr.VoidPtrPtr)values.as(VoidPtr.VoidPtrPtr.class), objects.length, CFSet.getTypeCallBacks());
    }

    public boolean contains(NativeObject value) {
        return this.containsValue((VoidPtr)value.as(VoidPtr.class));
    }

    public void add(NativeObject value) {
        throw new UnsupportedOperationException("CFSet is immutable. Use CFMutableSet instead!");
    }

    public void remove(NativeObject value) {
        throw new UnsupportedOperationException("CFSet is immutable. Use CFMutableSet instead!");
    }

    public void clear() {
        throw new UnsupportedOperationException("CFSet is immutable. Use CFMutableSet instead!");
    }

    @GlobalValue(symbol="kCFTypeSetCallBacks", optional=true)
    @ByVal
    public static native CFSetCallBacks getTypeCallBacks();

    @GlobalValue(symbol="kCFCopyStringSetCallBacks", optional=true)
    @ByVal
    public static native CFSetCallBacks getCopyStringCallBacks();

    @Bridge(symbol="CFSetGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFSetCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFSet create(CFAllocator var0, VoidPtr.VoidPtrPtr var1, @MachineSizedSInt long var2, CFSetCallBacks var4);

    @Bridge(symbol="CFSetCreateCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFSet createCopy(CFAllocator var0, CFSet var1);

    @Bridge(symbol="CFSetGetCount", optional=true)
    @MachineSizedSInt
    public native long size();

    @Bridge(symbol="CFSetGetCountOfValue", optional=true)
    @MachineSizedSInt
    protected native long getCountOfValue(VoidPtr var1);

    @Bridge(symbol="CFSetContainsValue", optional=true)
    protected native boolean containsValue(VoidPtr var1);

    @Bridge(symbol="CFSetGetValue", optional=true)
    protected native VoidPtr getValue(VoidPtr var1);

    @Bridge(symbol="CFSetGetValueIfPresent", optional=true)
    protected native boolean getValueIfPresent(VoidPtr var1, VoidPtr.VoidPtrPtr var2);

    @Bridge(symbol="CFSetGetValues", optional=true)
    protected native void getValues(VoidPtr.VoidPtrPtr var1);

    @Bridge(symbol="CFSetApplyFunction", optional=true)
    protected native void applyFunction(FunctionPtr var1, VoidPtr var2);

    static {
        Bro.bind(CFSet.class);
    }

    public static class CFSetPtr
    extends Ptr<CFSet, CFSetPtr> {
    }
}

