/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGBitmapInfo;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.coregraphics.CGContext;
import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.coregraphics.CGImageAlphaInfo;
import org.robovm.objc.LongMap;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.IntPtr;

@Library(value="CoreGraphics")
public class CGBitmapContext
extends CGContext {
    private static AtomicLong releaseInfoGen = new AtomicLong(1L);
    private static final LongMap<ReleaseDataCallback> callbacks = new LongMap();
    private static final Method cbReleaseData;
    private long releaseInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbReleaseData(@Pointer long refcon, @Pointer long data) {
        ReleaseDataCallback callback;
        LongMap<ReleaseDataCallback> longMap = callbacks;
        synchronized (longMap) {
            callback = (ReleaseDataCallback)callbacks.remove(refcon);
        }
        if (callback != null) {
            callback.release(data);
        }
    }

    public static CGBitmapContext create(long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo) {
        return CGBitmapContext.create((byte[])null, width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo);
    }

    public static CGBitmapContext create(long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGImageAlphaInfo alphaInfo) {
        return CGBitmapContext.create((byte[])null, width, height, bitsPerComponent, bytesPerRow, space, alphaInfo);
    }

    public static CGBitmapContext create(byte[] data, long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGImageAlphaInfo alphaInfo) {
        return CGBitmapContext.create(data, width, height, bitsPerComponent, bytesPerRow, space, new CGBitmapInfo(alphaInfo.value()));
    }

    public static CGBitmapContext create(byte[] data, long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo) {
        long ptr = data != null ? VM.getArrayValuesAddress((Object)data) : 0L;
        return CGBitmapContext.internalCreate(data, ptr, width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo);
    }

    public static CGBitmapContext create(short[] data, long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo) {
        long ptr = data != null ? VM.getArrayValuesAddress((Object)data) : 0L;
        return CGBitmapContext.internalCreate(data, ptr, width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo);
    }

    public static CGBitmapContext create(int[] data, long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo) {
        long ptr = data != null ? VM.getArrayValuesAddress((Object)data) : 0L;
        return CGBitmapContext.internalCreate(data, ptr, width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo);
    }

    @Deprecated
    public static CGBitmapContext create(IntPtr data, long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo) {
        long ptr = data != null ? data.getHandle() : 0L;
        return CGBitmapContext.internalCreate(data, ptr, width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo);
    }

    public static CGBitmapContext create(long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo, ReleaseDataCallback releaseCallback) {
        return CGBitmapContext.create((byte[])null, width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo, releaseCallback);
    }

    public static CGBitmapContext create(byte[] data, long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo, ReleaseDataCallback releaseCallback) {
        long ptr = data != null ? VM.getArrayValuesAddress((Object)data) : 0L;
        return CGBitmapContext.internalCreate(ptr, width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo, releaseCallback);
    }

    public static CGBitmapContext create(short[] data, long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo, ReleaseDataCallback releaseCallback) {
        long ptr = data != null ? VM.getArrayValuesAddress((Object)data) : 0L;
        return CGBitmapContext.internalCreate(ptr, width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo, releaseCallback);
    }

    public static CGBitmapContext create(int[] data, long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo, ReleaseDataCallback releaseCallback) {
        long ptr = data != null ? VM.getArrayValuesAddress((Object)data) : 0L;
        return CGBitmapContext.internalCreate(ptr, width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo, releaseCallback);
    }

    @Deprecated
    public static CGBitmapContext create(IntPtr data, long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo, ReleaseDataCallback releaseCallback) {
        return CGBitmapContext.internalCreate(data.getHandle(), width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo, releaseCallback);
    }

    private static CGBitmapContext internalCreate(Object data, @Pointer long ptr, long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo) {
        DataHolderReleaseCallback releaseCallback = null;
        if (data != null && ptr != 0L) {
            releaseCallback = new DataHolderReleaseCallback(data);
        }
        return CGBitmapContext.internalCreate(ptr, width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo, releaseCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CGBitmapContext internalCreate(@Pointer long data, long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo, ReleaseDataCallback releaseCallback) {
        CGBitmapContext result;
        if (releaseCallback != null) {
            long releaseInfo = releaseInfoGen.getAndIncrement();
            result = CGBitmapContext.create(data, width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo, new FunctionPtr(cbReleaseData), releaseInfo);
            if (result != null) {
                LongMap<ReleaseDataCallback> longMap = callbacks;
                synchronized (longMap) {
                    result.releaseInfo = releaseInfo;
                    callbacks.put(releaseInfo, (Object)releaseCallback);
                }
            }
        } else {
            result = CGBitmapContext.create(data, width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(boolean finalizing) {
        super.dispose(finalizing);
        if (this.releaseInfo > 0L) {
            LongMap<ReleaseDataCallback> longMap = callbacks;
            synchronized (longMap) {
                callbacks.remove(this.releaseInfo);
                this.releaseInfo = 0L;
            }
        }
    }

    @Bridge(symbol="CGBitmapContextCreateWithData", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CGBitmapContext create(@Pointer long var0, @MachineSizedUInt long var2, @MachineSizedUInt long var4, @MachineSizedUInt long var6, @MachineSizedUInt long var8, CGColorSpace var10, CGBitmapInfo var11, FunctionPtr var12, @Pointer long var13);

    @Bridge(symbol="CGBitmapContextCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGBitmapContext create(@Pointer long var0, @MachineSizedUInt long var2, @MachineSizedUInt long var4, @MachineSizedUInt long var6, @MachineSizedUInt long var8, CGColorSpace var10, CGBitmapInfo var11);

    @Bridge(symbol="CGBitmapContextGetData", optional=true)
    @Pointer
    public native long getData();

    @Bridge(symbol="CGBitmapContextGetWidth", optional=true)
    @MachineSizedUInt
    public native long getWidth();

    @Bridge(symbol="CGBitmapContextGetHeight", optional=true)
    @MachineSizedUInt
    public native long getHeight();

    @Bridge(symbol="CGBitmapContextGetBitsPerComponent", optional=true)
    @MachineSizedUInt
    public native long getBitsPerComponent();

    @Bridge(symbol="CGBitmapContextGetBitsPerPixel", optional=true)
    @MachineSizedUInt
    public native long getBitsPerPixel();

    @Bridge(symbol="CGBitmapContextGetBytesPerRow", optional=true)
    @MachineSizedUInt
    public native long getBytesPerRow();

    @Bridge(symbol="CGBitmapContextGetColorSpace", optional=true)
    public native CGColorSpace getColorSpace();

    @Bridge(symbol="CGBitmapContextGetAlphaInfo", optional=true)
    public native CGImageAlphaInfo getAlphaInfo();

    @Bridge(symbol="CGBitmapContextGetBitmapInfo", optional=true)
    public native CGBitmapInfo getBitmapInfo();

    @Bridge(symbol="CGBitmapContextCreateImage", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CGImage toImage();

    static {
        try {
            cbReleaseData = CGBitmapContext.class.getDeclaredMethod("cbReleaseData", Long.TYPE, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CGBitmapContext.class);
    }

    public static interface ReleaseDataCallback {
        public void release(@Pointer long var1);
    }

    private static class DataHolderReleaseCallback
    implements ReleaseDataCallback {
        private Object data;

        public DataHolderReleaseCallback(Object data) {
            this.data = data;
        }

        @Override
        public void release(long ptr) {
            this.data = null;
        }
    }
}

