/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import java.util.List;
import java.util.Map;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGDataProvider;
import org.robovm.apple.coregraphics.CGFontVariationAxis;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.ShortPtr;

@Library(value="CoreGraphics")
public class CGFont
extends CFType {
    public static final int FontIndexMax = 65534;
    public static final int FontIndexInvalid = 65535;
    public static final int GlyphMax = 65534;

    protected CGFont() {
    }

    public int[] getGlyphAdvances(char[] glyphs) {
        IntPtr advancesPtr;
        if (glyphs == null) {
            throw new NullPointerException("glyphs");
        }
        int count = glyphs.length;
        int[] advances = new int[count];
        ShortPtr glyphsPtr = (ShortPtr)Struct.toStruct(ShortPtr.class, (long)VM.getArrayValuesAddress((Object)glyphs));
        if (this.getGlyphAdvances(glyphsPtr, count, advancesPtr = (IntPtr)Struct.toStruct(IntPtr.class, (long)VM.getArrayValuesAddress((Object)advances)))) {
            return advances;
        }
        return null;
    }

    public CGRect[] getGlyphBBoxes(char[] glyphs) {
        if (glyphs == null) {
            throw new NullPointerException("glyphs");
        }
        int count = glyphs.length;
        CGRect bboxes = (CGRect)Struct.allocate(CGRect.class, (int)count);
        ShortPtr glyphsPtr = (ShortPtr)Struct.toStruct(ShortPtr.class, (long)VM.getArrayValuesAddress((Object)glyphs));
        if (this.getGlyphBBoxes(glyphsPtr, count, bboxes)) {
            return (CGRect[])bboxes.toArray(count);
        }
        return null;
    }

    @Bridge(symbol="CGFontGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CGFontCreateWithDataProvider", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGFont create(CGDataProvider var0);

    @Bridge(symbol="CGFontCreateWithFontName", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGFont create(String var0);

    @Bridge(symbol="CGFontGetNumberOfGlyphs", optional=true)
    @MachineSizedUInt
    public native long getNumberOfGlyphs();

    @Bridge(symbol="CGFontGetUnitsPerEm", optional=true)
    public native int getUnitsPerEm();

    @Bridge(symbol="CGFontCopyPostScriptName", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getPostScriptName();

    @Bridge(symbol="CGFontCopyFullName", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getFullName();

    @Bridge(symbol="CGFontGetAscent", optional=true)
    public native int getAscent();

    @Bridge(symbol="CGFontGetDescent", optional=true)
    public native int getDescent();

    @Bridge(symbol="CGFontGetLeading", optional=true)
    public native int getLeading();

    @Bridge(symbol="CGFontGetCapHeight", optional=true)
    public native int getCapHeight();

    @Bridge(symbol="CGFontGetXHeight", optional=true)
    public native int getXHeight();

    @Bridge(symbol="CGFontGetFontBBox", optional=true)
    @ByVal
    public native CGRect getFontBBox();

    @Bridge(symbol="CGFontGetItalicAngle", optional=true)
    @MachineSizedFloat
    public native double getItalicAngle();

    @Bridge(symbol="CGFontGetStemV", optional=true)
    @MachineSizedFloat
    public native double getStemV();

    @Bridge(symbol="CGFontCopyVariationAxes", optional=true)
    @Marshaler(value=CGFontVariationAxis.AsListMarshaler.class)
    public native List<CGFontVariationAxis> getVariationAxes();

    @Bridge(symbol="CGFontCopyVariations", optional=true)
    @Marshaler(value=CFDictionary.AsStringMapMarshaler.class)
    public native Map<String, NSNumber> getVariations();

    @Bridge(symbol="CGFontGetGlyphAdvances", optional=true)
    private native boolean getGlyphAdvances(ShortPtr var1, @MachineSizedUInt long var2, IntPtr var4);

    @Bridge(symbol="CGFontGetGlyphBBoxes", optional=true)
    private native boolean getGlyphBBoxes(ShortPtr var1, @MachineSizedUInt long var2, CGRect var4);

    @Bridge(symbol="CGFontGetGlyphWithGlyphName", optional=true)
    public native char getGlyphForName(String var1);

    @Bridge(symbol="CGFontCopyGlyphNameForGlyph", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getNameForGlyph(char var1);

    static {
        Bro.bind(CGFont.class);
    }

    public static class CGFontPtr
    extends Ptr<CGFont, CGFontPtr> {
    }
}

