/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.coregraphics.CGPath;
import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreGraphics")
public class CGMutablePath
extends CGPath {
    protected CGMutablePath() {
    }

    public void addRects(CGAffineTransform m, CGRect[] rects) {
        if (rects == null) {
            throw new NullPointerException("rects");
        }
        CGRect first = (CGRect)Struct.allocate(CGRect.class, (int)rects.length);
        first.update(rects);
        this.addRects(m, first, rects.length);
    }

    public void addLines(CGAffineTransform m, CGPoint[] points) {
        if (points == null) {
            throw new NullPointerException("points");
        }
        CGPoint first = (CGPoint)Struct.allocate(CGPoint.class, (int)points.length);
        first.update(points);
        this.addLines(m, first, points.length);
    }

    @Bridge(symbol="CGPathCreateMutable", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGMutablePath createMutable();

    @Bridge(symbol="CGPathCreateMutableCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGMutablePath createMutableCopy(CGPath var0);

    @Bridge(symbol="CGPathCreateMutableCopyByTransformingPath", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGMutablePath createMutableCopyByTransformingPath(CGPath var0, CGAffineTransform var1);

    @Bridge(symbol="CGPathAddRoundedRect", optional=true)
    public native void addRoundedRect(CGAffineTransform var1, @ByVal CGRect var2, @MachineSizedFloat double var3, @MachineSizedFloat double var5);

    @Bridge(symbol="CGPathMoveToPoint", optional=true)
    public native void moveToPoint(CGAffineTransform var1, @MachineSizedFloat double var2, @MachineSizedFloat double var4);

    @Bridge(symbol="CGPathAddLineToPoint", optional=true)
    public native void addLineToPoint(CGAffineTransform var1, @MachineSizedFloat double var2, @MachineSizedFloat double var4);

    @Bridge(symbol="CGPathAddQuadCurveToPoint", optional=true)
    public native void addQuadCurveToPoint(CGAffineTransform var1, @MachineSizedFloat double var2, @MachineSizedFloat double var4, @MachineSizedFloat double var6, @MachineSizedFloat double var8);

    @Bridge(symbol="CGPathAddCurveToPoint", optional=true)
    public native void addCurveToPoint(CGAffineTransform var1, @MachineSizedFloat double var2, @MachineSizedFloat double var4, @MachineSizedFloat double var6, @MachineSizedFloat double var8, @MachineSizedFloat double var10, @MachineSizedFloat double var12);

    @Bridge(symbol="CGPathCloseSubpath", optional=true)
    public native void closeSubpath();

    @Bridge(symbol="CGPathAddRect", optional=true)
    public native void addRect(CGAffineTransform var1, @ByVal CGRect var2);

    @Bridge(symbol="CGPathAddRects", optional=true)
    private native void addRects(CGAffineTransform var1, CGRect var2, @MachineSizedUInt long var3);

    @Bridge(symbol="CGPathAddLines", optional=true)
    private native void addLines(CGAffineTransform var1, CGPoint var2, @MachineSizedUInt long var3);

    @Bridge(symbol="CGPathAddEllipseInRect", optional=true)
    public native void addEllipseInRect(CGAffineTransform var1, @ByVal CGRect var2);

    @Bridge(symbol="CGPathAddRelativeArc", optional=true)
    public native void addRelativeArc(CGAffineTransform var1, @MachineSizedFloat double var2, @MachineSizedFloat double var4, @MachineSizedFloat double var6, @MachineSizedFloat double var8, @MachineSizedFloat double var10);

    @Bridge(symbol="CGPathAddArc", optional=true)
    public native void addArc(CGAffineTransform var1, @MachineSizedFloat double var2, @MachineSizedFloat double var4, @MachineSizedFloat double var6, @MachineSizedFloat double var8, @MachineSizedFloat double var10, boolean var12);

    @Bridge(symbol="CGPathAddArcToPoint", optional=true)
    public native void addArcToPoint(CGAffineTransform var1, @MachineSizedFloat double var2, @MachineSizedFloat double var4, @MachineSizedFloat double var6, @MachineSizedFloat double var8, @MachineSizedFloat double var10);

    @Bridge(symbol="CGPathAddPath", optional=true)
    public native void addPath(CGAffineTransform var1, CGPath var2);

    static {
        Bro.bind(CGMutablePath.class);
    }

    public static class CGMutablePathPtr
    extends Ptr<CGMutablePath, CGMutablePathPtr> {
    }
}

