/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSData;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreGraphics")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CGPDFBoxOptions
extends CFDictionaryWrapper {
    CGPDFBoxOptions(CFDictionary data) {
        super(data);
    }

    public CGPDFBoxOptions() {
    }

    public boolean has(CFString key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFString key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public CGPDFBoxOptions set(CFString key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public CGRect getMediaBox() {
        if (this.has(Keys.MediaBox())) {
            NSData val = this.get(Keys.MediaBox(), NSData.class);
            return val.getStructData(CGRect.class);
        }
        return null;
    }

    public CGPDFBoxOptions setMediaBox(CGRect mediaBox) {
        this.set(Keys.MediaBox(), (NativeObject)new NSData(mediaBox));
        return this;
    }

    public CGRect getCropBox() {
        if (this.has(Keys.CropBox())) {
            NSData val = this.get(Keys.CropBox(), NSData.class);
            return val.getStructData(CGRect.class);
        }
        return null;
    }

    public CGPDFBoxOptions setCropBox(CGRect cropBox) {
        this.set(Keys.CropBox(), (NativeObject)new NSData(cropBox));
        return this;
    }

    public CGRect getBleedBox() {
        if (this.has(Keys.BleedBox())) {
            NSData val = this.get(Keys.BleedBox(), NSData.class);
            return val.getStructData(CGRect.class);
        }
        return null;
    }

    public CGPDFBoxOptions setBleedBox(CGRect bleedBox) {
        this.set(Keys.BleedBox(), (NativeObject)new NSData(bleedBox));
        return this;
    }

    public CGRect getTrimBox() {
        if (this.has(Keys.TrimBox())) {
            NSData val = this.get(Keys.TrimBox(), NSData.class);
            return val.getStructData(CGRect.class);
        }
        return null;
    }

    public CGPDFBoxOptions setTrimBox(CGRect trimBox) {
        this.set(Keys.TrimBox(), (NativeObject)new NSData(trimBox));
        return this;
    }

    public CGRect getArtBox() {
        if (this.has(Keys.ArtBox())) {
            NSData val = this.get(Keys.ArtBox(), NSData.class);
            return val.getStructData(CGRect.class);
        }
        return null;
    }

    public CGPDFBoxOptions setArtBox(CGRect artBox) {
        this.set(Keys.ArtBox(), (NativeObject)new NSData(artBox));
        return this;
    }

    @Library(value="CoreGraphics")
    public static class Keys {
        @GlobalValue(symbol="kCGPDFContextMediaBox", optional=true)
        public static native CFString MediaBox();

        @GlobalValue(symbol="kCGPDFContextCropBox", optional=true)
        public static native CFString CropBox();

        @GlobalValue(symbol="kCGPDFContextBleedBox", optional=true)
        public static native CFString BleedBox();

        @GlobalValue(symbol="kCGPDFContextTrimBox", optional=true)
        public static native CFString TrimBox();

        @GlobalValue(symbol="kCGPDFContextArtBox", optional=true)
        public static native CFString ArtBox();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CGPDFBoxOptions> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CGPDFBoxOptions> list = new ArrayList<CGPDFBoxOptions>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CGPDFBoxOptions(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CGPDFBoxOptions> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CGPDFBoxOptions i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CGPDFBoxOptions toObject(Class<CGPDFBoxOptions> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CGPDFBoxOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CGPDFBoxOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

