/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGPDFContextOutputIntent;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreGraphics")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CGPDFContextOptions
extends CFDictionaryWrapper {
    CGPDFContextOptions(CFDictionary data) {
        super(data);
    }

    public CGPDFContextOptions() {
    }

    public CGPDFContextOptions setKeywords(String ... keywords) {
        CFMutableArray list = CFMutableArray.create();
        for (String keyword : keywords) {
            ((CFArray)list).add(new CFString(keyword));
        }
        this.set(Keys.Keywords(), list);
        return this;
    }

    public boolean has(CFString key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFString key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public CGPDFContextOptions set(CFString key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public String getTitle() {
        if (this.has(Keys.Title())) {
            CFString val = this.get(Keys.Title(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CGPDFContextOptions setTitle(String title) {
        this.set(Keys.Title(), new CFString(title));
        return this;
    }

    public String getAuthor() {
        if (this.has(Keys.Author())) {
            CFString val = this.get(Keys.Author(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CGPDFContextOptions setAuthor(String author) {
        this.set(Keys.Author(), new CFString(author));
        return this;
    }

    public String getSubject() {
        if (this.has(Keys.Subject())) {
            CFString val = this.get(Keys.Subject(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CGPDFContextOptions setSubject(String subject) {
        this.set(Keys.Subject(), new CFString(subject));
        return this;
    }

    public String getKeywords() {
        if (this.has(Keys.Keywords())) {
            CFString val = this.get(Keys.Keywords(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CGPDFContextOptions setKeywords(String keywords) {
        this.set(Keys.Keywords(), new CFString(keywords));
        return this;
    }

    public String getCreator() {
        if (this.has(Keys.Creator())) {
            CFString val = this.get(Keys.Creator(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CGPDFContextOptions setCreator(String creator) {
        this.set(Keys.Creator(), new CFString(creator));
        return this;
    }

    public String getOwnerPassword() {
        if (this.has(Keys.OwnerPassword())) {
            CFString val = this.get(Keys.OwnerPassword(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CGPDFContextOptions setOwnerPassword(String ownerPassword) {
        this.set(Keys.OwnerPassword(), new CFString(ownerPassword));
        return this;
    }

    public String getUserPassword() {
        if (this.has(Keys.UserPassword())) {
            CFString val = this.get(Keys.UserPassword(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CGPDFContextOptions setUserPassword(String userPassword) {
        this.set(Keys.UserPassword(), new CFString(userPassword));
        return this;
    }

    public int getEncryptionKeyLength() {
        if (this.has(Keys.EncryptionKeyLength())) {
            CFNumber val = this.get(Keys.EncryptionKeyLength(), CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    public CGPDFContextOptions setEncryptionKeyLength(int encryptionKeyLength) {
        this.set(Keys.EncryptionKeyLength(), CFNumber.valueOf(encryptionKeyLength));
        return this;
    }

    public boolean allowsPrinting() {
        if (this.has(Keys.AllowsPrinting())) {
            CFBoolean val = this.get(Keys.AllowsPrinting(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGPDFContextOptions setAllowsPrinting(boolean allowsPrinting) {
        this.set(Keys.AllowsPrinting(), CFBoolean.valueOf(allowsPrinting));
        return this;
    }

    public boolean allowsCopying() {
        if (this.has(Keys.AllowsCopying())) {
            CFBoolean val = this.get(Keys.AllowsCopying(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGPDFContextOptions setAllowsCopying(boolean allowsCopying) {
        this.set(Keys.AllowsCopying(), CFBoolean.valueOf(allowsCopying));
        return this;
    }

    public CGPDFContextOutputIntent getOutputIntent() {
        if (this.has(Keys.OutputIntent())) {
            CFDictionary val = this.get(Keys.OutputIntent(), CFDictionary.class);
            return new CGPDFContextOutputIntent(val);
        }
        return null;
    }

    public CGPDFContextOptions setOutputIntent(CGPDFContextOutputIntent outputIntent) {
        this.set(Keys.OutputIntent(), outputIntent.getDictionary());
        return this;
    }

    public List<CGPDFContextOutputIntent> getOutputIntents() {
        if (this.has(Keys.OutputIntents())) {
            CFDictionary[] array;
            CFArray val = this.get(Keys.OutputIntents(), CFArray.class);
            ArrayList<CGPDFContextOutputIntent> list = new ArrayList<CGPDFContextOutputIntent>();
            for (CFDictionary d : array = (CFDictionary[])val.toArray(CFDictionary.class)) {
                list.add(new CGPDFContextOutputIntent(d));
            }
            return list;
        }
        return null;
    }

    public CGPDFContextOptions setOutputIntents(List<CGPDFContextOutputIntent> outputIntents) {
        CFMutableArray val = CFMutableArray.create();
        for (CGPDFContextOutputIntent e : outputIntents) {
            ((CFArray)val).add(e.getDictionary());
        }
        this.set(Keys.OutputIntents(), val);
        return this;
    }

    @Library(value="CoreGraphics")
    public static class Keys {
        @GlobalValue(symbol="kCGPDFContextTitle", optional=true)
        public static native CFString Title();

        @GlobalValue(symbol="kCGPDFContextAuthor", optional=true)
        public static native CFString Author();

        @GlobalValue(symbol="kCGPDFContextSubject", optional=true)
        public static native CFString Subject();

        @GlobalValue(symbol="kCGPDFContextKeywords", optional=true)
        public static native CFString Keywords();

        @GlobalValue(symbol="kCGPDFContextCreator", optional=true)
        public static native CFString Creator();

        @GlobalValue(symbol="kCGPDFContextOwnerPassword", optional=true)
        public static native CFString OwnerPassword();

        @GlobalValue(symbol="kCGPDFContextUserPassword", optional=true)
        public static native CFString UserPassword();

        @GlobalValue(symbol="kCGPDFContextEncryptionKeyLength", optional=true)
        public static native CFString EncryptionKeyLength();

        @GlobalValue(symbol="kCGPDFContextAllowsPrinting", optional=true)
        public static native CFString AllowsPrinting();

        @GlobalValue(symbol="kCGPDFContextAllowsCopying", optional=true)
        public static native CFString AllowsCopying();

        @GlobalValue(symbol="kCGPDFContextOutputIntent", optional=true)
        public static native CFString OutputIntent();

        @GlobalValue(symbol="kCGPDFContextOutputIntents", optional=true)
        public static native CFString OutputIntents();

        @GlobalValue(symbol="kCGPDFContextAccessPermissions", optional=true)
        public static native CFString AccessPermissions();

        @GlobalValue(symbol="kCGPDFContextCreateLinearizedPDF", optional=true)
        public static native CFString CreateLinearizedPDF();

        @GlobalValue(symbol="kCGPDFContextCreatePDFA", optional=true)
        public static native CFString CreatePDFA();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CGPDFContextOptions> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CGPDFContextOptions> list = new ArrayList<CGPDFContextOptions>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CGPDFContextOptions(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CGPDFContextOptions> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CGPDFContextOptions i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CGPDFContextOptions toObject(Class<CGPDFContextOptions> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CGPDFContextOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CGPDFContextOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

