/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.coreimage.CIFilterAttribute;
import org.robovm.apple.coreimage.CIFilterCategory;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreImage")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CIFilterAttributes
extends NSDictionaryWrapper {
    CIFilterAttributes(NSDictionary data) {
        super(data);
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public String getName() {
        if (this.has(Keys.Name())) {
            NSString val = (NSString)this.get(Keys.Name());
            return val.toString();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.has(Keys.DisplayName())) {
            NSString val = (NSString)this.get(Keys.DisplayName());
            return val.toString();
        }
        return null;
    }

    public CIFilterAttribute getAttribute(String name) {
        NSString str = new NSString(name);
        if (this.has(str)) {
            NSDictionary val = (NSDictionary)this.get(str);
            return new CIFilterAttribute(val);
        }
        return null;
    }

    public List<CIFilterCategory> getCategories() {
        if (this.has(Keys.Categories())) {
            NSArray val = (NSArray)this.get(Keys.Categories());
            ArrayList<CIFilterCategory> list = new ArrayList<CIFilterCategory>();
            for (NSString str : val) {
                list.add(CIFilterCategory.valueOf(str));
            }
            return list;
        }
        return null;
    }

    @Library(value="CoreImage")
    public static class Keys {
        @GlobalValue(symbol="kCIAttributeFilterName", optional=true)
        public static native NSString Name();

        @GlobalValue(symbol="kCIAttributeFilterDisplayName", optional=true)
        public static native NSString DisplayName();

        @GlobalValue(symbol="kCIAttributeFilterAvailable_Mac", optional=true)
        public static native NSString Available_Mac();

        @GlobalValue(symbol="kCIAttributeFilterAvailable_iOS", optional=true)
        public static native NSString Available_iOS();

        @GlobalValue(symbol="kCIAttributeFilterCategories", optional=true)
        public static native NSString Categories();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CIFilterAttributes> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CIFilterAttributes> list = new ArrayList<CIFilterAttributes>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new CIFilterAttributes((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CIFilterAttributes> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (CIFilterAttributes i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CIFilterAttributes toObject(Class<CIFilterAttributes> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CIFilterAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(CIFilterAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

