/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corelocation;

import org.robovm.apple.corelocation.CLErrorCode;
import org.robovm.apple.corelocation.CLErrorUserInfoKey;
import org.robovm.apple.corelocation.CLRegion;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorUserInfo;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreLocation")
@StronglyLinked
public class CLError
extends NSError {
    private NSErrorUserInfo userInfo;

    protected CLError(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    private NSErrorUserInfo getCachedUserInfo() {
        if (this.userInfo == null) {
            this.userInfo = this.getUserInfo();
        }
        return this.userInfo;
    }

    @Override
    public CLErrorCode getErrorCode() {
        CLErrorCode code = null;
        try {
            code = CLErrorCode.valueOf(this.getCode());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return code;
    }

    public CLRegion getAlternateRegion() {
        if (this.getCachedUserInfo().has(CLErrorUserInfoKey.AlternateRegion)) {
            CLRegion val = (CLRegion)this.getCachedUserInfo().get(CLErrorUserInfoKey.AlternateRegion);
            return val;
        }
        return null;
    }

    @GlobalValue(symbol="kCLErrorDomain", optional=true)
    public static native String getClassDomain();

    static {
        Bro.bind(CLError.class);
    }

    public static class CLErrorPtr
    extends Ptr<CLError, CLErrorPtr> {
    }
}

