/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coremedia;

import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.coremedia.CMBlockBufferCustomBlockSource;
import org.robovm.apple.coremedia.CMBlockBufferFlags;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.MachineSizedUIntPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreMedia")
public class CMBlockBuffer
extends CFType {
    protected CMBlockBuffer() {
    }

    public static CMBlockBuffer create(int subBlockCapacity, CMBlockBufferFlags flags) throws OSStatusException {
        CMBlockBufferPtr ptr = new CMBlockBufferPtr();
        OSStatus status = CMBlockBuffer.create0(null, subBlockCapacity, flags, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMBlockBuffer)ptr.get();
    }

    public static CMBlockBuffer create(VoidPtr memoryBlock, @MachineSizedUInt long blockLength, CFAllocator blockAllocator, CMBlockBufferCustomBlockSource customBlockSource, @MachineSizedUInt long offsetToData, @MachineSizedUInt long dataLength, CMBlockBufferFlags flags) throws OSStatusException {
        CMBlockBufferPtr ptr = new CMBlockBufferPtr();
        OSStatus status = CMBlockBuffer.create0(null, memoryBlock, blockLength, blockAllocator, customBlockSource, offsetToData, dataLength, flags, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMBlockBuffer)ptr.get();
    }

    public static CMBlockBuffer create(CMBlockBuffer targetBuffer, @MachineSizedUInt long offsetToData, @MachineSizedUInt long dataLength, CMBlockBufferFlags flags) throws OSStatusException {
        CMBlockBufferPtr ptr = new CMBlockBufferPtr();
        OSStatus status = CMBlockBuffer.create0(null, targetBuffer, offsetToData, dataLength, flags, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMBlockBuffer)ptr.get();
    }

    public static CMBlockBuffer create(CMBlockBuffer sourceBuffer, CFAllocator blockAllocator, CMBlockBufferCustomBlockSource customBlockSource, @MachineSizedUInt long offsetToData, @MachineSizedUInt long dataLength, CMBlockBufferFlags flags) throws OSStatusException {
        CMBlockBufferPtr ptr = new CMBlockBufferPtr();
        OSStatus status = CMBlockBuffer.create0(null, sourceBuffer, blockAllocator, customBlockSource, offsetToData, dataLength, flags, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMBlockBuffer)ptr.get();
    }

    public void appendMemoryBlock(VoidPtr memoryBlock, long blockLength, CFAllocator blockAllocator, CMBlockBufferCustomBlockSource customBlockSource, long offsetToData, long dataLength, CMBlockBufferFlags flags) throws OSStatusException {
        OSStatus status = this.appendMemoryBlock0(memoryBlock, blockLength, blockAllocator, customBlockSource, offsetToData, dataLength, flags);
        OSStatusException.throwIfNecessary(status);
    }

    public void appendBufferReference(CMBlockBuffer targetBBuf, long offsetToData, long dataLength, CMBlockBufferFlags flags) throws OSStatusException {
        OSStatus status = this.appendBufferReference0(targetBBuf, offsetToData, dataLength, flags);
        OSStatusException.throwIfNecessary(status);
    }

    public void assureBlockMemory() throws OSStatusException {
        OSStatus status = this.assureBlockMemory0();
        OSStatusException.throwIfNecessary(status);
    }

    public BytePtr accessDataBytes(long offset, @MachineSizedUInt long length, VoidPtr temporaryBlock) throws OSStatusException {
        BytePtr.BytePtrPtr ptr = new BytePtr.BytePtrPtr();
        OSStatus status = CMBlockBuffer.accessDataBytes0(this, offset, length, temporaryBlock, ptr);
        OSStatusException.throwIfNecessary(status);
        return (BytePtr)ptr.get();
    }

    public void copyDataBytes(long offsetToData, long dataLength, VoidPtr destination) throws OSStatusException {
        OSStatus status = this.copyDataBytes0(offsetToData, dataLength, destination);
        OSStatusException.throwIfNecessary(status);
    }

    public void replaceDataBytes(VoidPtr sourceBytes, long offsetIntoDestination, long dataLength) throws OSStatusException {
        OSStatus status = CMBlockBuffer.replaceDataBytes0(sourceBytes, this, offsetIntoDestination, dataLength);
        OSStatusException.throwIfNecessary(status);
    }

    public void fillDataBytes(byte fillByte, long offsetIntoDestination, long dataLength) throws OSStatusException {
        OSStatus status = CMBlockBuffer.fillDataBytes0(fillByte, this, offsetIntoDestination, dataLength);
        OSStatusException.throwIfNecessary(status);
    }

    @Bridge(symbol="CMBlockBufferCreateEmpty", optional=true)
    protected static native OSStatus create0(CFAllocator var0, int var1, CMBlockBufferFlags var2, CMBlockBufferPtr var3);

    @Bridge(symbol="CMBlockBufferCreateWithMemoryBlock", optional=true)
    protected static native OSStatus create0(CFAllocator var0, VoidPtr var1, @MachineSizedUInt long var2, CFAllocator var4, CMBlockBufferCustomBlockSource var5, @MachineSizedUInt long var6, @MachineSizedUInt long var8, CMBlockBufferFlags var10, CMBlockBufferPtr var11);

    @Bridge(symbol="CMBlockBufferCreateWithBufferReference", optional=true)
    protected static native OSStatus create0(CFAllocator var0, CMBlockBuffer var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, CMBlockBufferFlags var6, CMBlockBufferPtr var7);

    @Bridge(symbol="CMBlockBufferCreateContiguous", optional=true)
    protected static native OSStatus create0(CFAllocator var0, CMBlockBuffer var1, CFAllocator var2, CMBlockBufferCustomBlockSource var3, @MachineSizedUInt long var4, @MachineSizedUInt long var6, CMBlockBufferFlags var8, CMBlockBufferPtr var9);

    @Bridge(symbol="CMBlockBufferGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CMBlockBufferAppendMemoryBlock", optional=true)
    protected native OSStatus appendMemoryBlock0(VoidPtr var1, @MachineSizedUInt long var2, CFAllocator var4, CMBlockBufferCustomBlockSource var5, @MachineSizedUInt long var6, @MachineSizedUInt long var8, CMBlockBufferFlags var10);

    @Bridge(symbol="CMBlockBufferAppendBufferReference", optional=true)
    protected native OSStatus appendBufferReference0(CMBlockBuffer var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, CMBlockBufferFlags var6);

    @Bridge(symbol="CMBlockBufferAssureBlockMemory", optional=true)
    protected native OSStatus assureBlockMemory0();

    @Bridge(symbol="CMBlockBufferAccessDataBytes", optional=true)
    protected static native OSStatus accessDataBytes0(CMBlockBuffer var0, @MachineSizedUInt long var1, @MachineSizedUInt long var3, VoidPtr var5, BytePtr.BytePtrPtr var6);

    @Bridge(symbol="CMBlockBufferCopyDataBytes", optional=true)
    protected native OSStatus copyDataBytes0(@MachineSizedUInt long var1, @MachineSizedUInt long var3, VoidPtr var5);

    @Bridge(symbol="CMBlockBufferReplaceDataBytes", optional=true)
    protected static native OSStatus replaceDataBytes0(VoidPtr var0, CMBlockBuffer var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4);

    @Bridge(symbol="CMBlockBufferFillDataBytes", optional=true)
    protected static native OSStatus fillDataBytes0(byte var0, CMBlockBuffer var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4);

    @Bridge(symbol="CMBlockBufferGetDataPointer", optional=true)
    protected native OSStatus getDataPointer0(@MachineSizedUInt long var1, MachineSizedUIntPtr var3, MachineSizedUIntPtr var4, BytePtr.BytePtrPtr var5);

    @Bridge(symbol="CMBlockBufferGetDataLength", optional=true)
    @MachineSizedUInt
    public native long getDataLength();

    @Bridge(symbol="CMBlockBufferIsRangeContiguous", optional=true)
    public native boolean isRangeContiguous(@MachineSizedUInt long var1, @MachineSizedUInt long var3);

    @Bridge(symbol="CMBlockBufferIsEmpty", optional=true)
    public native boolean isEmpty();

    static {
        Bro.bind(CMBlockBuffer.class);
    }

    public static class CMBlockBufferPtr
    extends Ptr<CMBlockBuffer, CMBlockBufferPtr> {
    }
}

