/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coremedia;

import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.coremedia.CMMetadataBaseDataType;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreMedia")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CMMetadataDataType
extends CocoaUtility {
    private String dataType;

    public CMMetadataDataType(String dataType) {
        this.dataType = dataType;
    }

    public void register(String description, List<String> conformingDataTypes) throws OSStatusException {
        OSStatus status = CMMetadataDataType.registerDataType0(this.dataType, description, conformingDataTypes);
        OSStatusException.throwIfNecessary(status);
    }

    public static void registerDataType(String dataType, String description, List<String> conformingDataTypes) throws OSStatusException {
        OSStatus status = CMMetadataDataType.registerDataType0(dataType, description, conformingDataTypes);
        OSStatusException.throwIfNecessary(status);
    }

    public boolean isRegistered() {
        return CMMetadataDataType.isDataTypeRegistered(this.dataType);
    }

    public String getDescription() {
        return CMMetadataDataType.getDataTypeDescription(this.dataType);
    }

    public List<String> getConformingDataTypes() {
        return CMMetadataDataType.getConformingDataTypes(this.dataType);
    }

    public boolean conformsToDataType(String conformsToDataType) {
        return CMMetadataDataType.doesDataTypeConformToDataType(this.dataType, conformsToDataType);
    }

    public boolean isBaseDataType() {
        return CMMetadataDataType.isDataTypeBaseDataType(this.dataType);
    }

    public CMMetadataBaseDataType getConformingBaseDataType() {
        return CMMetadataDataType.getBaseDataTypeForConformingDataType(this.dataType);
    }

    @Bridge(symbol="CMMetadataDataTypeRegistryRegisterDataType", optional=true)
    protected static native OSStatus registerDataType0(String var0, String var1, @org.robovm.rt.bro.annotation.Marshaler(value=CFArray.AsStringListMarshaler.class) List<String> var2);

    @Bridge(symbol="CMMetadataDataTypeRegistryDataTypeIsRegistered", optional=true)
    public static native boolean isDataTypeRegistered(String var0);

    @Bridge(symbol="CMMetadataDataTypeRegistryGetDataTypeDescription", optional=true)
    public static native String getDataTypeDescription(String var0);

    @Bridge(symbol="CMMetadataDataTypeRegistryGetConformingDataTypes", optional=true)
    @org.robovm.rt.bro.annotation.Marshaler(value=CFArray.AsStringListMarshaler.class)
    public static native List<String> getConformingDataTypes(String var0);

    @Bridge(symbol="CMMetadataDataTypeRegistryDataTypeConformsToDataType", optional=true)
    public static native boolean doesDataTypeConformToDataType(String var0, String var1);

    @Bridge(symbol="CMMetadataDataTypeRegistryGetBaseDataTypes", optional=true)
    @org.robovm.rt.bro.annotation.Marshaler(value=CMMetadataBaseDataType.AsListMarshaler.class)
    public static native List<CMMetadataBaseDataType> getBaseDataTypes();

    @Bridge(symbol="CMMetadataDataTypeRegistryDataTypeIsBaseDataType", optional=true)
    public static native boolean isDataTypeBaseDataType(String var0);

    @Bridge(symbol="CMMetadataDataTypeRegistryGetBaseDataTypeForConformingDataType", optional=true)
    public static native CMMetadataBaseDataType getBaseDataTypeForConformingDataType(String var0);

    public String toString() {
        return this.dataType;
    }

    static {
        Bro.bind(CMMetadataDataType.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CMMetadataDataType toObject(Class<CMMetadataDataType> cls, long handle, long flags) {
            CFString o = (CFString)CFType.Marshaler.toObject(CFString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CMMetadataDataType(o.toString());
        }

        @MarshalsPointer
        public static long toNative(CMMetadataDataType o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(new CFString(o.dataType), flags);
        }
    }
}

