/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreml;

import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.coreml.MLFeatureType;
import org.robovm.apple.coreml.MLFeatureValueImageOption;
import org.robovm.apple.coreml.MLImageConstraint;
import org.robovm.apple.coreml.MLMultiArray;
import org.robovm.apple.coreml.MLSequence;
import org.robovm.apple.corevideo.CVPixelBuffer;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSecureCoding;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.imageio.CGImagePropertyOrientation;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreML")
@NativeClass
public class MLFeatureValue
extends NSObject
implements NSSecureCoding {
    public MLFeatureValue() {
    }

    protected MLFeatureValue(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected MLFeatureValue(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public MLFeatureValue(long value) {
        super(null, MLFeatureValue.create(value));
        MLFeatureValue.retain(this.getHandle());
    }

    public MLFeatureValue(double value) {
        super(null, MLFeatureValue.create(value));
        MLFeatureValue.retain(this.getHandle());
    }

    public MLFeatureValue(String value) {
        super(null, MLFeatureValue.create(value));
        MLFeatureValue.retain(this.getHandle());
    }

    public MLFeatureValue(MLMultiArray value) {
        super(null, MLFeatureValue.create(value));
        MLFeatureValue.retain(this.getHandle());
    }

    public MLFeatureValue(CVPixelBuffer value) {
        super(null, MLFeatureValue.create(value));
        MLFeatureValue.retain(this.getHandle());
    }

    public MLFeatureValue(MLSequence sequence) {
        super(null, MLFeatureValue.create(sequence));
        MLFeatureValue.retain(this.getHandle());
    }

    public MLFeatureValue(MLFeatureType type) {
        super(null, MLFeatureValue.create(type));
        MLFeatureValue.retain(this.getHandle());
    }

    public MLFeatureValue(NSDictionary<?, NSNumber> value) throws NSErrorException {
        this(value, new NSError.NSErrorPtr());
    }

    private MLFeatureValue(NSDictionary<?, NSNumber> value, NSError.NSErrorPtr ptr) throws NSErrorException {
        super(null, MLFeatureValue.create(value, ptr));
        MLFeatureValue.retain(this.getHandle());
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
    }

    public MLFeatureValue(NSURL url, @MachineSizedSInt long pixelsWide, @MachineSizedSInt long pixelsHigh, int pixelFormatType, MLFeatureValueImageOption options) throws NSErrorException {
        this(url, pixelsWide, pixelsHigh, pixelFormatType, options, new NSError.NSErrorPtr());
    }

    private MLFeatureValue(NSURL url, @MachineSizedSInt long pixelsWide, @MachineSizedSInt long pixelsHigh, int pixelFormatType, MLFeatureValueImageOption options, NSError.NSErrorPtr ptr) throws NSErrorException {
        super(null, MLFeatureValue.create(url, pixelsWide, pixelsHigh, pixelFormatType, options, ptr));
        MLFeatureValue.retain(this.getHandle());
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
    }

    public MLFeatureValue(NSURL url, MLImageConstraint constraint, MLFeatureValueImageOption options) throws NSErrorException {
        this(url, constraint, options, new NSError.NSErrorPtr());
    }

    private MLFeatureValue(NSURL url, MLImageConstraint constraint, MLFeatureValueImageOption options, NSError.NSErrorPtr ptr) throws NSErrorException {
        super(null, MLFeatureValue.create(url, constraint, options, ptr));
        MLFeatureValue.retain(this.getHandle());
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
    }

    public MLFeatureValue(CGImage cgImage, @MachineSizedSInt long pixelsWide, @MachineSizedSInt long pixelsHigh, int pixelFormatType, MLFeatureValueImageOption options) throws NSErrorException {
        this(cgImage, pixelsWide, pixelsHigh, pixelFormatType, options, new NSError.NSErrorPtr());
    }

    private MLFeatureValue(CGImage cgImage, @MachineSizedSInt long pixelsWide, @MachineSizedSInt long pixelsHigh, int pixelFormatType, MLFeatureValueImageOption options, NSError.NSErrorPtr ptr) throws NSErrorException {
        super(null, MLFeatureValue.create(cgImage, pixelsWide, pixelsHigh, pixelFormatType, options, ptr));
        MLFeatureValue.retain(this.getHandle());
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
    }

    public MLFeatureValue(CGImage cgImage, MLImageConstraint constraint, MLFeatureValueImageOption options) throws NSErrorException {
        this(cgImage, constraint, options, new NSError.NSErrorPtr());
    }

    private MLFeatureValue(CGImage cgImage, MLImageConstraint constraint, MLFeatureValueImageOption options, NSError.NSErrorPtr ptr) throws NSErrorException {
        super(null, MLFeatureValue.create(cgImage, constraint, options, ptr));
        MLFeatureValue.retain(this.getHandle());
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
    }

    public MLFeatureValue(NSURL url, CGImagePropertyOrientation orientation, @MachineSizedSInt long pixelsWide, @MachineSizedSInt long pixelsHigh, int pixelFormatType, MLFeatureValueImageOption options) throws NSErrorException {
        this(url, orientation, pixelsWide, pixelsHigh, pixelFormatType, options, new NSError.NSErrorPtr());
    }

    private MLFeatureValue(NSURL url, CGImagePropertyOrientation orientation, @MachineSizedSInt long pixelsWide, @MachineSizedSInt long pixelsHigh, int pixelFormatType, MLFeatureValueImageOption options, NSError.NSErrorPtr ptr) throws NSErrorException {
        super(null, MLFeatureValue.create(url, orientation, pixelsWide, pixelsHigh, pixelFormatType, options, ptr));
        MLFeatureValue.retain(this.getHandle());
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
    }

    public MLFeatureValue(NSURL url, CGImagePropertyOrientation orientation, MLImageConstraint constraint, MLFeatureValueImageOption options) throws NSErrorException {
        this(url, orientation, constraint, options, new NSError.NSErrorPtr());
    }

    private MLFeatureValue(NSURL url, CGImagePropertyOrientation orientation, MLImageConstraint constraint, MLFeatureValueImageOption options, NSError.NSErrorPtr ptr) throws NSErrorException {
        super(null, MLFeatureValue.create(url, orientation, constraint, options, ptr));
        MLFeatureValue.retain(this.getHandle());
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
    }

    public MLFeatureValue(CGImage cgImage, CGImagePropertyOrientation orientation, @MachineSizedSInt long pixelsWide, @MachineSizedSInt long pixelsHigh, int pixelFormatType, MLFeatureValueImageOption options) throws NSErrorException {
        this(cgImage, orientation, pixelsWide, pixelsHigh, pixelFormatType, options, new NSError.NSErrorPtr());
    }

    private MLFeatureValue(CGImage cgImage, CGImagePropertyOrientation orientation, @MachineSizedSInt long pixelsWide, @MachineSizedSInt long pixelsHigh, int pixelFormatType, MLFeatureValueImageOption options, NSError.NSErrorPtr ptr) throws NSErrorException {
        super(null, MLFeatureValue.create(cgImage, orientation, pixelsWide, pixelsHigh, pixelFormatType, options, ptr));
        MLFeatureValue.retain(this.getHandle());
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
    }

    public MLFeatureValue(CGImage cgImage, CGImagePropertyOrientation orientation, MLImageConstraint constraint, MLFeatureValueImageOption options) throws NSErrorException {
        this(cgImage, orientation, constraint, options, new NSError.NSErrorPtr());
    }

    private MLFeatureValue(CGImage cgImage, CGImagePropertyOrientation orientation, MLImageConstraint constraint, MLFeatureValueImageOption options, NSError.NSErrorPtr ptr) throws NSErrorException {
        super(null, MLFeatureValue.create(cgImage, orientation, constraint, options, ptr));
        MLFeatureValue.retain(this.getHandle());
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
    }

    @Method(selector="initWithCoder:")
    public MLFeatureValue(NSCoder coder) {
        super(null);
        this.initObject(this.init(coder));
    }

    @Property(selector="type")
    public native MLFeatureType getType();

    @Property(selector="isUndefined")
    public native boolean isUndefined();

    @Property(selector="int64Value")
    public native long getInt64Value();

    @Property(selector="doubleValue")
    public native double getDoubleValue();

    @Property(selector="stringValue")
    public native String getStringValue();

    @Property(selector="multiArrayValue")
    public native MLMultiArray getMultiArrayValue();

    @Property(selector="dictionaryValue")
    public native NSDictionary<?, NSNumber> getDictionaryValue();

    @Property(selector="imageBufferValue")
    public native CVPixelBuffer getImageBufferValue();

    @Property(selector="sequenceValue")
    public native MLSequence getSequenceValue();

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    @Method(selector="isEqualToFeatureValue:")
    public native boolean isEqualToFeatureValue(MLFeatureValue var1);

    @Method(selector="featureValueWithInt64:")
    @Pointer
    protected static native long create(long var0);

    @Method(selector="featureValueWithDouble:")
    @Pointer
    protected static native long create(double var0);

    @Method(selector="featureValueWithString:")
    @Pointer
    protected static native long create(String var0);

    @Method(selector="featureValueWithMultiArray:")
    @Pointer
    protected static native long create(MLMultiArray var0);

    @Method(selector="featureValueWithPixelBuffer:")
    @Pointer
    protected static native long create(CVPixelBuffer var0);

    @Method(selector="featureValueWithSequence:")
    @Pointer
    protected static native long create(MLSequence var0);

    @Method(selector="undefinedFeatureValueWithType:")
    @Pointer
    protected static native long create(MLFeatureType var0);

    @Method(selector="featureValueWithDictionary:error:")
    @Pointer
    protected static native long create(NSDictionary<?, NSNumber> var0, NSError.NSErrorPtr var1);

    @Method(selector="featureValueWithImageAtURL:pixelsWide:pixelsHigh:pixelFormatType:options:error:")
    @Pointer
    protected static native long create(NSURL var0, @MachineSizedSInt long var1, @MachineSizedSInt long var3, int var5, MLFeatureValueImageOption var6, NSError.NSErrorPtr var7);

    @Method(selector="featureValueWithImageAtURL:constraint:options:error:")
    @Pointer
    protected static native long create(NSURL var0, MLImageConstraint var1, MLFeatureValueImageOption var2, NSError.NSErrorPtr var3);

    @Method(selector="featureValueWithCGImage:pixelsWide:pixelsHigh:pixelFormatType:options:error:")
    @Pointer
    protected static native long create(CGImage var0, @MachineSizedSInt long var1, @MachineSizedSInt long var3, int var5, MLFeatureValueImageOption var6, NSError.NSErrorPtr var7);

    @Method(selector="featureValueWithCGImage:constraint:options:error:")
    @Pointer
    protected static native long create(CGImage var0, MLImageConstraint var1, MLFeatureValueImageOption var2, NSError.NSErrorPtr var3);

    @Method(selector="featureValueWithImageAtURL:orientation:pixelsWide:pixelsHigh:pixelFormatType:options:error:")
    @Pointer
    protected static native long create(NSURL var0, CGImagePropertyOrientation var1, @MachineSizedSInt long var2, @MachineSizedSInt long var4, int var6, MLFeatureValueImageOption var7, NSError.NSErrorPtr var8);

    @Method(selector="featureValueWithImageAtURL:orientation:constraint:options:error:")
    @Pointer
    protected static native long create(NSURL var0, CGImagePropertyOrientation var1, MLImageConstraint var2, MLFeatureValueImageOption var3, NSError.NSErrorPtr var4);

    @Method(selector="featureValueWithCGImage:orientation:pixelsWide:pixelsHigh:pixelFormatType:options:error:")
    @Pointer
    protected static native long create(CGImage var0, CGImagePropertyOrientation var1, @MachineSizedSInt long var2, @MachineSizedSInt long var4, int var6, MLFeatureValueImageOption var7, NSError.NSErrorPtr var8);

    @Method(selector="featureValueWithCGImage:orientation:constraint:options:error:")
    @Pointer
    protected static native long create(CGImage var0, CGImagePropertyOrientation var1, MLImageConstraint var2, MLFeatureValueImageOption var3, NSError.NSErrorPtr var4);

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    static {
        ObjCRuntime.bind(MLFeatureValue.class);
    }

    public static class MLFeatureValuePtr
    extends Ptr<MLFeatureValue, MLFeatureValuePtr> {
    }
}

